/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonStackBuilder
extends PanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[]{FormFactory.BUTTON_COLSPEC};
    private static final RowSpec[] ROW_SPECS = new RowSpec[0];
    private static final String NARROW_KEY = "jgoodies.isNarrow";

    public ButtonStackBuilder() {
        this(new JPanel(null));
    }

    public ButtonStackBuilder(JPanel jPanel) {
        this(new FormLayout(COL_SPECS, ROW_SPECS), jPanel);
    }

    public ButtonStackBuilder(FormLayout formLayout, JPanel jPanel) {
        super(formLayout, jPanel);
        this.setOpaque(false);
    }

    public void addButtons(JButton[] jButtonArray) {
        for (int i2 = 0; i2 < jButtonArray.length; ++i2) {
            this.addGridded(jButtonArray[i2]);
            if (i2 >= jButtonArray.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addFixed(JComponent jComponent) {
        this.getLayout().appendRow(FormFactory.PREF_ROWSPEC);
        this.add(jComponent);
        this.nextRow();
    }

    public void addGridded(JComponent jComponent) {
        this.getLayout().appendRow(FormFactory.PREF_ROWSPEC);
        this.getLayout().addGroupedRow(this.getRow());
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(jComponent);
        this.nextRow();
    }

    public void addGlue() {
        this.appendGlueRow();
        this.nextRow();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapRow();
        this.nextRow();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapRow();
        this.nextRow();
    }

    public void addStrut(ConstantSize constantSize) {
        this.getLayout().appendRow(new RowSpec(RowSpec.TOP, constantSize, 0.0));
        this.nextRow();
    }

    public void addButton(JButton jButton) {
        this.addButton(new JButton[]{jButton});
    }

    public void addButton(JButton jButton, JButton jButton2) {
        this.addButton(new JButton[]{jButton, jButton2});
    }

    public void addButton(JButton jButton, JButton jButton2, JButton jButton3) {
        this.addButton(new JButton[]{jButton, jButton2, jButton3});
    }

    public void addButton(JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
        this.addButton(new JButton[]{jButton, jButton2, jButton3, jButton4});
    }

    public void addButton(JButton[] jButtonArray) {
        this.addButtons(jButtonArray);
    }

    public void addButton(Action action) {
        this.addButton(new Action[]{action});
    }

    public void addButton(Action action, Action action2) {
        this.addButton(new Action[]{action, action2});
    }

    public void addButton(Action action, Action action2, Action action3) {
        this.addButton(new Action[]{action, action2, action3});
    }

    public void addButton(Action action, Action action2, Action action3, Action action4) {
        this.addButton(new Action[]{action, action2, action3, action4});
    }

    public void addButton(Action[] actionArray) {
        JButton[] jButtonArray = new JButton[actionArray.length];
        for (int i2 = 0; i2 < actionArray.length; ++i2) {
            jButtonArray[i2] = new JButton(actionArray[i2]);
        }
        this.addButtons(jButtonArray);
    }
}

