/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.ConstantSize$Unit;
import com.jgoodies.forms.layout.FormLayout$Measure;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;

public final class ConstantSize
implements Size,
Serializable {
    public static final ConstantSize$Unit PIXEL = new ConstantSize$Unit("Pixel", "px", null, true, null);
    public static final ConstantSize$Unit POINT = new ConstantSize$Unit("Point", "pt", null, true, null);
    public static final ConstantSize$Unit DIALOG_UNITS_X = new ConstantSize$Unit("Dialog units X", "dluX", "dlu", true, null);
    public static final ConstantSize$Unit DIALOG_UNITS_Y = new ConstantSize$Unit("Dialog units Y", "dluY", "dlu", true, null);
    public static final ConstantSize$Unit MILLIMETER = new ConstantSize$Unit("Millimeter", "mm", null, false, null);
    public static final ConstantSize$Unit CENTIMETER = new ConstantSize$Unit("Centimeter", "cm", null, false, null);
    public static final ConstantSize$Unit INCH = new ConstantSize$Unit("Inch", "in", null, false, null);
    public static final ConstantSize$Unit PX = PIXEL;
    public static final ConstantSize$Unit PT = POINT;
    public static final ConstantSize$Unit DLUX = DIALOG_UNITS_X;
    public static final ConstantSize$Unit DLUY = DIALOG_UNITS_Y;
    public static final ConstantSize$Unit MM = MILLIMETER;
    public static final ConstantSize$Unit CM = CENTIMETER;
    public static final ConstantSize$Unit IN = INCH;
    private static final ConstantSize$Unit[] VALUES = new ConstantSize$Unit[]{PIXEL, POINT, DIALOG_UNITS_X, DIALOG_UNITS_Y, MILLIMETER, CENTIMETER, INCH};
    private final double value;
    private final ConstantSize$Unit unit;

    public ConstantSize(int n2, ConstantSize$Unit constantSize$Unit) {
        this.value = n2;
        this.unit = constantSize$Unit;
    }

    public ConstantSize(double d2, ConstantSize$Unit constantSize$Unit) {
        this.value = d2;
        this.unit = constantSize$Unit;
    }

    static ConstantSize valueOf(String string, boolean bl2) {
        String[] stringArray = ConstantSize.splitValueAndUnit(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        ConstantSize$Unit constantSize$Unit = ConstantSize$Unit.valueOf(string3, bl2);
        double d2 = Double.parseDouble(string2);
        if (constantSize$Unit.requiresIntegers && d2 != (double)((int)d2)) {
            throw new IllegalArgumentException(constantSize$Unit.toString() + " value " + string2 + " must be an integer.");
        }
        return new ConstantSize(d2, constantSize$Unit);
    }

    static ConstantSize dluX(int n2) {
        return new ConstantSize(n2, DLUX);
    }

    static ConstantSize dluY(int n2) {
        return new ConstantSize(n2, DLUY);
    }

    public double getValue() {
        return this.value;
    }

    public ConstantSize$Unit getUnit() {
        return this.unit;
    }

    public int getPixelSize(Component component) {
        if (this.unit == PIXEL) {
            return this.intValue();
        }
        if (this.unit == POINT) {
            return Sizes.pointAsPixel(this.intValue(), component);
        }
        if (this.unit == INCH) {
            return Sizes.inchAsPixel(this.value, component);
        }
        if (this.unit == MILLIMETER) {
            return Sizes.millimeterAsPixel(this.value, component);
        }
        if (this.unit == CENTIMETER) {
            return Sizes.centimeterAsPixel(this.value, component);
        }
        if (this.unit == DIALOG_UNITS_X) {
            return Sizes.dialogUnitXAsPixel(this.intValue(), component);
        }
        if (this.unit == DIALOG_UNITS_Y) {
            return Sizes.dialogUnitYAsPixel(this.intValue(), component);
        }
        throw new IllegalStateException("Invalid unit " + this.unit);
    }

    public int maximumSize(Container container, List list, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2, FormLayout$Measure formLayout$Measure3) {
        return this.getPixelSize(container);
    }

    public boolean compressible() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConstantSize)) {
            return false;
        }
        ConstantSize constantSize = (ConstantSize)object;
        return this.value == constantSize.value && this.unit == constantSize.unit;
    }

    public int hashCode() {
        return new Double(this.value).hashCode() + 37 * this.unit.hashCode();
    }

    public String toString() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.abbreviation() : Double.toString(this.value) + this.unit.abbreviation();
    }

    public String encode() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.encode() : Double.toString(this.value) + this.unit.encode();
    }

    private int intValue() {
        return (int)Math.round(this.value);
    }

    private static String[] splitValueAndUnit(String string) {
        int n2;
        int n3;
        String[] stringArray = new String[2];
        for (n3 = n2 = string.length(); n3 > 0 && Character.isLetter(string.charAt(n3 - 1)); --n3) {
        }
        stringArray[0] = string.substring(0, n3);
        stringArray[1] = string.substring(n3);
        return stringArray;
    }

    static /* synthetic */ ConstantSize$Unit[] access$100() {
        return VALUES;
    }
}

