/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout$ComponentSizeCache;
import com.jgoodies.forms.layout.FormLayout$LayoutInfo;
import com.jgoodies.forms.layout.FormLayout$Measure;
import com.jgoodies.forms.layout.FormLayout$MinimumHeightMeasure;
import com.jgoodies.forms.layout.FormLayout$MinimumWidthMeasure;
import com.jgoodies.forms.layout.FormLayout$PreferredHeightMeasure;
import com.jgoodies.forms.layout.FormLayout$PreferredWidthMeasure;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.LayoutMap;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.FormUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public final class FormLayout
implements LayoutManager2,
Serializable {
    private final List colSpecs;
    private final List rowSpecs;
    private int[][] colGroupIndices;
    private int[][] rowGroupIndices;
    private final Map constraintMap;
    private boolean honorsVisibility = true;
    private transient List[] colComponents;
    private transient List[] rowComponents;
    private final FormLayout$ComponentSizeCache componentSizeCache;
    private final FormLayout$Measure minimumWidthMeasure;
    private final FormLayout$Measure minimumHeightMeasure;
    private final FormLayout$Measure preferredWidthMeasure;
    private final FormLayout$Measure preferredHeightMeasure;

    public FormLayout() {
        this(new ColumnSpec[0], new RowSpec[0]);
    }

    public FormLayout(String string) {
        this(string, LayoutMap.getRoot());
    }

    public FormLayout(String string, LayoutMap layoutMap) {
        this(ColumnSpec.decodeSpecs(string, layoutMap), new RowSpec[0]);
    }

    public FormLayout(String string, String string2) {
        this(string, string2, LayoutMap.getRoot());
    }

    public FormLayout(String string, String string2, LayoutMap layoutMap) {
        this(ColumnSpec.decodeSpecs(string, layoutMap), RowSpec.decodeSpecs(string2, layoutMap));
    }

    public FormLayout(ColumnSpec[] columnSpecArray) {
        this(columnSpecArray, new RowSpec[0]);
    }

    public FormLayout(ColumnSpec[] columnSpecArray, RowSpec[] rowSpecArray) {
        if (columnSpecArray == null) {
            throw new NullPointerException("The column specifications must not be null.");
        }
        if (rowSpecArray == null) {
            throw new NullPointerException("The row specifications must not be null.");
        }
        this.colSpecs = new ArrayList<ColumnSpec>(Arrays.asList(columnSpecArray));
        this.rowSpecs = new ArrayList<RowSpec>(Arrays.asList(rowSpecArray));
        this.colGroupIndices = new int[0][];
        this.rowGroupIndices = new int[0][];
        int n2 = columnSpecArray.length * rowSpecArray.length / 4;
        this.constraintMap = new HashMap(n2);
        this.componentSizeCache = new FormLayout$ComponentSizeCache(n2, null);
        this.minimumWidthMeasure = new FormLayout$MinimumWidthMeasure(this.componentSizeCache, null);
        this.minimumHeightMeasure = new FormLayout$MinimumHeightMeasure(this.componentSizeCache, null);
        this.preferredWidthMeasure = new FormLayout$PreferredWidthMeasure(this.componentSizeCache, null);
        this.preferredHeightMeasure = new FormLayout$PreferredHeightMeasure(this.componentSizeCache, null);
    }

    public int getColumnCount() {
        return this.colSpecs.size();
    }

    public ColumnSpec getColumnSpec(int n2) {
        return (ColumnSpec)this.colSpecs.get(n2 - 1);
    }

    public void setColumnSpec(int n2, ColumnSpec columnSpec) {
        if (columnSpec == null) {
            throw new NullPointerException("The column spec must not be null.");
        }
        this.colSpecs.set(n2 - 1, columnSpec);
    }

    public void appendColumn(ColumnSpec columnSpec) {
        if (columnSpec == null) {
            throw new NullPointerException("The column spec must not be null.");
        }
        this.colSpecs.add(columnSpec);
    }

    public void insertColumn(int n2, ColumnSpec columnSpec) {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("The column index " + n2 + "must be in the range [1, " + this.getColumnCount() + "].");
        }
        this.colSpecs.add(n2 - 1, columnSpec);
        this.shiftComponentsHorizontally(n2, false);
        this.adjustGroupIndices(this.colGroupIndices, n2, false);
    }

    public void removeColumn(int n2) {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("The column index " + n2 + " must be in the range [1, " + this.getColumnCount() + "].");
        }
        this.colSpecs.remove(n2 - 1);
        this.shiftComponentsHorizontally(n2, true);
        this.adjustGroupIndices(this.colGroupIndices, n2, true);
    }

    public int getRowCount() {
        return this.rowSpecs.size();
    }

    public RowSpec getRowSpec(int n2) {
        return (RowSpec)this.rowSpecs.get(n2 - 1);
    }

    public void setRowSpec(int n2, RowSpec rowSpec) {
        if (rowSpec == null) {
            throw new NullPointerException("The row spec must not be null.");
        }
        this.rowSpecs.set(n2 - 1, rowSpec);
    }

    public void appendRow(RowSpec rowSpec) {
        if (rowSpec == null) {
            throw new NullPointerException("The row spec must not be null.");
        }
        this.rowSpecs.add(rowSpec);
    }

    public void insertRow(int n2, RowSpec rowSpec) {
        if (n2 < 1 || n2 > this.getRowCount()) {
            throw new IndexOutOfBoundsException("The row index " + n2 + " must be in the range [1, " + this.getRowCount() + "].");
        }
        this.rowSpecs.add(n2 - 1, rowSpec);
        this.shiftComponentsVertically(n2, false);
        this.adjustGroupIndices(this.rowGroupIndices, n2, false);
    }

    public void removeRow(int n2) {
        if (n2 < 1 || n2 > this.getRowCount()) {
            throw new IndexOutOfBoundsException("The row index " + n2 + "must be in the range [1, " + this.getRowCount() + "].");
        }
        this.rowSpecs.remove(n2 - 1);
        this.shiftComponentsVertically(n2, true);
        this.adjustGroupIndices(this.rowGroupIndices, n2, true);
    }

    private void shiftComponentsHorizontally(int n2, boolean bl2) {
        int n3 = bl2 ? -1 : 1;
        for (Map.Entry entry : this.constraintMap.entrySet()) {
            CellConstraints cellConstraints = (CellConstraints)entry.getValue();
            int n4 = cellConstraints.gridX;
            int n5 = cellConstraints.gridWidth;
            int n6 = n4 + n5 - 1;
            if (n4 == n2 && bl2) {
                throw new IllegalStateException("The removed column " + n2 + " must not contain component origins.\n" + "Illegal component=" + entry.getKey());
            }
            if (n4 >= n2) {
                cellConstraints.gridX += n3;
                continue;
            }
            if (n6 < n2) continue;
            cellConstraints.gridWidth += n3;
        }
    }

    private void shiftComponentsVertically(int n2, boolean bl2) {
        int n3 = bl2 ? -1 : 1;
        for (Map.Entry entry : this.constraintMap.entrySet()) {
            CellConstraints cellConstraints = (CellConstraints)entry.getValue();
            int n4 = cellConstraints.gridY;
            int n5 = cellConstraints.gridHeight;
            int n6 = n4 + n5 - 1;
            if (n4 == n2 && bl2) {
                throw new IllegalStateException("The removed row " + n2 + " must not contain component origins.\n" + "Illegal component=" + entry.getKey());
            }
            if (n4 >= n2) {
                cellConstraints.gridY += n3;
                continue;
            }
            if (n6 < n2) continue;
            cellConstraints.gridHeight += n3;
        }
    }

    private void adjustGroupIndices(int[][] nArray, int n2, boolean bl2) {
        int n3 = bl2 ? -1 : 1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int[] nArray2 = nArray[i2];
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                int n4 = nArray2[i3];
                if (n4 == n2 && bl2) {
                    throw new IllegalStateException("The removed index " + n2 + " must not be grouped.");
                }
                if (n4 < n2) continue;
                int n5 = i3;
                nArray2[n5] = nArray2[n5] + n3;
            }
        }
    }

    public CellConstraints getConstraints(Component component) {
        return (CellConstraints)this.getConstraints0(component).clone();
    }

    private CellConstraints getConstraints0(Component component) {
        if (component == null) {
            throw new NullPointerException("The component must not be null.");
        }
        CellConstraints cellConstraints = (CellConstraints)this.constraintMap.get(component);
        if (cellConstraints == null) {
            throw new NullPointerException("The component has not been added to the container.");
        }
        return cellConstraints;
    }

    public void setConstraints(Component component, CellConstraints cellConstraints) {
        if (component == null) {
            throw new NullPointerException("The component must not be null.");
        }
        if (cellConstraints == null) {
            throw new NullPointerException("The constraints must not be null.");
        }
        cellConstraints.ensureValidGridBounds(this.getColumnCount(), this.getRowCount());
        this.constraintMap.put(component, cellConstraints.clone());
    }

    private void removeConstraints(Component component) {
        this.constraintMap.remove(component);
        this.componentSizeCache.removeEntry(component);
    }

    public int[][] getColumnGroups() {
        return this.deepClone(this.colGroupIndices);
    }

    public void setColumnGroups(int[][] nArray) {
        int n2 = this.getColumnCount();
        boolean[] blArray = new boolean[n2 + 1];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                int n3 = nArray[i2][i3];
                if (n3 < 1 || n3 > n2) {
                    throw new IndexOutOfBoundsException("Invalid column group index " + n3 + " in group " + (i2 + 1));
                }
                if (blArray[n3]) {
                    throw new IllegalArgumentException("Column index " + n3 + " must not be used in multiple column groups.");
                }
                blArray[n3] = true;
            }
        }
        this.colGroupIndices = this.deepClone(nArray);
    }

    public void addGroupedColumn(int n2) {
        Object object = this.getColumnGroups();
        if (((int[][])object).length == 0) {
            object = new int[][]{{n2}};
        } else {
            int n3 = ((int[][])object).length - 1;
            int[] nArray = object[n3];
            int n4 = nArray.length;
            int[] nArray2 = new int[n4 + 1];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            nArray2[n4] = n2;
            object[n3] = nArray2;
        }
        this.setColumnGroups((int[][])object);
    }

    public int[][] getRowGroups() {
        return this.deepClone(this.rowGroupIndices);
    }

    public void setRowGroups(int[][] nArray) {
        int n2 = this.getRowCount();
        boolean[] blArray = new boolean[n2 + 1];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                int n3 = nArray[i2][i3];
                if (n3 < 1 || n3 > n2) {
                    throw new IndexOutOfBoundsException("Invalid row group index " + n3 + " in group " + (i2 + 1));
                }
                if (blArray[n3]) {
                    throw new IllegalArgumentException("Row index " + n3 + " must not be used in multiple row groups.");
                }
                blArray[n3] = true;
            }
        }
        this.rowGroupIndices = this.deepClone(nArray);
    }

    public void addGroupedRow(int n2) {
        Object object = this.getRowGroups();
        if (((int[][])object).length == 0) {
            object = new int[][]{{n2}};
        } else {
            int n3 = ((int[][])object).length - 1;
            int[] nArray = object[n3];
            int n4 = nArray.length;
            int[] nArray2 = new int[n4 + 1];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            nArray2[n4] = n2;
            object[n3] = nArray2;
        }
        this.setRowGroups((int[][])object);
    }

    public boolean getHonorsVisibility() {
        return this.honorsVisibility;
    }

    public void setHonorsVisibility(boolean bl2) {
        boolean bl3 = this.getHonorsVisibility();
        if (bl3 == bl2) {
            return;
        }
        this.honorsVisibility = bl2;
        Set set = this.constraintMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        Component component = (Component)set.iterator().next();
        Container container = component.getParent();
        FormLayout.invalidateAndRepaint(container);
    }

    public void setHonorsVisibility(Component component, Boolean bl2) {
        CellConstraints cellConstraints = this.getConstraints0(component);
        if (FormUtils.equals(bl2, cellConstraints.honorsVisibility)) {
            return;
        }
        cellConstraints.honorsVisibility = bl2;
        FormLayout.invalidateAndRepaint(component.getParent());
    }

    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("Use #addLayoutComponent(Component, Object) instead.");
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            this.setConstraints(component, new CellConstraints((String)object));
        } else if (object instanceof CellConstraints) {
            this.setConstraints(component, (CellConstraints)object);
        } else {
            if (object == null) {
                throw new NullPointerException("The constraints must not be null.");
            }
            throw new IllegalArgumentException("Illegal constraint type " + object.getClass());
        }
    }

    public void removeLayoutComponent(Component component) {
        this.removeConstraints(component);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.computeLayoutSize(container, this.minimumWidthMeasure, this.minimumHeightMeasure);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.computeLayoutSize(container, this.preferredWidthMeasure, this.preferredHeightMeasure);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.invalidateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.initializeColAndRowComponentLists();
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n2 = dimension.width - insets.left - insets.right;
            int n3 = dimension.height - insets.top - insets.bottom;
            int[] nArray = this.computeGridOrigins(container, n2, insets.left, this.colSpecs, this.colComponents, this.colGroupIndices, this.minimumWidthMeasure, this.preferredWidthMeasure);
            int[] nArray2 = this.computeGridOrigins(container, n3, insets.top, this.rowSpecs, this.rowComponents, this.rowGroupIndices, this.minimumHeightMeasure, this.preferredHeightMeasure);
            this.layoutComponents(nArray, nArray2);
        }
    }

    private void initializeColAndRowComponentLists() {
        int n2;
        this.colComponents = new List[this.getColumnCount()];
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            this.colComponents[n2] = new ArrayList();
        }
        this.rowComponents = new List[this.getRowCount()];
        for (n2 = 0; n2 < this.getRowCount(); ++n2) {
            this.rowComponents[n2] = new ArrayList();
        }
        for (Map.Entry entry : this.constraintMap.entrySet()) {
            CellConstraints cellConstraints;
            Component component = (Component)entry.getKey();
            if (!this.takeIntoAccount(component, cellConstraints = (CellConstraints)entry.getValue())) continue;
            if (cellConstraints.gridWidth == 1) {
                this.colComponents[cellConstraints.gridX - 1].add(component);
            }
            if (cellConstraints.gridHeight != 1) continue;
            this.rowComponents[cellConstraints.gridY - 1].add(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension computeLayoutSize(Container container, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.initializeColAndRowComponentLists();
            int[] nArray = this.maximumSizes(container, this.colSpecs, this.colComponents, this.minimumWidthMeasure, this.preferredWidthMeasure, formLayout$Measure);
            int[] nArray2 = this.maximumSizes(container, this.rowSpecs, this.rowComponents, this.minimumHeightMeasure, this.preferredHeightMeasure, formLayout$Measure2);
            int[] nArray3 = this.groupedSizes(this.colGroupIndices, nArray);
            int[] nArray4 = this.groupedSizes(this.rowGroupIndices, nArray2);
            int[] nArray5 = this.computeOrigins(nArray3, 0);
            int[] nArray6 = this.computeOrigins(nArray4, 0);
            int n2 = FormLayout.sum(nArray3);
            int n3 = FormLayout.sum(nArray4);
            int n4 = n2;
            int n5 = n3;
            int[] nArray7 = this.computeMaximumFixedSpanTable(this.colSpecs);
            int[] nArray8 = this.computeMaximumFixedSpanTable(this.rowSpecs);
            for (Map.Entry entry : this.constraintMap.entrySet()) {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                CellConstraints cellConstraints;
                Component component = (Component)entry.getKey();
                if (!this.takeIntoAccount(component, cellConstraints = (CellConstraints)entry.getValue())) continue;
                if (cellConstraints.gridWidth > 1 && cellConstraints.gridWidth > nArray7[cellConstraints.gridX - 1] && (n11 = (n10 = nArray5[n9 = cellConstraints.gridX - 1]) + (n8 = formLayout$Measure.sizeOf(component)) + (n7 = n2 - nArray5[n6 = n9 + cellConstraints.gridWidth])) > n4) {
                    n4 = n11;
                }
                if (cellConstraints.gridHeight <= 1 || cellConstraints.gridHeight <= nArray8[cellConstraints.gridY - 1] || (n11 = (n10 = nArray6[n9 = cellConstraints.gridY - 1]) + (n8 = formLayout$Measure2.sizeOf(component)) + (n7 = n3 - nArray6[n6 = n9 + cellConstraints.gridHeight])) <= n5) continue;
                n5 = n11;
            }
            Insets insets = container.getInsets();
            int n12 = n4 + insets.left + insets.right;
            int n13 = n5 + insets.top + insets.bottom;
            return new Dimension(n12, n13);
        }
    }

    private int[] computeGridOrigins(Container container, int n2, int n3, List list, List[] listArray, int[][] nArray, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2) {
        int[] nArray2 = this.maximumSizes(container, list, listArray, formLayout$Measure, formLayout$Measure2, formLayout$Measure);
        int[] nArray3 = this.maximumSizes(container, list, listArray, formLayout$Measure, formLayout$Measure2, formLayout$Measure2);
        int[] nArray4 = this.groupedSizes(nArray, nArray2);
        int[] nArray5 = this.groupedSizes(nArray, nArray3);
        int n4 = FormLayout.sum(nArray4);
        int n5 = FormLayout.sum(nArray5);
        int[] nArray6 = this.compressedSizes(list, n2, n4, n5, nArray4, nArray3);
        int[] nArray7 = this.groupedSizes(nArray, nArray6);
        int n6 = FormLayout.sum(nArray7);
        int[] nArray8 = this.distributedSizes(list, n2, n6, nArray7);
        return this.computeOrigins(nArray8, n3);
    }

    private int[] computeOrigins(int[] nArray, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + 1];
        nArray2[0] = n2;
        for (int i2 = 1; i2 <= n3; ++i2) {
            nArray2[i2] = nArray2[i2 - 1] + nArray[i2 - 1];
        }
        return nArray2;
    }

    private void layoutComponents(int[] nArray, int[] nArray2) {
        Rectangle rectangle = new Rectangle();
        for (Map.Entry entry : this.constraintMap.entrySet()) {
            Component component = (Component)entry.getKey();
            CellConstraints cellConstraints = (CellConstraints)entry.getValue();
            int n2 = cellConstraints.gridX - 1;
            int n3 = cellConstraints.gridY - 1;
            int n4 = cellConstraints.gridWidth;
            int n5 = cellConstraints.gridHeight;
            rectangle.x = nArray[n2];
            rectangle.y = nArray2[n3];
            rectangle.width = nArray[n2 + n4] - rectangle.x;
            rectangle.height = nArray2[n3 + n5] - rectangle.y;
            cellConstraints.setBounds(component, this, rectangle, this.minimumWidthMeasure, this.minimumHeightMeasure, this.preferredWidthMeasure, this.preferredHeightMeasure);
        }
    }

    private void invalidateCaches() {
        this.componentSizeCache.invalidate();
    }

    private int[] maximumSizes(Container container, List list, List[] listArray, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2, FormLayout$Measure formLayout$Measure3) {
        int n2 = list.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            FormSpec formSpec = (FormSpec)list.get(i2);
            nArray[i2] = formSpec.maximumSize(container, listArray[i2], formLayout$Measure, formLayout$Measure2, formLayout$Measure3);
        }
        return nArray;
    }

    private int[] compressedSizes(List list, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        if (n2 < n3) {
            return nArray;
        }
        if (n2 >= n4) {
            return nArray2;
        }
        int n5 = list.size();
        int[] nArray3 = new int[n5];
        double d2 = n4 - n2;
        double d3 = n4 - n3;
        double d4 = d2 / d3;
        for (int i2 = 0; i2 < n5; ++i2) {
            FormSpec formSpec = (FormSpec)list.get(i2);
            nArray3[i2] = nArray2[i2];
            if (!formSpec.getSize().compressible()) continue;
            int n6 = i2;
            nArray3[n6] = nArray3[n6] - (int)Math.round((double)(nArray2[i2] - nArray[i2]) * d4);
        }
        return nArray3;
    }

    private int[] groupedSizes(int[][] nArray, int[] nArray2) {
        int n2;
        if (nArray == null || nArray.length == 0) {
            return nArray2;
        }
        int[] nArray3 = new int[nArray2.length];
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            nArray3[n2] = nArray2[n2];
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n3;
            int n4;
            int[] nArray4 = nArray[n2];
            int n5 = 0;
            for (n4 = 0; n4 < nArray4.length; ++n4) {
                n3 = nArray4[n4] - 1;
                n5 = Math.max(n5, nArray3[n3]);
            }
            for (n4 = 0; n4 < nArray4.length; ++n4) {
                n3 = nArray4[n4] - 1;
                nArray3[n3] = n5;
            }
        }
        return nArray3;
    }

    private int[] distributedSizes(List list, int n2, int n3, int[] nArray) {
        double d2 = n2 - n3;
        if (d2 < 0.0) {
            return nArray;
        }
        int n4 = list.size();
        double d3 = 0.0;
        for (int i2 = 0; i2 < n4; ++i2) {
            FormSpec formSpec = (FormSpec)list.get(i2);
            d3 += formSpec.getResizeWeight();
        }
        if (d3 == 0.0) {
            return nArray;
        }
        int[] nArray2 = new int[n4];
        double d4 = d2;
        int n5 = (int)d2;
        for (int i3 = 0; i3 < n4; ++i3) {
            FormSpec formSpec = (FormSpec)list.get(i3);
            double d5 = formSpec.getResizeWeight();
            if (d5 == 0.0) {
                nArray2[i3] = nArray[i3];
                continue;
            }
            double d6 = d4 - (double)n5;
            double d7 = d2 * d5 / d3;
            double d8 = d7 - d6;
            int n6 = (int)Math.round(d8);
            nArray2[i3] = nArray[i3] + n6;
            d4 -= d7;
            n5 -= n6;
        }
        return nArray2;
    }

    private int[] computeMaximumFixedSpanTable(List list) {
        int n2 = list.size();
        int[] nArray = new int[n2];
        int n3 = Integer.MAX_VALUE;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            FormSpec formSpec = (FormSpec)list.get(i2);
            if (formSpec.canGrow()) {
                n3 = 0;
            }
            nArray[i2] = n3;
            if (n3 >= Integer.MAX_VALUE) continue;
            ++n3;
        }
        return nArray;
    }

    private static int sum(int[] nArray) {
        int n2 = 0;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            n2 += nArray[i2];
        }
        return n2;
    }

    private static void invalidateAndRepaint(Container container) {
        if (container == null) {
            return;
        }
        if (container instanceof JComponent) {
            ((JComponent)container).revalidate();
        } else {
            container.invalidate();
        }
        container.repaint();
    }

    private boolean takeIntoAccount(Component component, CellConstraints cellConstraints) {
        return component.isVisible() || cellConstraints.honorsVisibility == null && !this.getHonorsVisibility() || Boolean.FALSE.equals(cellConstraints.honorsVisibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormLayout$LayoutInfo getLayoutInfo(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.initializeColAndRowComponentLists();
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n2 = dimension.width - insets.left - insets.right;
            int n3 = dimension.height - insets.top - insets.bottom;
            int[] nArray = this.computeGridOrigins(container, n2, insets.left, this.colSpecs, this.colComponents, this.colGroupIndices, this.minimumWidthMeasure, this.preferredWidthMeasure);
            int[] nArray2 = this.computeGridOrigins(container, n3, insets.top, this.rowSpecs, this.rowComponents, this.rowGroupIndices, this.minimumHeightMeasure, this.preferredHeightMeasure);
            return new FormLayout$LayoutInfo(nArray, nArray2, null);
        }
    }

    private int[][] deepClone(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i2 = 0; i2 < nArrayArray.length; ++i2) {
            nArrayArray[i2] = (int[])nArray[i2].clone();
        }
        return nArrayArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        this.invalidateCaches();
        objectOutputStream.defaultWriteObject();
    }
}

