/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.plastic.PlasticSpinnerUI$SpinnerArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PlasticSpinnerUI
extends BasicSpinnerUI {
    private Insets defaultEditorInsets;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticSpinnerUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.defaultEditorInsets = UIManager.getInsets("Spinner.defaultEditorInsets");
    }

    protected Component createPreviousButton() {
        Component component = this.createArrowButton(5);
        this.installPreviousButtonListenersFromSuper(component);
        return component;
    }

    protected Component createNextButton() {
        Component component = this.createArrowButton(1);
        this.installNextButtonListenersFromSuper(component);
        return component;
    }

    protected Component createArrowButton(int n2) {
        return new PlasticSpinnerUI$SpinnerArrowButton(n2, null);
    }

    protected void installPreviousButtonListenersFromSuper(Component component) {
        AbstractButton abstractButton = (AbstractButton)super.createPreviousButton();
        ActionListener[] actionListenerArray = abstractButton.getActionListeners();
        MouseListener[] mouseListenerArray = abstractButton.getMouseListeners();
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).addActionListener(actionListenerArray[0]);
        }
        component.addMouseListener(mouseListenerArray[0]);
    }

    protected void installNextButtonListenersFromSuper(Component component) {
        AbstractButton abstractButton = (AbstractButton)super.createNextButton();
        ActionListener[] actionListenerArray = abstractButton.getActionListeners();
        MouseListener[] mouseListenerArray = abstractButton.getMouseListeners();
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).addActionListener(actionListenerArray[0]);
        }
        component.addMouseListener(mouseListenerArray[0]);
    }

    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        this.configureEditorBorder(jComponent);
        return jComponent;
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.configureEditorBorder(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void configureEditorBorder(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            Insets insets = this.defaultEditorInsets;
            jFormattedTextField.setBorder(new EmptyBorder(insets));
        } else if (jComponent instanceof JPanel && jComponent.getBorder() == null && jComponent.getComponentCount() > 0) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(0);
            Insets insets = this.defaultEditorInsets;
            jComponent2.setBorder(new EmptyBorder(insets));
        }
    }
}

