/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

final class PlasticTabbedPaneUI$ArrowButton
extends JButton
implements UIResource {
    private final int buttonWidth;
    private final int direction;
    private boolean mouseIsOver;
    private Color highlightColor;

    PlasticTabbedPaneUI$ArrowButton(int n2, int n3) {
        this.direction = n2;
        this.buttonWidth = n3;
        this.setRequestFocusEnabled(false);
        this.highlightColor = UIManager.getColor("ScrollBar.highlight");
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 504: {
                this.mouseIsOver = true;
                this.revalidate();
                this.repaint();
                break;
            }
            case 505: {
                this.mouseIsOver = false;
                this.revalidate();
                this.repaint();
            }
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.mouseIsOver && this.isEnabled()) {
            super.paintBorder(graphics);
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.mouseIsOver) {
            super.paintComponent(graphics);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.paintArrow(graphics);
    }

    private void paintArrow(Graphics graphics) {
        int n2;
        int n3;
        Color color = graphics.getColor();
        boolean bl2 = this.isEnabled();
        graphics.setColor(bl2 ? PlasticLookAndFeel.getControlInfo() : PlasticLookAndFeel.getControlDisabled());
        switch (this.direction) {
            case 1: 
            case 5: {
                n3 = 9;
                n2 = 5;
                break;
            }
            default: {
                n3 = 5;
                n2 = 9;
            }
        }
        int n4 = (this.getWidth() - n3) / 2;
        int n5 = (this.getHeight() - n2) / 2;
        graphics.translate(n4, n5);
        boolean bl3 = !this.mouseIsOver || !bl2;
        Color color2 = bl2 ? PlasticLookAndFeel.getControlShadow() : this.highlightColor;
        switch (this.direction) {
            case 1: {
                graphics.fillRect(0, 4, 9, 1);
                graphics.fillRect(1, 3, 7, 1);
                graphics.fillRect(2, 2, 5, 1);
                graphics.fillRect(3, 1, 3, 1);
                graphics.fillRect(4, 0, 1, 1);
                if (!bl3) break;
                graphics.setColor(color2);
                graphics.fillRect(1, 5, 9, 1);
                break;
            }
            case 5: {
                graphics.fillRect(0, 0, 9, 1);
                graphics.fillRect(1, 1, 7, 1);
                graphics.fillRect(2, 2, 5, 1);
                graphics.fillRect(3, 3, 3, 1);
                graphics.fillRect(4, 4, 1, 1);
                if (!bl3) break;
                graphics.setColor(color2);
                graphics.drawLine(5, 4, 8, 1);
                graphics.drawLine(5, 5, 9, 1);
                break;
            }
            case 7: {
                graphics.fillRect(0, 4, 1, 1);
                graphics.fillRect(1, 3, 1, 3);
                graphics.fillRect(2, 2, 1, 5);
                graphics.fillRect(3, 1, 1, 7);
                graphics.fillRect(4, 0, 1, 9);
                if (!bl3) break;
                graphics.setColor(color2);
                graphics.fillRect(5, 1, 1, 9);
                break;
            }
            case 3: {
                graphics.fillRect(0, 0, 1, 9);
                graphics.fillRect(1, 1, 1, 7);
                graphics.fillRect(2, 2, 1, 5);
                graphics.fillRect(3, 3, 1, 3);
                graphics.fillRect(4, 4, 1, 1);
                if (!bl3) break;
                graphics.setColor(color2);
                graphics.drawLine(1, 8, 4, 5);
                graphics.drawLine(1, 9, 5, 5);
            }
        }
        graphics.translate(-n4, -n5);
        graphics.setColor(color);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.buttonWidth, this.buttonWidth);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

