/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookSwitchUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

public final class PlasticUtils {
    private static final float FRACTION_3D = 0.5f;

    private PlasticUtils() {
    }

    static void drawDark3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        PlasticUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
        graphics.setColor(PlasticLookAndFeel.getControl());
        graphics.drawLine(n2 + 1, n3 + 1, 1, n5 - 3);
        graphics.drawLine(n3 + 1, n3 + 1, n4 - 3, 1);
    }

    static void drawDisabledBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(PlasticLookAndFeel.getControlShadow());
        PlasticUtils.drawRect(graphics, n2, n3, n4 - 1, n5 - 1);
    }

    static void drawFlush3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        graphics.setColor(PlasticLookAndFeel.getControlHighlight());
        PlasticUtils.drawRect(graphics, 1, 1, n4 - 2, n5 - 2);
        graphics.drawLine(0, n5 - 1, 0, n5 - 1);
        graphics.drawLine(n4 - 1, 0, n4 - 1, 0);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(graphics, 0, 0, n4 - 2, n5 - 2);
        graphics.translate(-n2, -n3);
    }

    static void drawPressed3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        PlasticUtils.drawFlush3DBorder(graphics, 0, 0, n4, n5);
        graphics.setColor(PlasticLookAndFeel.getControlShadow());
        graphics.drawLine(1, 1, 1, n5 - 3);
        graphics.drawLine(1, 1, n4 - 3, 1);
        graphics.translate(-n2, -n3);
    }

    static void drawButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2) {
        if (bl2) {
            PlasticUtils.drawActiveButtonBorder(graphics, n2, n3, n4, n5);
        } else {
            PlasticUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
        }
    }

    static void drawActiveButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        PlasticUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
        graphics.setColor(PlasticLookAndFeel.getPrimaryControl());
        graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n5 - 3);
        graphics.drawLine(n2 + 1, n3 + 1, n4 - 3, n2 + 1);
        graphics.setColor(PlasticLookAndFeel.getPrimaryControlDarkShadow());
        graphics.drawLine(n2 + 2, n5 - 2, n4 - 2, n5 - 2);
        graphics.drawLine(n4 - 2, n3 + 2, n4 - 2, n5 - 2);
    }

    static void drawDefaultButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2) {
        PlasticUtils.drawButtonBorder(graphics, n2 + 1, n3 + 1, n4 - 1, n5 - 1, bl2);
        graphics.translate(n2, n3);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(graphics, 0, 0, n4 - 3, n5 - 3);
        graphics.drawLine(n4 - 2, 0, n4 - 2, 0);
        graphics.drawLine(0, n5 - 2, 0, n5 - 2);
        graphics.setColor(PlasticLookAndFeel.getControl());
        graphics.drawLine(n4 - 1, 0, n4 - 1, 0);
        graphics.drawLine(0, n5 - 1, 0, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    static void drawDefaultButtonPressedBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        PlasticUtils.drawPressed3DBorder(graphics, n2 + 1, n3 + 1, n4 - 1, n5 - 1);
        graphics.translate(n2, n3);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(graphics, 0, 0, n4 - 3, n5 - 3);
        graphics.drawLine(n4 - 2, 0, n4 - 2, 0);
        graphics.drawLine(0, n5 - 2, 0, n5 - 2);
        graphics.setColor(PlasticLookAndFeel.getControl());
        graphics.drawLine(n4 - 1, 0, n4 - 1, 0);
        graphics.drawLine(0, n5 - 1, 0, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    static void drawThinFlush3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        graphics.setColor(PlasticLookAndFeel.getControlHighlight());
        graphics.drawLine(0, 0, n4 - 2, 0);
        graphics.drawLine(0, 0, 0, n5 - 2);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
        graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    static void drawThinPressed3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
        graphics.drawLine(0, 0, n4 - 2, 0);
        graphics.drawLine(0, 0, 0, n5 - 2);
        graphics.setColor(PlasticLookAndFeel.getControlHighlight());
        graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
        graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static boolean is3D(String string) {
        Object object = LookSwitchUtils.get(string + "is3DEnabled");
        return Boolean.TRUE.equals(object);
    }

    static boolean force3D(JComponent jComponent) {
        Object object = jComponent.getClientProperty("Plastic.is3D");
        return Boolean.TRUE.equals(object);
    }

    static boolean forceFlat(JComponent jComponent) {
        Object object = jComponent.getClientProperty("Plastic.is3D");
        return Boolean.FALSE.equals(object);
    }

    private static void add3DEffekt(Graphics graphics, Rectangle rectangle, boolean bl2, Color color, Color color2, Color color3, Color color4) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl2) {
            n11 = rectangle.width;
            n10 = (int)((float)rectangle.height * 0.5f);
            n9 = rectangle.x;
            n8 = rectangle.y;
            n7 = n9;
            n6 = n8 + n10;
            n5 = n7;
            n4 = n6;
            n3 = n5;
            n2 = rectangle.y + rectangle.height;
        } else {
            n11 = (int)((float)rectangle.width * 0.5f);
            n10 = rectangle.height;
            n9 = rectangle.x;
            n8 = rectangle.y;
            n7 = n9 + n11;
            n6 = n8;
            n5 = n7;
            n4 = n8;
            n3 = rectangle.x + rectangle.width;
            n2 = n4;
        }
        graphics2D.setPaint(new GradientPaint(n9, n8, color2, n7, n6, color));
        graphics2D.fillRect(rectangle.x, rectangle.y, n11, n10);
        graphics2D.setPaint(new GradientPaint(n5, n4, color3, n3, n2, color4));
        graphics2D.fillRect(n5, n4, n11, n10);
    }

    static void add3DEffekt(Graphics graphics, Rectangle rectangle) {
        Color color = LookSwitchUtils.getColor("Plastic.brightenStop");
        if (null == color) {
            color = PlasticTheme.BRIGHTEN_STOP;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = 10;
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x + n2, rectangle.y, PlasticTheme.BRIGHTEN_START));
        graphics2D.fillRect(rectangle.x, rectangle.y, n2, rectangle.height);
        int n3 = rectangle.x + rectangle.width - n2;
        int n4 = rectangle.y;
        graphics2D.setPaint(new GradientPaint(n3, n4, PlasticTheme.DARKEN_START, n3 + n2, n4, PlasticTheme.LT_DARKEN_STOP));
        graphics2D.fillRect(n3, n4, n2, rectangle.height);
        PlasticUtils.add3DEffekt(graphics, rectangle, true, PlasticTheme.BRIGHTEN_START, color, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP);
    }

    static void addLight3DEffekt(Graphics graphics, Rectangle rectangle, boolean bl2) {
        Color color = LookSwitchUtils.getColor("Plastic.ltBrightenStop");
        if (null == color) {
            color = PlasticTheme.LT_BRIGHTEN_STOP;
        }
        PlasticUtils.add3DEffekt(graphics, rectangle, bl2, PlasticTheme.BRIGHTEN_START, color, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP);
    }

    public static void addLight3DEffekt(Graphics graphics, Rectangle rectangle) {
        Color color = LookSwitchUtils.getColor("Plastic.ltBrightenStop");
        if (null == color) {
            color = PlasticTheme.LT_BRIGHTEN_STOP;
        }
        PlasticUtils.add3DEffekt(graphics, rectangle, true, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP, PlasticTheme.BRIGHTEN_START, color);
    }

    private static void drawRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.fillRect(n2, n3, n4 + 1, 1);
        graphics.fillRect(n2, n3 + 1, 1, n5);
        graphics.fillRect(n2 + 1, n3 + n5, n4, 1);
        graphics.fillRect(n2 + n4, n3 + 1, 1, n5);
    }
}

