/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.windows.WindowsFieldCaret$1;
import com.jgoodies.looks.windows.WindowsFieldCaret$SafeScroller;
import com.jgoodies.looks.windows.WindowsFieldCaret$WindowsHighlightPainter;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;

final class WindowsFieldCaret
extends DefaultCaret
implements UIResource {
    private static final LayeredHighlighter.LayerPainter WindowsPainter = new WindowsFieldCaret$WindowsHighlightPainter(null);
    private boolean isKeyboardFocusEvent = true;

    WindowsFieldCaret() {
    }

    public void focusGained(FocusEvent focusEvent) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if (!(jTextComponent.isEnabled() && this.isKeyboardFocusEvent && Options.isSelectOnFocusGainActive(jTextComponent))) {
            return;
        }
        if (jTextComponent instanceof JFormattedTextField) {
            EventQueue.invokeLater(new WindowsFieldCaret$1(this));
        } else {
            this.selectAll();
        }
    }

    private void selectAll() {
        JTextComponent jTextComponent = this.getComponent();
        boolean bl2 = Boolean.TRUE.equals(jTextComponent.getClientProperty("JGoodies.invertSelection"));
        if (bl2) {
            this.setDot(jTextComponent.getDocument().getLength());
            this.moveDot(0);
        } else {
            this.setDot(0);
            this.moveDot(jTextComponent.getDocument().getLength());
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (!focusEvent.isTemporary()) {
            this.isKeyboardFocusEvent = true;
            if (this.getComponent() != null && Boolean.TRUE.equals(this.getComponent().getClientProperty("JGoodies.setCaretToStartOnFocusLost"))) {
                this.setDot(0);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }

    protected void adjustVisibility(Rectangle rectangle) {
        SwingUtilities.invokeLater(new WindowsFieldCaret$SafeScroller(this, rectangle));
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return WindowsPainter;
    }

    static /* synthetic */ void access$000(WindowsFieldCaret windowsFieldCaret) {
        windowsFieldCaret.selectAll();
    }

    static /* synthetic */ JTextComponent access$100(WindowsFieldCaret windowsFieldCaret) {
        return windowsFieldCaret.getComponent();
    }

    static /* synthetic */ void access$200(WindowsFieldCaret windowsFieldCaret, Rectangle rectangle) {
        windowsFieldCaret.damage(rectangle);
    }
}

