/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.sun.java.swing.plaf.windows.WindowsTableHeaderUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class WindowsXPTableHeaderUI
extends WindowsTableHeaderUI {
    private TableCellRenderer xpRenderer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsXPTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.xpRenderer = this.header.getDefaultRenderer();
    }

    public void uninstallUI(JComponent jComponent) {
        this.xpRenderer = null;
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n2;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (tableColumnModel.getColumnCount() <= 0) {
            return;
        }
        boolean bl2 = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        int n3 = this.header.columnAtPoint(bl2 ? point : point2);
        int n4 = this.header.columnAtPoint(bl2 ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(n3);
        if (bl2) {
            for (n2 = n3; n2 <= n4; ++n2) {
                int n5;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
                rectangle2.width = n5 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n2);
                }
                rectangle2.x += n5;
            }
        } else {
            for (n2 = n4; n2 >= n3; --n2) {
                int n6;
                TableColumn tableColumn3 = tableColumnModel.getColumn(n2);
                rectangle2.width = n6 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n2);
                }
                rectangle2.x += n6;
            }
        }
        if (tableColumn != null) {
            n2 = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n2);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n2);
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n2) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        JTable jTable = this.header.getTable();
        Component component = this.xpRenderer.getTableCellRendererComponent(jTable, null, false, false, -1, n2);
        Component component2 = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, -1, n2);
        if (component2 != component) {
            this.rendererPane.add(component2);
            if (!component2.isOpaque()) {
                this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                if (component2 instanceof JComponent && component instanceof JComponent) {
                    ((JComponent)component2).setBorder(((JComponent)component).getBorder());
                }
            }
        }
        this.rendererPane.paintComponent(graphics, component2, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i2 = tableColumnModel.getColumnCount() - 1; i2 >= 0; --i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }
}

