/*
 * Copyright (C) 2003-2011 Karl Tauber <karl at jformdesigner dot com>
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  o Neither the name of JFormDesigner or Karl Tauber nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jformdesigner.runtime;

import java.awt.*;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import com.jformdesigner.model.*;

/**
 * @author Karl Tauber
 */
class JTabbedPaneCreator
	extends AbstractLayoutCreator
{
	private static final String PROP_TITLE = "title";
	private static final String PROP_TOOL_TIP_TEXT = "toolTipText";
	private static final String PROP_ICON = "icon";
	private static final String PROP_DISABLED_ICON = "disabledIcon";
	private static final String PROP_MNEMONIC = "mnemonic";
	private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
	private static final String PROP_ENABLED = "enabled";

	public LayoutManager createLayoutManager( Container container, FormLayoutManager formLayout )
		throws InstantiationException, IllegalAccessException
	{
		return null;
	}

	@Override
	public void addComponentToContainer( Container container, Component component,
										 Object constraints, int index,
										 FormLayoutConstraints formConstraints )
	{
		JTabbedPane tabbedPane = (JTabbedPane) container;

		// compute real insert index
		int tabIndex = (index < 0 ) ? tabbedPane.getTabCount() : index;

		// get properties
		FormLayoutConstraints formCons = (FormLayoutConstraints) constraints;
		String title = getFormCreator().getPropertyStringI18n( formCons, PROP_TITLE, "" );
		String tip = getFormCreator().getPropertyStringI18n( formCons, PROP_TOOL_TIP_TEXT, null );
		Icon icon = (Icon) formCons.getProperty( PROP_ICON );
		Icon disabledIcon = (Icon) formCons.getProperty( PROP_DISABLED_ICON );
		int mnemonic = getPropertyIntI18n( formCons, PROP_MNEMONIC, 0 );
		int mnemonicIndex = getPropertyIntI18n( formCons, PROP_MNEMONIC_INDEX, -1 );
		boolean enabled = formCons.getPropertyBoolean( PROP_ENABLED, true );

		// load icons
		if( icon instanceof SwingIcon )
			icon = ((SwingIcon)icon).createIcon( getFormCreator().getLoader() );
		if( disabledIcon instanceof SwingIcon )
			disabledIcon = ((SwingIcon)disabledIcon).createIcon( getFormCreator().getLoader() );

		// add tab
		tabbedPane.insertTab( title, icon, component, tip, tabIndex );

		// set properties
		if( disabledIcon != null )
			tabbedPane.setDisabledIconAt( tabIndex, disabledIcon );
		if( mnemonic != 0 )
			tabbedPane.setMnemonicAt( tabIndex, mnemonic );
		if( mnemonicIndex >= 0 )
			tabbedPane.setDisplayedMnemonicIndexAt( tabIndex, mnemonicIndex );
		if( !enabled )
			tabbedPane.setEnabledAt( tabIndex, enabled );
	}

	private int getPropertyIntI18n( FormObject formObject, String name, int def ) {
		Object value = formObject.getProperty( name );
		if( value instanceof Integer )
			return ((Integer)value).intValue();
		else if( value instanceof FormMessage ) {
			String str = getFormCreator().getString( (FormMessage) value );
			if( name.endsWith( "Index" ) )
				return Integer.parseInt( str );
			else
				return str.charAt( 0 );
		} else
			return def;
	}
}
