/*
 *  This file is part of JFormDesigner.
 *  Copyright (C) 2008 Karl Tauber <karl@jformdesigner.com>
 *  All Rights Reserved
 *
 *  $Id$
 */

package org.jdesktop.swingx;

import java.awt.*;

/**
 * Reimplementation of <code>org.jdesktop.swingx.VerticalLayout</code>
 * to avoid licensing issues.
 *
 * @author Karl Tauber
 */
public class VerticalLayout
	implements LayoutManager
{
	private int gap;

	public VerticalLayout() {
	}

	public VerticalLayout( int gap ) {
		this.gap = gap;
	}

	public int getGap() {
		return gap;
	}

	public void setGap( int gap ) {
		this.gap = gap;
	}

	public void addLayoutComponent( String name, Component comp ) {}
	public void removeLayoutComponent( Component comp ) {}

	public Dimension preferredLayoutSize( Container parent ) {
		int width = 0;
		int height = 0;
		int count = parent.getComponentCount();
		for( int i = 0; i < count; i++ ) {
			Component c = parent.getComponent( i );
			if( c.isVisible() ) {
				Dimension pref = c.getPreferredSize();
				height += pref.height + gap;
				if( pref.width > width )
					width = pref.width;
			}
		}

		Insets insets = parent.getInsets();
		width += insets.left + insets.right;
		height += insets.top + insets.bottom;
		return new Dimension( width, height );
	}

	public Dimension minimumLayoutSize( Container parent ) {
		return preferredLayoutSize( parent );
	}

	public void layoutContainer( Container parent ) {
		Insets insets = parent.getInsets();
		int x = insets.left;
		int y = insets.top;
		int width = parent.getWidth() - insets.left - insets.right;

		int count = parent.getComponentCount();
		for( int i = 0; i < count; i++ ) {
			Component c = parent.getComponent( i );
			if( c.isVisible() ) {
				int height = c.getPreferredSize().height;
				c.setBounds( x, y, width, height );
				y += height + gap;
			}
		}
	}
}
