/*
 * Decompiled with CFR 0.152.
 */
package sdoc;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import sdoc.SyntaxSupport;

public class SyntaxEditorPaneUI
extends BasicEditorPaneUI {
    private JTextComponent comp;
    int selectedIndex = 0;

    public void installUI(JComponent c) {
        this.comp = (JTextComponent)c;
        System.err.println("Installing UI");
        if (SyntaxSupport.getInstance().getShouldHighlightCurrentLine()) {
            System.err.println("Installing HIGHLIGHT");
            this.comp.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    Document doc = SyntaxEditorPaneUI.this.comp.getDocument();
                    Element map = doc.getDefaultRootElement();
                    int index = map.getElementIndex(e.getDot());
                    if (index == SyntaxEditorPaneUI.this.selectedIndex) {
                        return;
                    }
                    try {
                        Rectangle rec;
                        Element previous = map.getElement(SyntaxEditorPaneUI.this.selectedIndex);
                        if (previous != null && (rec = SyntaxEditorPaneUI.this.comp.modelToView(previous.getStartOffset())) != null) {
                            rec.width = SyntaxEditorPaneUI.this.comp.getWidth();
                            SyntaxEditorPaneUI.this.comp.repaint(rec);
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    System.out.println("Set to " + index);
                    SyntaxEditorPaneUI.this.selectedIndex = index;
                    Element selected = map.getElement(index);
                    SyntaxEditorPaneUI.this.damageRange(SyntaxEditorPaneUI.this.comp, selected.getStartOffset(), selected.getEndOffset() - 1);
                }
            });
        }
        super.installUI(c);
    }

    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        SyntaxSupport config = SyntaxSupport.getInstance();
        if (config.getShouldDrawPrintMargin()) {
            int charWidth = g.getFontMetrics(this.comp.getFont()).charWidth('S');
            int linex = charWidth * config.getPringMarginWidth();
            Rectangle rec = this.comp.getVisibleRect();
            g.setColor(Color.GRAY.brighter());
            g.drawLine(linex, rec.y, linex, rec.y + rec.height);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.comp.getInputMap().put(KeyStroke.getKeyStroke("control D"), "lineDel");
        this.comp.getActionMap().put("lineDel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SyntaxEditorPaneUI.this.lineDel();
            }
        });
    }

    private void lineDel() {
        int postion = this.comp.getCaret().getDot();
        Element map = this.comp.getDocument().getDefaultRootElement();
        int index = map.getElementIndex(postion);
        Element line = map.getElement(index);
        try {
            int offs = Math.max(0, line.getStartOffset());
            int len = line.getEndOffset() - offs;
            int max = this.comp.getDocument().getLength();
            if (offs + len > max) {
                if (offs == 0) {
                    --len;
                } else {
                    --offs;
                }
            }
            this.comp.getDocument().remove(offs, len);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

