/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator.modules;

import java.util.Collection;
import jode.obfuscator.ClassIdentifier;
import jode.obfuscator.FieldIdentifier;
import jode.obfuscator.Identifier;
import jode.obfuscator.IdentifierMatcher;
import jode.obfuscator.MethodIdentifier;
import jode.obfuscator.OptionHandler;
import jode.obfuscator.PackageIdentifier;

public class SerializePreserver
implements IdentifierMatcher,
OptionHandler {
    boolean onlySUID = true;

    public void setOption(String string, Collection collection) {
        if (!string.equals("all")) {
            throw new IllegalArgumentException("Invalid option `" + string + "'.");
        }
        this.onlySUID = false;
    }

    public final boolean matchesSub(Identifier identifier, String string) {
        if (identifier instanceof PackageIdentifier) {
            return true;
        }
        if (identifier instanceof ClassIdentifier) {
            ClassIdentifier classIdentifier = (ClassIdentifier)identifier;
            return classIdentifier.isSerializable() && (!this.onlySUID || classIdentifier.hasSUID());
        }
        return false;
    }

    public final boolean matches(Identifier identifier) {
        ClassIdentifier classIdentifier;
        if (identifier instanceof ClassIdentifier) {
            classIdentifier = (ClassIdentifier)identifier;
        } else if (identifier instanceof FieldIdentifier) {
            classIdentifier = (ClassIdentifier)identifier.getParent();
        } else {
            return false;
        }
        if (!classIdentifier.isSerializable() || this.onlySUID && !classIdentifier.hasSUID()) {
            return false;
        }
        if (identifier instanceof FieldIdentifier) {
            FieldIdentifier fieldIdentifier = (FieldIdentifier)identifier;
            if ((fieldIdentifier.getModifiers() & 0x88) == 0) {
                return true;
            }
            if (identifier.getName().equals("serialPersistentFields") || identifier.getName().equals("serialVersionUID")) {
                return true;
            }
        } else if (identifier instanceof MethodIdentifier) {
            if (identifier.getName().equals("writeObject") && identifier.getType().equals("(Ljava.io.ObjectOutputStream)V")) {
                return true;
            }
            if (identifier.getName().equals("readObject") && identifier.getType().equals("(Ljava.io.ObjectInputStream)V")) {
                return true;
            }
        } else if (identifier instanceof ClassIdentifier) {
            if (!classIdentifier.hasSUID()) {
                classIdentifier.addSUID();
            }
            return true;
        }
        return false;
    }

    public final String getNextComponent(Identifier identifier) {
        return null;
    }
}

