/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveBusyException;
import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.archive.spi.InputArchiveBusyException;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileOutputStream
extends FilterOutputStream {
    static final /* synthetic */ boolean $assertionsDisabled;

    private static OutputStream createOutputStream(java.io.File file, boolean bl) throws FileNotFoundException {
        if (file instanceof File) {
            File file2 = (File)file;
            if (file2.isArchive() && (file2.isDirectory() || file2.exists() && !file2.isFile())) {
                throw new FileNotFoundException(file.getPath() + " (cannot overwrite possibly inaccessible archive file)");
            }
            String string = file2.getEnclEntryName();
            if (string != null) {
                return FileOutputStream.createOutputStream(file2.getEnclArchive().getArchiveController(), string, file2, bl);
            }
        }
        return new java.io.FileOutputStream(file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OutputStream createOutputStream(ArchiveController archiveController, String string, File file, boolean bl) throws FileNotFoundException {
        try {
            ArchiveController archiveController2 = archiveController;
            synchronized (archiveController2) {
                OutputStream outputStream;
                InputStream inputStream = bl && archiveController.isFile(string) ? archiveController.getInputStream(string) : null;
                try {
                    outputStream = archiveController.getOutputStream(string);
                    if (inputStream != null) {
                        File.cat(inputStream, outputStream);
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                return outputStream;
            }
        }
        catch (ArchiveController.FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            return FileOutputStream.createOutputStream(archiveController.getEnclController(), archiveController.enclEntryName(string), file, bl);
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            java.io.File file2 = file.getDelegate();
            java.io.File file3 = file2.getParentFile();
            if (file3.isDirectory()) {
                return new java.io.FileOutputStream(file);
            }
            throw falsePositiveNativeException;
        }
        catch (InputArchiveBusyException inputArchiveBusyException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new FileBusyException(inputArchiveBusyException);
        }
        catch (OutputArchiveBusyException outputArchiveBusyException) {
            throw new FileBusyException(outputArchiveBusyException);
        }
        catch (ArchiveBusyException archiveBusyException) {
            throw new FileBusyException(archiveBusyException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(file.getPath());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    public FileOutputStream(String string) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(File.getDefaultArchiveDetector().createFile(string), false));
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(File.getDefaultArchiveDetector().createFile(string), bl));
    }

    public FileOutputStream(java.io.File file) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(file, false));
    }

    public FileOutputStream(java.io.File file, boolean bl) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(file, bl));
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    static {
        $assertionsDisabled = !FileOutputStream.class.desiredAssertionStatus();
    }
}

