/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ReadWriteLock;
import de.schlichtherle.io.ReentrantLock;
import de.schlichtherle.util.ThreadLocalCounter;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ReentrantReadWriteLock
implements ReadWriteLock {
    private static final String CLASS_NAME = "de/schlichtherle/io/ReentrantReadWriteLock".replace('/', '.');
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    private final ReadLock readLock = new ReadLock();
    private final WriteLock writeLock = new WriteLock();
    private int totalWriteLockCount;
    private int totalReadLockCount;

    ReentrantReadWriteLock() {
    }

    public ReentrantLock readLock() {
        return this.readLock;
    }

    public ReentrantLock writeLock() {
        return this.writeLock;
    }

    private synchronized void lockRead() {
        int n = this.writeLock.lockCount();
        if (n <= 0) {
            while (this.totalWriteLockCount - n > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.FINE, "interrupted", interruptedException);
                    logger.log(Level.FINE, "continuing");
                }
            }
        }
        ++this.totalReadLockCount;
    }

    private synchronized void lockReadInterruptibly() throws InterruptedException {
        int n = this.writeLock.lockCount();
        if (n <= 0) {
            while (this.totalWriteLockCount - n > 0) {
                this.wait();
            }
        }
        ++this.totalReadLockCount;
    }

    private synchronized boolean tryLockRead() {
        int n = this.writeLock.lockCount();
        if (n <= 0 && this.totalWriteLockCount - n > 0) {
            return false;
        }
        ++this.totalReadLockCount;
        return true;
    }

    private synchronized void unlockRead() {
        --this.totalReadLockCount;
        this.notifyAll();
    }

    private synchronized void lockWrite() {
        int n = this.writeLock.lockCount();
        if (n <= 0) {
            while (this.totalReadLockCount > 0 || this.totalWriteLockCount - n > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.FINE, "interrupted", interruptedException);
                    logger.log(Level.FINE, "continuing");
                }
            }
        }
        ++this.totalWriteLockCount;
    }

    private synchronized void lockWriteInterruptibly() throws InterruptedException {
        int n = this.writeLock.lockCount();
        if (n <= 0) {
            while (this.totalReadLockCount > 0 || this.totalWriteLockCount - n > 0) {
                this.wait();
            }
        }
        ++this.totalWriteLockCount;
    }

    private synchronized boolean tryLockWrite() {
        int n = this.writeLock.lockCount();
        if (n <= 0 && (this.totalReadLockCount > 0 || this.totalWriteLockCount - n > 0)) {
            return false;
        }
        ++this.totalWriteLockCount;
        return true;
    }

    private synchronized void unlockWrite() {
        --this.totalWriteLockCount;
        this.notifyAll();
    }

    private class WriteLock
    extends AbstractLock {
        private WriteLock() {
        }

        public void lock() {
            ReentrantReadWriteLock.this.lockWrite();
            super.lock();
        }

        public void lockInterruptibly() throws InterruptedException {
            ReentrantReadWriteLock.this.lockWriteInterruptibly();
            super.lock();
        }

        public boolean tryLock() {
            boolean bl = ReentrantReadWriteLock.this.tryLockWrite();
            if (bl) {
                super.lock();
            }
            return bl;
        }

        public void unlock() {
            super.unlock();
            ReentrantReadWriteLock.this.unlockWrite();
        }
    }

    private class ReadLock
    extends AbstractLock {
        private ReadLock() {
        }

        public void lock() {
            ReentrantReadWriteLock.this.lockRead();
            super.lock();
        }

        public void lockInterruptibly() throws InterruptedException {
            ReentrantReadWriteLock.this.lockReadInterruptibly();
            super.lock();
        }

        public boolean tryLock() {
            boolean bl = ReentrantReadWriteLock.this.tryLockRead();
            if (bl) {
                super.lock();
            }
            return bl;
        }

        public void unlock() {
            super.unlock();
            ReentrantReadWriteLock.this.unlockRead();
        }
    }

    private static abstract class AbstractLock
    extends ThreadLocalCounter
    implements ReentrantLock {
        private AbstractLock() {
        }

        public final boolean isLocked() {
            return this.getCounter() > 0;
        }

        public final int lockCount() {
            return this.getCounter();
        }

        public void lock() {
            this.increment();
        }

        public void unlock() {
            int n = this.getCounter();
            if (n <= 0) {
                throw new IllegalMonitorStateException();
            }
            this.setCounter(n - 1);
        }
    }
}

