/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class PasswdOrKeyFilePanel
extends EnhancedPanel {
    private static final String CLASS_NAME = "de/schlichtherle/key/passwd/swing/PasswdOrKeyFilePanel".replace('/', '.');
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static SoftReference fileChooser;
    private JPanel cardPanel;
    private EnhancedPanel filePanel;
    public final JTextField pathname = new JTextField();
    private JLabel pathnameLabel;
    public final JToggleButton useKeyFile = new JToggleButton();

    static JFileChooser getFileChooser() {
        JFileChooser jFileChooser;
        SoftReference softReference = fileChooser;
        JFileChooser jFileChooser2 = jFileChooser = softReference != null ? (JFileChooser)softReference.get() : null;
        if (jFileChooser == null) {
            jFileChooser = new CustomFileChooser();
            fileChooser = new SoftReference<JFileChooser>(jFileChooser);
        }
        return jFileChooser;
    }

    public PasswdOrKeyFilePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.cardPanel = new JPanel();
        this.filePanel = new EnhancedPanel();
        this.pathnameLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.cardPanel.setLayout(new CardLayout());
        this.filePanel.setLayout(new GridBagLayout());
        this.filePanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                PasswdOrKeyFilePanel.this.filePanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.pathnameLabel.setLabelFor(this.pathname);
        this.pathnameLabel.setText(resources.getString("pathnameLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.filePanel.add((Component)this.pathnameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.filePanel.add((Component)this.pathname, gridBagConstraints);
        this.cardPanel.add((Component)this.filePanel, "file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.cardPanel, gridBagConstraints);
        this.useKeyFile.setText(resources.getString("useKeyFile.yes"));
        this.useKeyFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PasswdOrKeyFilePanel.this.useKeyFileActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.useKeyFile, gridBagConstraints);
    }

    private void filePanelAncestorWindowShown(PanelEvent panelEvent) {
        this.pathname.requestFocusInWindow();
        this.pathname.selectAll();
    }

    public void setPasswdPanel(JPanel jPanel) {
        if (jPanel == null) {
            throw new NullPointerException();
        }
        this.cardPanel.add((Component)jPanel, "passwd");
        this.useKeyFileActionPerformed(null);
    }

    private void useKeyFileActionPerformed(ActionEvent actionEvent) {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        if (this.useKeyFile.isSelected()) {
            cardLayout.show(this.cardPanel, "file");
            JFileChooser jFileChooser = PasswdOrKeyFilePanel.getFileChooser();
            if (jFileChooser.showOpenDialog(this.getAncestorWindow()) == 0) {
                String string = jFileChooser.getSelectedFile().getPath();
                if (!this.pathname.getText().equals(string)) {
                    this.updatePathname(string);
                }
                this.useKeyFile.setText(resources.getString("useKeyFile.no"));
            } else {
                this.useKeyFile.setSelected(false);
                cardLayout.show(this.cardPanel, "passwd");
            }
        } else {
            this.updatePathname(null);
            this.useKeyFile.setText(resources.getString("useKeyFile.yes"));
            cardLayout.show(this.cardPanel, "passwd");
        }
    }

    private void updatePathname(String string) {
        this.pathname.setText(string);
        Window window = this.getAncestorWindow();
        if (window != null) {
            window.pack();
        }
    }

    private static class CustomFileChooser
    extends JFileChooser {
        private static File currentDirCache;

        public CustomFileChooser() {
            super(currentDirCache);
            this.setDialogTitle(resources.getString("fileChooser.title"));
            this.setFileHidingEnabled(false);
        }

        public void setCurrentDirectory(File file) {
            super.setCurrentDirectory(file);
            currentDirCache = file;
        }

        public File getCurrentDirectory() {
            currentDirCache = super.getCurrentDirectory();
            return currentDirCache;
        }
    }
}

