/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.passwd.swing.BasicInvalidOpenKeyFeedback;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class QuakingWindowFeedback
extends BasicInvalidOpenKeyFeedback {
    private static final double TWO_PI = Math.PI * 2;
    public static final int DISTANCE = 20;
    public static final int CYCLE = 125;
    public static final int DURATION = 1000;
    public static final int FPS = 85;
    private final double distance;
    private final double cycle;
    private final int duration;
    private final int swelling;
    private final int slowing;
    private final int fps;

    public QuakingWindowFeedback() {
        this(20, 125, 1000, 85);
    }

    protected QuakingWindowFeedback(int n, int n2, int n3, int n4) {
        this.distance = n;
        this.cycle = n2;
        this.duration = n3;
        this.swelling = n3 / 2;
        this.slowing = n3 - this.swelling;
        this.fps = n4;
        if (n3 > this.getDelay()) {
            this.setDelay(n3);
        }
    }

    protected void startAnimation() {
        super.startAnimation();
        final Window window = this.getPanel().getAncestorWindow();
        if (window == null) {
            return;
        }
        final Point point = window.getLocation();
        final long l = System.currentTimeMillis();
        Timer timer = new Timer(1000 / this.fps, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l2 = System.currentTimeMillis() - l;
                if (l2 < (long)QuakingWindowFeedback.this.duration && window.isShowing()) {
                    double d = l2 <= (long)QuakingWindowFeedback.this.swelling ? QuakingWindowFeedback.this.distance * (double)l2 / (double)QuakingWindowFeedback.this.swelling : QuakingWindowFeedback.this.distance * (double)((long)QuakingWindowFeedback.this.duration - l2) / (double)QuakingWindowFeedback.this.slowing;
                    double d2 = Math.PI * 2 * (double)l2 / QuakingWindowFeedback.this.cycle;
                    int n = (int)(Math.cos(d2) * d + (double)point.x);
                    int n2 = (int)(Math.sin(d2) * d + (double)point.y);
                    window.setLocation(n, n2);
                    window.repaint();
                } else {
                    ((Timer)actionEvent.getSource()).stop();
                    window.setLocation(point);
                    window.repaint();
                }
            }
        });
        timer.start();
    }
}

