/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.gui.tree;

import jarxplorer.gui.decompiler.SingletonCodePanel;
import jarxplorer.gui.tree.AboutDialog;
import jarxplorer.gui.tree.DropJarListener;
import jarxplorer.gui.tree.DropJarPanel;
import jarxplorer.gui.tree.LifeCycle;
import jarxplorer.gui.tree.MainMenu;
import jarxplorer.gui.tree.MainUI;
import jarxplorer.gui.tree.TreePanel;
import jarxplorer.helpers.CircularArrayList;
import jarxplorer.helpers.Preference;
import jarxplorer.helpers.Register;
import jarxplorer.helpers.SwingWorker;
import java.awt.Cursor;
import java.awt.dnd.DropTarget;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class GuiManager
implements LifeCycle {
    private MainUI ui = new MainUI();
    private MainMenu menu;
    private DropJarPanel dropJarPanel;
    private TreePanel treePanel;
    private DropJarListener dropJarListener = new DropJarListener(this);

    public GuiManager() throws Exception {
        this.dropJarPanel = new DropJarPanel();
        new DropTarget(this.dropJarPanel, this.dropJarListener);
        this.treePanel = new TreePanel();
        this.menu = new MainMenu(this);
        this.ui.setJMenuBar(this.menu.getMenuBar());
        this.init();
        this.ui.setVisible(true);
    }

    public void init() {
        this.dropJarPanel.addToFrame(this.ui);
        this.menu.init(Preference.getPreference().isAlwaysOnTop());
        this.setAlwaysOnTop(Preference.getPreference().isAlwaysOnTop());
    }

    public void preLoading() {
        String string = this.showFileChooser(this.ui);
        this.ui.requestFocus();
        if (string != null) {
            this.startWorker(string);
        }
    }

    public void jarDropped(String string) {
        if (this.treePanel.isVisible()) {
            this.treePanel.removeFromFrame(this.ui);
            this.dropJarPanel.addToFrame(this.ui);
        }
        this.startWorker(string);
    }

    private void startWorker(final String string) {
        SwingWorker swingWorker = new SwingWorker(){
            int delay = 0;
            int period = 25;
            Timer timer = new Timer();

            public Object construct() {
                GuiManager.this.loading();
                GuiManager.this.dropJarPanel.loading(string);
                GuiManager.this.ui.setCursor(Cursor.getPredefinedCursor(3));
                final CircularArrayList circularArrayList = new CircularArrayList();
                circularArrayList.put("Loading " + string + " |");
                circularArrayList.put("Loading " + string + " /");
                circularArrayList.put("Loading " + string + " -");
                circularArrayList.put("Loading " + string + " \\");
                this.timer.scheduleAtFixedRate(new TimerTask(){

                    public void run() {
                        GuiManager.this.dropJarPanel.setLabel(circularArrayList.get());
                    }
                }, this.delay, (long)this.period);
                GuiManager.this.treePanel.buildTree(string);
                new DropTarget(((GuiManager)GuiManager.this).treePanel.tree, GuiManager.this.dropJarListener);
                return null;
            }

            public void finished() {
                this.timer.cancel();
                GuiManager.this.ui.setCursor(Cursor.getPredefinedCursor(0));
                GuiManager.this.loaded();
            }
        };
        swingWorker.start();
    }

    public void loading() {
        this.menu.loading();
    }

    public void loaded() {
        this.menu.loaded();
        this.dropJarPanel.removeFromFrame(this.ui);
        this.treePanel.addToFrame(this.ui);
        this.ui.requestFocus();
        this.ui.toFront();
    }

    public void closed() {
        this.menu.closed();
        this.dropJarPanel.loaded();
        this.treePanel.removeFromFrame(this.ui);
        this.dropJarPanel.addToFrame(this.ui);
    }

    public void showAboutPanel() {
        new AboutDialog(this.ui).setVisible(true);
    }

    private String showFileChooser(JFrame jFrame) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".jar") || file.isDirectory();
            }

            public String getDescription() {
                return "*.jar";
            }
        });
        jFileChooser.setCurrentDirectory(Register.getCurrentDirectory());
        int n = jFileChooser.showOpenDialog(jFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            Register.setCurrentDirectory(file);
            return file.getAbsolutePath();
        }
        return null;
    }

    void setAlwaysOnTop(boolean bl) {
        this.ui.setAlwaysOnTop(bl);
        SingletonCodePanel.alwaysOnTop(bl);
        Preference.getPreference().setAlwaysOnTop(bl);
    }
}

