/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.parser;

import de.schlichtherle.io.File;
import jarxplorer.parser.MyClass;
import jarxplorer.parser.MyField;
import jarxplorer.parser.MyMethod;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;

public class Parser {
    private String classPath;
    private String zipFile;
    private String fileName;
    private JavaClass jClass;

    public Parser(String string, String string2) throws IOException {
        this.zipFile = string;
        this.fileName = string2;
        ClassParser classParser = new ClassParser(string, string2);
        this.jClass = classParser.parse();
    }

    public MyClass getMyClass() {
        return new MyClass(this.zipFile + File.separator + this.fileName, this.fileName, this.jClass);
    }

    public MyField[] getFields() {
        Field[] fieldArray = this.jClass.getFields();
        ArrayList<MyField> arrayList = new ArrayList<MyField>();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i].getName().indexOf("$") != -1) continue;
            arrayList.add(new MyField(fieldArray[i]));
        }
        MyField[] myFieldArray = new MyField[arrayList.size()];
        return arrayList.toArray(myFieldArray);
    }

    public MyMethod[] getMethods() {
        Method[] methodArray = this.jClass.getMethods();
        ArrayList<MyMethod> arrayList = new ArrayList<MyMethod>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getName().equals("<init>") || methodArray[i].getName().equals("<clinit>") || methodArray[i].getName().indexOf("$") != -1) continue;
            arrayList.add(new MyMethod(this.jClass.getClassName(), methodArray[i]));
        }
        MyMethod[] myMethodArray = new MyMethod[arrayList.size()];
        return arrayList.toArray(myMethodArray);
    }

    public MyMethod[] getConstructors() {
        Method[] methodArray = this.jClass.getMethods();
        ArrayList<MyMethod> arrayList = new ArrayList<MyMethod>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals("<init>") || methodArray[i].getName().indexOf("$") != -1) continue;
            arrayList.add(new MyMethod(this.jClass.getClassName(), methodArray[i]));
        }
        MyMethod[] myMethodArray = new MyMethod[arrayList.size()];
        return arrayList.toArray(myMethodArray);
    }

    public static void dump(String string, String string2) throws IOException {
        Object object;
        String string3 = string + File.separator + string2;
        File file = new File(string + File.separator + string2);
        if (file.isFile()) {
            System.out.println("file: " + file.getAbsolutePath());
            System.out.println("file size: " + file.length());
            object = new SimpleDateFormat("MMM dd, yyyy k:m:s");
            System.out.println("file lastmodification: " + ((DateFormat)object).format(new Date(file.lastModified())));
        }
        object = new ClassParser(string, string2);
        JavaClass javaClass = ((ClassParser)object).parse();
        String string4 = javaClass.getSourceFileName();
        String string5 = string4.substring(0, string4.length() - 5);
        System.out.println("Name: " + string5);
        System.out.println("className access: " + Utility.accessToString(javaClass.getAccessFlags(), true));
        System.out.println("superClass: " + javaClass.getSuperclassName());
        string5 = string2.replace("/", ".");
        System.out.println("className file: " + string5.substring(0, string5.length() - 6));
    }

    public static void main(String[] stringArray) {
        try {
            String string = "C:\\JarExplorer.jar";
            String string2 = "jarxplorer/parser/MyMethod.class";
            Parser.dump(string, string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

