/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.NullOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

class MailStream
extends PrintStream {
    private static final int SMTP_PORT = 25;
    private static SimpleDateFormat RFC2822_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private String sender;
    private String recipient;

    public MailStream(String smtpServer, String from, String to) {
        super(new NullOutputStream());
        try {
            this.sender = from;
            this.recipient = to;
            this.socket = new Socket(smtpServer, 25);
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.verify("220");
            this.println("HELO " + InetAddress.getLocalHost().getHostName());
            this.verify("250");
            this.println("MAIL FROM: " + this.sender);
            this.verify("250");
            StringTokenizer tokenizer = new StringTokenizer(to, " ,");
            while (tokenizer.hasMoreTokens()) {
                this.println("RCPT TO: " + tokenizer.nextToken());
                this.verify("250");
            }
            this.println("DATA");
            this.verify("354");
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    @Override
    public void print(boolean b) {
        this.print("" + b);
    }

    @Override
    public void print(char c) {
        this.print("" + c);
    }

    @Override
    public void print(int i) {
        this.print("" + i);
    }

    @Override
    public void print(long l) {
        this.print("" + l);
    }

    @Override
    public void print(float f) {
        this.print("" + f);
    }

    @Override
    public void print(double d) {
        this.print("" + d);
    }

    @Override
    public void print(char[] array) {
        this.print(new String(array));
    }

    @Override
    public void print(String s) {
        this.write(s);
    }

    @Override
    public void print(Object obj) {
        this.print("" + obj);
    }

    @Override
    public void println() {
        try {
            this.out.write(10);
            this.out.flush();
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    @Override
    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    @Override
    public void println(char c) {
        this.print(c);
        this.println();
    }

    @Override
    public void println(int i) {
        this.print(i);
        this.println();
    }

    @Override
    public void println(long l) {
        this.print(l);
        this.println();
    }

    @Override
    public void println(float f) {
        this.print(f);
        this.println();
    }

    @Override
    public void println(double d) {
        this.print(d);
        this.println();
    }

    @Override
    public void println(char[] array) {
        this.print(array);
        this.println();
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.println();
    }

    @Override
    public void write(int c) {
        try {
            if (c > 255) {
                throw new ErrorException("Illegal character in mail stream");
            }
            this.out.write(c);
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public void write(char[] buffer, int offset, int length) {
        try {
            for (int i = 0; i < length; ++i) {
                char c = buffer[offset + i];
                if (c > '\u00ff') {
                    throw new ErrorException("Illegal character in mail stream");
                }
                this.out.write(c);
            }
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public void write(char[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    public void write(String s) {
        try {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c > '\u00ff') {
                    throw new ErrorException("Illegal character in mail stream");
                }
                this.out.write(c);
            }
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.println(".");
            this.verify("250");
            this.out.close();
            this.socket.close();
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public void cancel() {
        try {
            this.socket.close();
            this.out.close();
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public void sendStandardHeaders(String senderName, String subject) {
        this.println("To: " + this.recipient);
        if (senderName != null && senderName.length() != 0) {
            boolean requiresQuotes = false;
            for (int i = 0; i < senderName.length(); ++i) {
                char ch = senderName.charAt(i);
                if (ch == ' ' || ch == '-' || Character.isJavaIdentifierPart(ch)) continue;
                requiresQuotes = true;
                break;
            }
            this.sender = requiresQuotes ? '\"' + senderName + '\"' + " <" + this.sender + ">" : senderName + " <" + this.sender + ">";
        }
        this.println("From: " + this.sender);
        if (subject != null && subject.length() != 0) {
            this.println("Subject: " + subject);
        }
        this.println("Date: " + RFC2822_DATE_FORMAT.format(new Date()));
    }

    private void verify(String pattern) {
        try {
            int c;
            String response = "";
            while ((c = this.in.read()) != -1 && c != 10) {
                response = response + (char)c;
            }
            if (pattern != null && !response.startsWith(pattern)) {
                throw new ErrorException("Unexpected SMTP response: " + response);
            }
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }
}

