/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class Platform {
    public static final int UNKNOWN = 0;
    public static final int MAC = 1;
    public static final int UNIX = 2;
    public static final int WINDOWS = 3;
    private static final String JTF_VERSION = "1.99.1";
    private static int platform = -1;
    private static boolean areStandardFontFamiliesAvailable;
    private static boolean fontsChecked;
    private static boolean isSwingAvailable;
    private static boolean swingChecked;
    private static boolean areCollectionsAvailable;
    private static boolean collectionsChecked;
    private static boolean isSunAudioAvailable;
    private static boolean sunAudioChecked;
    private static boolean isJMFAvailable;
    private static boolean jmfChecked;

    private Platform() {
    }

    public static int getPlatform() {
        if (platform != -1) {
            return platform;
        }
        String name = System.getProperty("os.name", "").toLowerCase();
        if (name.startsWith("mac")) {
            platform = 1;
            return 1;
        }
        if (name.startsWith("windows")) {
            platform = 3;
            return 3;
        }
        if (name.startsWith("microsoft")) {
            platform = 3;
            return 3;
        }
        if (name.startsWith("ms")) {
            platform = 3;
            return 3;
        }
        if (name.startsWith("unix")) {
            platform = 2;
            return 2;
        }
        if (name.startsWith("linux")) {
            platform = 2;
            return 2;
        }
        platform = 0;
        return 0;
    }

    public static boolean isMac() {
        return Platform.getPlatform() == 1;
    }

    public static boolean isWindows() {
        return Platform.getPlatform() == 3;
    }

    public static boolean isUnix() {
        return Platform.getPlatform() == 2;
    }

    public static void setFileTypeAndCreator(String filename, String type, String creator) {
        if (!Platform.isMac()) {
            return;
        }
        try {
            Platform.setFileTypeAndCreator(new File(filename), type, creator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFileTypeAndCreator(File file, String type, String creator) {
        if (!Platform.isMac()) {
            return;
        }
        try {
            Class<?> mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
            Class<?> mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
            Class[] sig1 = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> constructor = mrjOSTypeClass.getConstructor(sig1);
            Class[] sig2 = new Class[]{Class.forName("java.io.File"), mrjOSTypeClass, mrjOSTypeClass};
            Method setFileTypeAndCreator = mrjFileUtilsClass.getMethod("setFileTypeAndCreator", sig2);
            Object[] args1 = new Object[]{(type + "    ").substring(0, 4)};
            Object osType = constructor.newInstance(args1);
            Object[] args2 = new Object[]{(creator + "    ").substring(0, 4)};
            Object creatorType = constructor.newInstance(args2);
            Object[] args3 = new Object[]{file, osType, creatorType};
            setFileTypeAndCreator.invoke(null, args3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyFileTypeAndCreator(File oldFile, File newFile) {
        if (!Platform.isMac()) {
            return;
        }
        try {
            Class<?> mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
            Class<?> mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
            Class[] sig1 = new Class[]{Class.forName("java.io.File")};
            Method getFileType = mrjFileUtilsClass.getMethod("getFileType", sig1);
            Method getFileCreator = mrjFileUtilsClass.getMethod("getFileCreator", sig1);
            Class[] sig2 = new Class[]{Class.forName("java.io.File"), mrjOSTypeClass, mrjOSTypeClass};
            Method setFileTypeAndCreator = mrjFileUtilsClass.getMethod("setFileTypeAndCreator", sig2);
            Object[] args1 = new Object[]{oldFile};
            Object osType = getFileType.invoke(null, args1);
            Object creatorType = getFileCreator.invoke(null, args1);
            Object[] args2 = new Object[]{newFile, osType, creatorType};
            setFileTypeAndCreator.invoke(null, args2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getJTFVersion() {
        return JTF_VERSION;
    }

    public static int compareVersion(String version) {
        return Platform.compareVersion(System.getProperty("java.version"), version);
    }

    public static int compareVersion(String v1, String v2) {
        StringTokenizer t1 = new StringTokenizer(v1, ".");
        StringTokenizer t2 = new StringTokenizer(v2, ".");
        while (t1.hasMoreTokens() && t2.hasMoreTokens()) {
            int n2;
            int n1 = Integer.parseInt(t1.nextToken());
            if (n1 == (n2 = Integer.parseInt(t2.nextToken()))) continue;
            return n1 < n2 ? -1 : 1;
        }
        if (t1.hasMoreTokens()) {
            return 1;
        }
        if (t2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public static boolean isSwingAvailable() {
        if (!swingChecked) {
            swingChecked = true;
            isSwingAvailable = false;
            if (Platform.compareVersion("1.2") >= 0) {
                try {
                    isSwingAvailable = Class.forName("javax.swing.JComponent") != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return isSwingAvailable;
    }

    public static boolean isSunAudioAvailable() {
        if (!sunAudioChecked) {
            sunAudioChecked = true;
            try {
                isSunAudioAvailable = Class.forName("sun.audio.AudioPlayer") != null;
            }
            catch (Exception ex) {
                isSunAudioAvailable = false;
            }
        }
        return isSunAudioAvailable;
    }

    public static boolean isJMFAvailable() {
        if (!jmfChecked) {
            jmfChecked = true;
            try {
                isJMFAvailable = Class.forName("javax.media.Player") != null;
            }
            catch (Exception ex) {
                isJMFAvailable = false;
            }
        }
        return isJMFAvailable;
    }

    public static boolean areCollectionsAvailable() {
        if (!collectionsChecked) {
            collectionsChecked = true;
            try {
                areCollectionsAvailable = Class.forName("java.util.ArrayList") != null;
            }
            catch (Exception ex) {
                areCollectionsAvailable = false;
            }
        }
        return areCollectionsAvailable;
    }

    public static boolean areStandardFontFamiliesAvailable() {
        if (!fontsChecked) {
            fontsChecked = true;
            try {
                Class<?> toolkitClass = Class.forName("java.awt.Toolkit");
                Method getFontList = toolkitClass.getMethod("getFontList", new Class[0]);
                String[] fonts = (String[])getFontList.invoke((Object)Toolkit.getDefaultToolkit(), new Object[0]);
                int standardFontCount = 0;
                for (int i = 0; i < fonts.length; ++i) {
                    if (!fonts[i].equals("Serif") && !fonts[i].equals("SansSerif") && !fonts[i].equals("Monospaced")) continue;
                    ++standardFontCount;
                }
                areStandardFontFamiliesAvailable = standardFontCount == 3;
            }
            catch (Exception ex) {
                areStandardFontFamiliesAvailable = false;
            }
        }
        return areStandardFontFamiliesAvailable;
    }
}

