/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import cpusim.ExecutionException;
import cpusim.IOChannel;
import cpusim.util.Convert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PushbackReader;

public class FileChannel
implements IOChannel {
    private File file;
    private PushbackReader reader;
    private FileWriter writer;

    public FileChannel(File file) {
        this.file = file;
        this.reader = null;
        this.writer = null;
    }

    @Override
    public long readLong(int numBits) {
        try {
            if (this.reader == null) {
                this.reader = new PushbackReader(new FileReader(this.file));
            }
            int c = this.reader.read();
            while (c != -1 && Character.isWhitespace((char)c)) {
                c = this.reader.read();
            }
            String s = "";
            if (c == 43 || c == 45) {
                s = s + (char)c;
                c = this.reader.read();
            }
            if (c == -1 || !Character.isDigit((char)c)) {
                throw new ExecutionException("Attempted to read an integer from file " + this.file.getName() + " but found " + (c == -1 ? "the end of file" : "" + (char)c) + ".");
            }
            while (c != -1 && Character.isDigit((char)c)) {
                s = s + (char)c;
                c = this.reader.read();
            }
            this.reader.unread(c);
            long value = Convert.fromAnyBaseStringToLong(s);
            Convert.checkFitsInBits(value, numBits);
            return value;
        }
        catch (NumberFormatException e) {
            throw new ExecutionException(e.getMessage());
        }
        catch (FileNotFoundException fne) {
            throw new ExecutionException("Attempted to read from file " + this.file.getName() + " but it could not be found.");
        }
        catch (IOException ioe) {
            throw new ExecutionException("CPUSim was unable to read from file " + this.file.getName() + ".");
        }
    }

    @Override
    public char readAscii() {
        try {
            int c;
            if (this.reader == null) {
                this.reader = new PushbackReader(new FileReader(this.file));
            }
            if ((c = this.reader.read()) > 255 || c < 0) {
                throw new ExecutionException("Attempted to read an ASCIIcharacter from file " + this.file.getName() + "\n but the next " + "character was " + (c == -1 ? "the end of file" : "" + (char)c) + ".");
            }
            return (char)c;
        }
        catch (FileNotFoundException fne) {
            throw new ExecutionException("Attempted to read from file " + this.file.getName() + " but it could not be found.");
        }
        catch (IOException ioe) {
            throw new ExecutionException("CPUSim was unable to read from file " + this.file.getName() + ".");
        }
    }

    @Override
    public char readUnicode() {
        try {
            int c;
            if (this.reader == null) {
                this.reader = new PushbackReader(new FileReader(this.file));
            }
            if ((c = this.reader.read()) < 0) {
                throw new ExecutionException("Attempted to read a Unicode character from file " + this.file.getName() + "\n but the " + " end of the file was reached.");
            }
            return (char)c;
        }
        catch (FileNotFoundException fne) {
            throw new ExecutionException("Attempted to read from file " + this.file.getName() + " but it could not be found.");
        }
        catch (IOException ioe) {
            throw new ExecutionException("CPUSim was unable to read from file " + this.file.getName() + ".");
        }
    }

    @Override
    public void writeLong(long value) {
        try {
            if (this.writer == null) {
                this.writer = new FileWriter(this.file);
            }
            String longString = " " + value;
            this.writer.write(longString, 0, longString.length());
        }
        catch (IOException ioe) {
            String message = "CPUSim was unable to write to file: " + this.file.getName();
            if (ioe.getMessage() != null) {
                message = message + " because: " + ioe.getMessage();
            }
            throw new ExecutionException(message);
        }
    }

    @Override
    public void writeAscii(long longValue) {
        if (longValue > 255L || longValue < 0L) {
            throw new ExecutionException("Attempt to output the value " + longValue + " as an ASCII value.");
        }
        try {
            if (this.writer == null) {
                this.writer = new FileWriter(this.file);
            }
            this.writer.write((int)longValue);
        }
        catch (IOException ioe) {
            String message = "CPUSim was unable to write to file: " + this.file.getName();
            if (ioe.getMessage() != null) {
                message = message + " because: " + ioe.getMessage();
            }
            throw new ExecutionException(message);
        }
    }

    @Override
    public void writeUnicode(long longValue) {
        if (longValue > 65535L || longValue < 0L) {
            throw new ExecutionException("Attempt to output the value " + longValue + " as a Unicode value.");
        }
        try {
            if (this.writer == null) {
                this.writer = new FileWriter(this.file);
            }
            this.writer.write((int)longValue);
        }
        catch (IOException ioe) {
            String message = "CPUSim was unable to write to file: " + this.file.getName();
            if (ioe.getMessage() != null) {
                message = message + " because: " + ioe.getMessage();
            }
            throw new ExecutionException(message);
        }
    }

    @Override
    public void reset() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (IOException ioe) {
            System.out.println("IOException occurred when attempting to reset the file: " + this.file + ".");
        }
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getName();
    }

    public String getID() {
        String s = super.toString();
        int index = s.indexOf(64);
        if (index == -1) {
            return s;
        }
        return s.substring(7, index) + s.substring(index + 1);
    }
}

