/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.gui.ActionListenerFor;
import cpusim.gui.CPUSimMenuItem;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.syntax.JEditTextArea;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.PageableText;
import cpusim.util.PrintPreview;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameListener;
import javax.swing.undo.UndoManager;

public class AssemblerWindow
extends BaseInternalFrame
implements CPUSimConstants {
    private JEditTextArea text;
    private File sourceFile;
    private boolean dirty;
    private UndoManager undoManager;

    public AssemblerWindow(File sourceFile, Point location, ActionListenerFor.CloseInternalTextFrame closeInternalTextFrameListener, InternalFrameListener activateAssemblerWindowListener, VetoableChangeListener vetoSelectionListener) {
        this(sourceFile.getName(), sourceFile, location, closeInternalTextFrameListener, activateAssemblerWindowListener, vetoSelectionListener);
    }

    public AssemblerWindow(String title, Point location, ActionListenerFor.CloseInternalTextFrame closeInternalTextFrameListener, InternalFrameListener activateAssemblerWindowListener, VetoableChangeListener vetoSelectionListener) {
        this(title, null, location, closeInternalTextFrameListener, activateAssemblerWindowListener, vetoSelectionListener);
    }

    public AssemblerWindow(String title, File sourceFile, Point location, ActionListenerFor.CloseInternalTextFrame closeInternalTextFrameListener, InternalFrameListener activateAssemblerWindowListener, VetoableChangeListener vetoSelectionListener) {
        super(title, true, true, true, true);
        boolean success;
        this.setSize(450, 550);
        Container contentPane = this.getContentPane();
        this.sourceFile = sourceFile;
        this.dirty = false;
        this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
        this.undoManager = new UndoManager();
        this.text = new JEditTextArea();
        this.text.setEditable(true);
        contentPane.add(this.text);
        if (sourceFile != null && !(success = this.openText())) {
            this.setTitle("untitled");
            this.sourceFile = null;
        }
        this.text.getSyntaxDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AssemblerWindow.this.dirty = true;
                AssemblerWindow.this.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AssemblerWindow.this.dirty = true;
                AssemblerWindow.this.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AssemblerWindow.this.dirty = true;
                AssemblerWindow.this.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
            }
        });
        this.setLocation(location.x, location.y);
        this.addInternalFrameListener(closeInternalTextFrameListener);
        this.addVetoableChangeListener(closeInternalTextFrameListener);
        this.addVetoableChangeListener(vetoSelectionListener);
        this.addInternalFrameListener(activateAssemblerWindowListener);
        this.text.setRightClickPopup(this.createRightClickMenu());
        this.setVisible(true);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public JEditTextArea getTextArea() {
        return this.text;
    }

    public void requestTextFocus() {
        this.text.requestFocus();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean save(FileDialog textFileChooser) {
        boolean success;
        if (!this.dirty && this.sourceFile != null) {
            return true;
        }
        if (this.sourceFile == null) {
            this.sourceFile = this.chooseTextFileToWriteTo(textFileChooser);
            if (this.sourceFile == null) {
                return false;
            }
            this.setTitle(this.sourceFile.getName());
        }
        if (success = this.saveText(this.sourceFile)) {
            this.dirty = false;
            this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
        }
        return success;
    }

    public void saveAs(FileDialog textFileChooser) {
        File newFile = this.chooseTextFileToWriteTo(textFileChooser);
        if (newFile == null) {
            return;
        }
        this.sourceFile = newFile;
        this.setTitle(this.sourceFile.getName());
        this.saveText(this.sourceFile);
        this.dirty = false;
        this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
    }

    public void printPreview(final PageFormat printFormat, final PrinterJob printJob) {
        Thread runner = new Thread(){

            @Override
            public void run() {
                AssemblerWindow.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    new PrintPreview(new PageableText(AssemblerWindow.this.text.getText(), printFormat), AssemblerWindow.this.getTitle() + " preview", printJob, printFormat);
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(AssemblerWindow.this.getDesktopPane(), "There was an IO error when the print preview was attempted.", "Print Preview Error", 0);
                }
                AssemblerWindow.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        runner.start();
    }

    public void print(final PageFormat printFormat, final PrinterJob printJob) {
        Thread runner = new Thread(){

            @Override
            public void run() {
                AssemblerWindow.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    PageableText textToPrint = new PageableText(AssemblerWindow.this.text.getText(), printFormat);
                    printJob.setPageable(textToPrint);
                    if (printJob.printDialog()) {
                        printJob.print();
                    }
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(AssemblerWindow.this.getDesktopPane(), "There was an IO error when printing was attempted.", "Print Error", 0);
                }
                catch (PrinterException exc) {
                    JOptionPane.showMessageDialog(AssemblerWindow.this.getDesktopPane(), "There was a printing error when printing was attempted.", "Print Error", 0);
                }
                AssemblerWindow.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        runner.start();
    }

    public void highlightTextFrom(int start, int end2) {
        this.text.requestFocus();
        this.text.select(start, end2);
    }

    public void setSelection(int xStart, int xFinish, boolean moveUp) {
        if (moveUp) {
            this.text.requestFocus();
            this.text.select(xFinish, xStart);
        } else {
            this.highlightTextFrom(xStart, xFinish);
        }
    }

    private boolean saveText(File file) {
        PrintWriter writer;
        Assert.That(file != null, "Called saveText with a null file.");
        try {
            writer = new PrintWriter(new FileOutputStream(file));
        }
        catch (FileNotFoundException exc) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "CPU Sim was unable to write to the file: " + file.getAbsolutePath(), "File Error", 0);
            return false;
        }
        writer.print(this.text.getText());
        writer.close();
        boolean writeError = writer.checkError();
        if (writeError) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "An unknown error occurred when trying to write to the file: " + file.getAbsolutePath(), "Unknown Error", 0);
            return false;
        }
        return true;
    }

    private boolean openText() {
        FileReader reader;
        try {
            reader = new FileReader(this.sourceFile);
        }
        catch (FileNotFoundException exc) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "CPU Sim could not find the file to open:  " + this.sourceFile.getAbsolutePath() + "\nA new empty" + " window will be opened.", "IO Error", 0);
            return false;
        }
        try {
            this.text.read(reader, null);
            reader.close();
        }
        catch (IOException ioExc) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "An error occurred when trying to read the file: " + this.sourceFile.getAbsolutePath() + "\nA new empty window will be opened.", "IO Error", 0);
            return false;
        }
        return true;
    }

    private File chooseTextFileToWriteTo(FileDialog textFileChooser) {
        textFileChooser.setVisible(true);
        String fileName = textFileChooser.getFile();
        String directoryName = textFileChooser.getDirectory();
        if (fileName == null) {
            return null;
        }
        return new File(directoryName + fileName);
    }

    public void setTextFont(Font font) {
        this.text.setFont(font);
    }

    public void setCaretPosition(int pos) {
        this.text.setCaretPosition(pos);
    }

    private JPopupMenu createRightClickMenu() {
        JPopupMenu rightClickMenu = new JPopupMenu();
        CPUSimMenuItem newItem = new CPUSimMenuItem("Cut", new ActionListenerFor.TextEdit(1));
        rightClickMenu.add(newItem);
        newItem = new CPUSimMenuItem("Copy", new ActionListenerFor.TextEdit(0));
        rightClickMenu.add(newItem);
        newItem = new CPUSimMenuItem("Paste", new ActionListenerFor.TextEdit(2));
        rightClickMenu.add(newItem);
        newItem = new CPUSimMenuItem("Delete", new ActionListenerFor.Delete());
        rightClickMenu.add(newItem);
        newItem = new CPUSimMenuItem("Select all", new ActionListenerFor.TextEdit(3));
        rightClickMenu.add(newItem);
        return rightClickMenu;
    }

    public void highlightAndScrollToLine(int line) {
        int startOffset = this.text.getLineStartOffset(line);
        int endOffset = this.text.getLineEndOffset(line);
        if (endOffset > this.text.getSyntaxDocumentLength()) {
            endOffset = this.text.getSyntaxDocumentLength();
        }
        try {
            this.text.select(startOffset, endOffset);
            this.text.scrollTo(line, 0);
            this.text.requestFocus();
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "There was an error when CPU Sim attempted to select line " + line + " in file " + this.getTitle(), "Highlight Error", 0);
        }
    }
}

