/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.gui.Desktop;
import cpusim.gui.FontData;
import cpusim.gui.LangUnit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontPrefsPanel
extends JPanel {
    private String textWindowFontChoice;
    private int textWindowStyleChoice;
    private int textWindowThemeChoice;
    private String textWindowSizeChoice;
    boolean lineWrapChoice;
    private String tableFontChoice;
    private int tableStyleChoice;
    private String tableSizeChoice;
    private Desktop desktop;

    public FontPrefsPanel(Desktop desktop) {
        this.desktop = desktop;
        FontData data = desktop.getFontData();
        this.textWindowFontChoice = data.textWindowFont.getFontName();
        this.textWindowSizeChoice = data.textWindowFont.getSize() + "";
        this.textWindowStyleChoice = data.textWindowFont.getStyle();
        this.textWindowThemeChoice = desktop.getTheme();
        this.lineWrapChoice = data.textWindowLineWrap;
        this.tableFontChoice = data.tableFont.getFontName();
        this.tableSizeChoice = data.tableFont.getSize() + "";
        this.tableStyleChoice = data.tableFont.getStyle();
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JPanel textPanel = this.createFontChangePanel(LangUnit.LU_ASM_CODE_WIN.str(), data.textWindowFont, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontPrefsPanel.this.textWindowFontChoice = (String)e.getItem();
                }
            }
        }, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontPrefsPanel.this.textWindowSizeChoice = (String)e.getItem();
                }
            }
        }, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontPrefsPanel.this.textWindowStyleChoice = ((JComboBox)e.getSource()).getSelectedIndex();
                }
            }
        });
        JPanel tablePanel = this.createFontChangePanel(LangUnit.LU_RAM_REG_WIN.str(), data.tableFont, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontPrefsPanel.this.tableFontChoice = (String)e.getItem();
                }
            }
        }, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontPrefsPanel.this.tableSizeChoice = (String)e.getItem();
                }
            }
        }, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontPrefsPanel.this.tableStyleChoice = ((JComboBox)e.getSource()).getSelectedIndex();
                }
            }
        });
        centerPanel.setLayout(new BoxLayout(centerPanel, 3));
        centerPanel.add(textPanel);
        centerPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        centerPanel.add(tablePanel);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)centerPanel, "Center");
    }

    public Font getFont(String font, int style, String size) {
        Integer newSize = new Integer(size);
        return new Font(font, style, newSize);
    }

    public int getTextWindowThemeChoice() {
        return this.textWindowThemeChoice;
    }

    public FontData getFontData() {
        return new FontData(this.getFont(this.textWindowFontChoice, this.textWindowStyleChoice, this.textWindowSizeChoice), this.getFont(this.tableFontChoice, this.tableStyleChoice, this.tableSizeChoice), this.lineWrapChoice);
    }

    private JPanel createFontChangePanel(String title, Font initialFont, ItemListener fontListener, ItemListener sizeListener, ItemListener styleListener) {
        JPanel result = new JPanel();
        JPanel fontPanel = new JPanel();
        JPanel sizePanel = new JPanel();
        JPanel stylePanel = new JPanel();
        JPanel centerPanel = new JPanel();
        result.setLayout(new BorderLayout());
        fontPanel.setLayout(new BoxLayout(fontPanel, 3));
        sizePanel.setLayout(new BoxLayout(sizePanel, 3));
        stylePanel.setLayout(new BoxLayout(stylePanel, 3));
        centerPanel.setLayout(new BoxLayout(centerPanel, 2));
        centerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        centerPanel.add(fontPanel);
        centerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        centerPanel.add(sizePanel);
        centerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        centerPanel.add(stylePanel);
        centerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        result.add("Center", centerPanel);
        result.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()), title));
        JLabel fontLabel = new JLabel(LangUnit.LU_FONT.str());
        fontLabel.setAlignmentX(0.0f);
        fontPanel.add(fontLabel);
        JLabel sizeLabel = new JLabel(LangUnit.LU_SIZE.str());
        sizeLabel.setAlignmentX(0.0f);
        sizePanel.add(sizeLabel);
        JLabel styleLabel = new JLabel(LangUnit.LU_STYLE.str());
        styleLabel.setAlignmentX(0.0f);
        stylePanel.add(styleLabel);
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        JComboBox<String> fonts = new JComboBox<String>(envfonts);
        fonts.setMaximumRowCount(9);
        String initFontName = initialFont.getFamily();
        fonts.setSelectedItem(initFontName);
        fonts.addItemListener(fontListener);
        fonts.setAlignmentX(0.0f);
        fontPanel.add(fonts);
        JComboBox<Object> sizes = new JComboBox<Object>(new Object[]{"10", "12", "14", "16", "18", "20", "24"});
        sizes.setMaximumRowCount(9);
        sizes.setSelectedItem(initialFont.getSize() + "");
        sizes.addItemListener(sizeListener);
        sizes.setAlignmentX(0.0f);
        sizePanel.add(sizes);
        JComboBox<Object> styles = new JComboBox<Object>(new Object[]{LangUnit.LU_PLAIN.str(), LangUnit.LU_BOLD.str(), LangUnit.LU_ITALIC.str(), LangUnit.LU_BOLD_ITALIC.str()});
        styles.setMaximumRowCount(9);
        styles.setSelectedIndex(initialFont.getStyle());
        styles.addItemListener(styleListener);
        styles.setAlignmentX(0.0f);
        stylePanel.add(styles);
        fontPanel.setMaximumSize(new Dimension(450, 45));
        sizePanel.setMaximumSize(new Dimension(450, 45));
        stylePanel.setMaximumSize(new Dimension(450, 45));
        if (title.equals(LangUnit.LU_ASM_CODE_WIN.str())) {
            JCheckBox wrapBox = new JCheckBox(LangUnit.LU_LINE_WRAP.str(), this.desktop.getFontData().textWindowLineWrap);
            wrapBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FontPrefsPanel.this.lineWrapChoice = e.getStateChange() == 1;
                }
            });
            JPanel themePanel = this.createThemeChangePanel(LangUnit.LU_COLOR_SCHEME.str(), new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        FontPrefsPanel.this.textWindowThemeChoice = ((JComboBox)e.getSource()).getSelectedIndex();
                    }
                }
            });
            centerPanel.add(Box.createVerticalStrut(10));
            themePanel.setLayout(new BoxLayout(themePanel, 3));
            centerPanel.add(themePanel);
        }
        return result;
    }

    private JPanel createThemeChangePanel(String title, ItemListener themeListener) {
        JPanel themePanel = new JPanel();
        JLabel themeLabel = new JLabel(title);
        themeLabel.setAlignmentX(0.0f);
        themePanel.add(themeLabel);
        JComboBox<String> themes = new JComboBox<String>(new String[]{"Default", "Blue Skies", "Green Spring", "Autumn Breeze", "Julia's Joy", "Dale's Desire", "Team Tuple"});
        themes.setMaximumRowCount(7);
        themes.setSelectedIndex(this.textWindowThemeChoice);
        themes.addItemListener(themeListener);
        themes.setAlignmentX(0.0f);
        themePanel.add(themes);
        themePanel.setMaximumSize(new Dimension(450, 45));
        return themePanel;
    }
}

