/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.FileChannel;
import cpusim.IOChannel;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.Register;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.xml.HtmlEncoder;

public class IO
extends Microinstruction
implements CPUSimConstants {
    public static final String[] DIRECTIONS = new String[]{"input", "output"};
    public static final String[] TYPES = new String[]{"integer", "ascii", "unicode"};
    private String direction;
    private String type;
    private Register buffer;
    private IOChannel connection;

    public IO(String name, String dir, String type, Register buf, IOChannel connection) {
        super(name);
        this.direction = dir;
        this.type = type;
        this.buffer = buf;
        this.connection = connection;
    }

    public IO(String name, String dir, String type, Register buf) {
        this(name, dir, type, buf, CONSOLE_CHANNEL);
    }

    public void setDirection(String d) {
        this.direction = d;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getType() {
        return this.type;
    }

    public void setBuffer(Register r) {
        this.buffer = r;
    }

    public Register getBuffer() {
        return this.buffer;
    }

    public void setConnection(IOChannel c) {
        this.connection = c;
    }

    public IOChannel getConnection() {
        return this.connection;
    }

    @Override
    public Object clone() {
        return new IO(this.getName(), this.getDirection(), this.getType(), this.getBuffer(), this.getConnection());
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof IO, "Passed non-IO to IO.copyDataTo()");
        IO newIO = (IO)newMicro;
        newIO.setName(this.getName());
        newIO.setDirection(this.getDirection());
        newIO.setType(this.getType());
        newIO.setBuffer(this.getBuffer());
        newIO.setConnection(this.getConnection());
    }

    @Override
    public boolean uses(Module m) {
        return m == this.buffer;
    }

    @Override
    public void execute() {
        int numBits = this.buffer.getWidth();
        if (this.type.equals("integer") && this.direction.equals("input")) {
            long inputLong = this.connection.readLong(numBits);
            this.buffer.setValue(inputLong);
        } else if (this.type.equals("ascii") && this.direction.equals("input")) {
            char c = this.connection.readAscii();
            this.buffer.setValue(c);
        } else if (this.type.equals("unicode") && this.direction.equals("input")) {
            char c = this.connection.readUnicode();
            this.buffer.setValue(c);
        } else if (this.type.equals("integer") && this.direction.equals("output")) {
            this.connection.writeLong(this.buffer.getValue());
        } else if (this.type.equals("ascii") && this.direction.equals("output")) {
            this.connection.writeAscii(this.buffer.getValue());
        } else if (this.type.equals("unicode") && this.direction.equals("output")) {
            this.connection.writeUnicode(this.buffer.getValue());
        } else {
            Assert.That(false, "IO '" + this.getName() + "' has an illegal " + "type or direction");
        }
    }

    @Override
    public String getXMLDescription() {
        return "<IO name=\"" + this.getHTMLName() + "\" direction=\"" + this.getDirection() + "\" type=\"" + this.getType() + "\" buffer=\"" + this.getBuffer().getID() + "\" connection=\"" + (this.getConnection() == USER_CHANNEL ? "[user]" : (this.getConnection() == CONSOLE_CHANNEL ? "[console]" : ((FileChannel)this.getConnection()).getID())) + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getDirection() + "</TD><TD>" + this.getType() + "</TD><TD>" + this.getBuffer().getHTMLName() + "</TD><TD>" + (this.getConnection() == USER_CHANNEL ? "[User]" : (this.getConnection() == CONSOLE_CHANNEL ? "[Console]" : HtmlEncoder.sEncode(((FileChannel)this.getConnection()).getFile().toString()))) + "</TD></TR>";
    }
}

