/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.Register;
import cpusim.util.Assert;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;

public class Logical
extends Microinstruction {
    public static final String[] TYPES = new String[]{"AND", "OR", "NAND", "NOR", "XOR", "NOT"};
    private Register source1;
    private Register source2;
    private Register destination;
    private String type;

    public Logical(String name, String type, Register source1, Register source2, Register destination) {
        super(name);
        this.setType(type);
        this.source1 = source1;
        this.source2 = source2;
        this.destination = destination;
    }

    public void setType(String newType) {
        this.type = newType;
        Assert.That(this.type.equals("AND") || this.type.equals("OR") || this.type.equals("NAND") || this.type.equals("NOR") || this.type.equals("XOR") || this.type.equals("NOT"), "Illegal type: " + this.type + " set for Logical micro: " + this.getName());
    }

    public void setSource1(Register r) {
        this.source1 = r;
    }

    public void setSource2(Register r) {
        this.source2 = r;
    }

    public void setDestination(Register r) {
        this.destination = r;
    }

    public String getType() {
        return this.type;
    }

    public Register getSource1() {
        return this.source1;
    }

    public Register getSource2() {
        return this.source2;
    }

    public Register getDestination() {
        return this.destination;
    }

    @Override
    public Object clone() {
        return new Logical(this.getName(), this.getType(), this.getSource1(), this.getSource2(), this.getDestination());
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof Logical, "Passed non-Logical to Logical.copyDataTo()");
        Logical newLogical = (Logical)newMicro;
        newLogical.setName(this.getName());
        newLogical.setType(this.getType());
        newLogical.setSource1(this.getSource1());
        newLogical.setSource2(this.getSource2());
        newLogical.setDestination(this.getDestination());
    }

    @Override
    public boolean uses(Module m) {
        return m == this.source1 || m == this.source2 || m == this.destination;
    }

    @Override
    public void execute() {
        long op1 = this.source1.getValue();
        long op2 = this.source2.getValue();
        long result = 0L;
        if (this.type.equals("AND")) {
            result = op1 & op2;
        } else if (this.type.equals("OR")) {
            result = op1 | op2;
        } else if (this.type.equals("NAND")) {
            result = op1 & op2 ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (this.type.equals("NOR")) {
            result = (op1 | op2) ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (this.type.equals("XOR")) {
            result = op1 ^ op2;
        } else if (this.type.equals("NOT")) {
            result = op1 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.destination.setValue(result);
    }

    @Override
    public String getXMLDescription() {
        return "<Logical name=\"" + this.getHTMLName() + "\" type=\"" + this.getType() + "\" source1=\"" + this.getSource1().getID() + "\" source2=\"" + this.getSource2().getID() + "\" destination=\"" + this.getDestination().getID() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getType() + "</TD><TD>" + this.getSource1().getHTMLName() + "</TD><TD>" + this.getSource2().getHTMLName() + "</TD><TD>" + this.getDestination().getHTMLName() + "</TD></TR>";
    }

    public static Logical createMicroFromDescription(StreamTokenizer tokenizer, HashMap registerTable) throws IOException {
        String name = tokenizer.sval;
        tokenizer.nextToken();
        String type = tokenizer.sval;
        tokenizer.nextToken();
        Register source1 = (Register)registerTable.get(tokenizer.sval);
        tokenizer.nextToken();
        Register source2 = (Register)registerTable.get(tokenizer.sval);
        tokenizer.nextToken();
        Register dest = (Register)registerTable.get(tokenizer.sval);
        return new Logical(name, type, source1, source2, dest);
    }
}

