/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.util.Assert;
import cpusim.util.Factory;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public abstract class MicroFactory
implements Factory {
    Machine machine;
    HashMap assocList;
    Microinstruction[] clones;
    JDialog parentFrame;

    public MicroFactory(Machine machine) {
        this.machine = machine;
        this.assocList = new HashMap();
        this.clones = null;
        this.parentFrame = null;
    }

    public void setParentFrame(JDialog parent) {
        this.parentFrame = parent;
    }

    public Microinstruction getNewMicro(String newName) {
        Microinstruction prototype = this.getPrototype();
        Microinstruction clone = (Microinstruction)prototype.clone();
        clone.setName(newName);
        return clone;
    }

    public Microinstruction[] getClones() {
        Assert.That(this.clones != null, "clones == null in MicroFactory.getClones()");
        return this.clones;
    }

    public Microinstruction getCurrentFromClone(Microinstruction clone) {
        return (Microinstruction)this.assocList.get(clone);
    }

    @Override
    public String getHelpPageID() {
        return "transfer";
    }

    public abstract void setClones(Object[] var1);

    public abstract void updateCurrentMicrosFromClones();

    public abstract HashMap getCellEditors();

    public HashMap getCellRenderers() {
        return null;
    }

    @Override
    public abstract boolean checkValidity(Object[] var1);

    public abstract String toString();

    public abstract String[] getProperties();

    @Override
    public Object[] createClones() {
        Vector currentMicros = this.getCurrentMicros();
        Object[] clones = (Microinstruction[])Array.newInstance(this.getMicroClass(), currentMicros.size());
        for (int i = 0; i < currentMicros.size(); ++i) {
            Microinstruction clone = (Microinstruction)((Microinstruction)currentMicros.elementAt(i)).clone();
            clones[i] = clone;
            this.assocList.put(clone, currentMicros.elementAt(i));
        }
        return clones;
    }

    Vector createNewMicroList(Microinstruction[] list) {
        Vector<Microinstruction> newMicros = new Vector<Microinstruction>();
        for (int i = 0; i < list.length; ++i) {
            Microinstruction micro = list[i];
            Microinstruction oldMicro = (Microinstruction)this.assocList.get(micro);
            if (oldMicro != null) {
                micro.copyDataTo(oldMicro);
                newMicros.addElement(oldMicro);
                continue;
            }
            newMicros.addElement(micro);
        }
        return this.sortVectorByName(newMicros);
    }

    private Vector sortVectorByName(Vector micros) {
        for (int i = 0; i < micros.size() - 1; ++i) {
            String nameOfSmallest = ((Microinstruction)micros.elementAt(i)).getName();
            int indexOfSmallest = i;
            for (int j = i + 1; j < micros.size(); ++j) {
                Microinstruction next = (Microinstruction)micros.elementAt(j);
                if (next.getName().compareTo(nameOfSmallest) >= 0) continue;
                indexOfSmallest = j;
                nameOfSmallest = next.getName();
            }
            Object temp = micros.elementAt(i);
            micros.setElementAt(micros.elementAt(indexOfSmallest), i);
            micros.setElementAt(temp, indexOfSmallest);
        }
        return micros;
    }

    boolean allNamesAreUnique(Microinstruction[] list) {
        for (int i = 0; i < list.length - 1; ++i) {
            for (int j = i + 1; j < list.length; ++j) {
                if (!list[i].getName().equals(list[j].getName())) continue;
                this.displayError("The name \"" + list[i].getName() + "\" is used more than once.\nAll names must be unique.");
                return false;
            }
        }
        return true;
    }

    boolean someNamesAreEmpty(Microinstruction[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getName().equals("")) continue;
            this.displayError("One or more names are empty.  \nAll names must have at least one character.");
            return true;
        }
        return false;
    }

    @Override
    public void displayError(String message) {
        JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
    }

    @Override
    public Object getNewObject(String name) {
        return this.getNewMicro(name);
    }

    abstract Microinstruction getPrototype();

    abstract Class getMicroClass();

    public abstract Vector getCurrentMicros();

    public abstract boolean newMicrosAreAllowed();
}

