/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.Module;
import cpusim.util.Assert;
import java.io.Serializable;

public class ControlUnit
extends Module
implements Serializable {
    private MachineInstruction currentInstruction;
    private int microIndex = 0;
    private Machine machine;

    public ControlUnit(String name, Machine machine) {
        super(name);
        this.currentInstruction = machine.getFetchSequence();
        this.machine = machine;
    }

    public int getMicroIndex() {
        return this.microIndex;
    }

    public void setMicroIndex(int index) {
        this.microIndex = index;
    }

    public void incrementMicroIndex(int amount) {
        this.microIndex += amount;
    }

    public MachineInstruction getCurrentInstruction() {
        return this.currentInstruction;
    }

    public void setCurrentInstruction(MachineInstruction instr) {
        this.currentInstruction = instr;
    }

    public void reset() {
        this.microIndex = 0;
        this.currentInstruction = this.machine.getFetchSequence();
    }

    @Override
    public Object clone() {
        ControlUnit clone = new ControlUnit(this.getName(), this.machine);
        clone.setMicroIndex(this.getMicroIndex());
        clone.setCurrentInstruction(this.getCurrentInstruction());
        return clone;
    }

    @Override
    public void copyDataTo(Module newModule) {
        Assert.That(newModule instanceof ControlUnit, "Passed non-ControlUnit to ControlUnit.copyDataTo()");
        ControlUnit newControl = (ControlUnit)newModule;
        newControl.setMicroIndex(this.microIndex);
        newControl.setCurrentInstruction(this.currentInstruction);
        newControl.machine = this.machine;
    }

    @Override
    public String getXMLDescription() {
        return this.getHTMLName();
    }

    @Override
    public String getHTMLDescription() {
        return this.getHTMLName();
    }

    public State getCurrentState() {
        return new State(this.currentInstruction, this.microIndex);
    }

    public void restoreState(State state) {
        state.restoreControlUnitToThisState();
    }

    public class State {
        private MachineInstruction instr;
        private int microIndex;

        public State(MachineInstruction instr, int microIndex) {
            this.instr = instr;
            this.microIndex = microIndex;
        }

        public void restoreControlUnitToThisState() {
            ControlUnit.this.currentInstruction = this.instr;
            ControlUnit.this.microIndex = this.microIndex;
        }
    }
}

