/*
 * Decompiled with CFR 0.152.
 */
package cpusim.syntax;

import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.assembler.PunctChar;
import cpusim.syntax.KeywordMap;
import cpusim.syntax.SyntaxTokenMarker;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.text.Segment;

public class CPUSimTokenMarker
extends SyntaxTokenMarker {
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;
    private char commentChar;
    private char labelChar;
    private HashSet<Character> symbolPunctChars;

    public CPUSimTokenMarker() {
        this(new Machine("New machine"));
    }

    public CPUSimTokenMarker(Machine m) {
        this.keywords = this.getKeywords(m);
        this.keywords.add("EQU", (byte)6);
        this.keywords.add("data", (byte)6);
        this.keywords.add("include", (byte)6);
        this.commentChar = this.getCommentChar(m);
        this.labelChar = this.getLabelChar(m);
        this.symbolPunctChars = this.getSymbolPunctChars(m);
    }

    private char getLabelChar(Machine machine) {
        PunctChar[] chars;
        for (PunctChar p : chars = machine.getPunctChars()) {
            if (!p.getUse().equals((Object)PunctChar.Use.label)) continue;
            return p.getChar();
        }
        return ':';
    }

    private HashSet<Character> getSymbolPunctChars(Machine machine) {
        PunctChar[] chars = machine.getPunctChars();
        HashSet<Character> result = new HashSet<Character>();
        for (PunctChar p : chars) {
            if (p.getUse() != PunctChar.Use.symbol) continue;
            result.add(Character.valueOf(p.getChar()));
        }
        return result;
    }

    private char getCommentChar(Machine machine) {
        PunctChar[] chars;
        for (PunctChar p : chars = machine.getPunctChars()) {
            if (p.getUse() != PunctChar.Use.comment) continue;
            return p.getChar();
        }
        return ';';
    }

    private KeywordMap getKeywords(Machine machine) {
        KeywordMap cpuKeywords = new KeywordMap(false);
        ArrayList<MachineInstruction> keywordsArray = new ArrayList<MachineInstruction>(machine.getInstructions());
        for (MachineInstruction currentKeyword : keywordsArray) {
            cpuKeywords.add(currentKeyword.getName(), (byte)6);
        }
        return cpuKeywords;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block3: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    if (c == this.labelChar) {
                        if (this.doKeyword(line, i, c)) continue block3;
                        backslash = false;
                        this.addToken(i1 - this.lastOffset, (byte)5);
                        this.lastOffset = this.lastKeyword = i1;
                        continue block3;
                    }
                    if (c == this.commentChar) {
                        backslash = false;
                        this.addToken(i - this.lastOffset, token);
                        this.addToken(length - i, (byte)1);
                        this.lastOffset = this.lastKeyword = length;
                        break block3;
                    }
                    backslash = false;
                    if (Character.isLetterOrDigit(c) || this.symbolPunctChars.contains(Character.valueOf(c))) continue block3;
                    this.doKeyword(line, i, c);
                    continue block3;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        this.addToken(length - this.lastOffset, token);
        return token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

