/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

import cpusim.util.NamedObject;
import cpusim.xml.HtmlEncoder;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;

public class EQU
implements Cloneable,
Serializable,
NamedObject {
    private String name;
    private long value;

    public EQU(String name, long value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setValue(long newValue) {
        this.value = newValue;
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Object clone() {
        return new EQU(this.getName(), this.getValue());
    }

    public void copyDataTo(EQU newEQU) {
        newEQU.setName(this.getName());
        newEQU.setValue(this.getValue());
    }

    public String getXMLDescription() {
        return "<EQU name=\"" + HtmlEncoder.sEncode(this.getName()) + "\" value=\"" + this.getValue() + "\" />";
    }

    public String getHTMLDescription() {
        return "<TR><TD>" + HtmlEncoder.sEncode(this.getName()) + "</TD><TD>" + this.getValue() + "</TD></TR>";
    }

    public static EQU createEQUFromDescription(StreamTokenizer tokenizer) throws IOException {
        String name = tokenizer.sval;
        tokenizer.nextToken();
        long value = (long)tokenizer.nval;
        return new EQU(name, value);
    }
}

