/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

import cpusim.Field;
import cpusim.FieldValue;
import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.assembler.AssemblyException;
import cpusim.assembler.EQU;
import cpusim.assembler.InstructionCall;
import cpusim.assembler.MacroDef;
import cpusim.assembler.Scanner;
import cpusim.assembler.Token;
import cpusim.util.Assert;
import cpusim.util.SourceLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Parser {
    private Scanner scanner;
    private Token token;
    private HashMap<Token, Token> equs;
    private List<InstructionCall> instructions;
    private HashMap<Token, MacroDef> macros;
    private int uniqueLabelNumber;
    private Machine machine;

    public Parser(Scanner s, Machine machine) {
        this.scanner = s;
        this.equs = new HashMap();
        this.instructions = new ArrayList<InstructionCall>();
        this.macros = new HashMap();
        this.machine = machine;
    }

    public void initialize() {
        this.instructions.clear();
        this.macros.clear();
        this.equs.clear();
        this.uniqueLabelNumber = 0;
        this.advance();
    }

    public void parse() {
        this.Program();
    }

    public List<InstructionCall> getInstructions() {
        return this.instructions;
    }

    public HashMap<Token, Token> getEqus() {
        return this.equs;
    }

    private void advance() {
        this.token = this.scanner.getNextToken();
        if (this.token != null && !this.token.isLegal()) {
            throw new AssemblyException("Error: non-sensical token was found: \"" + this.token.contents + "\"", this.token);
        }
    }

    private boolean currentTokenHasOneOfTypes(int[] types) {
        for (int type : types) {
            if (this.token.type != type) continue;
            return true;
        }
        return false;
    }

    private void Program() {
        if (this.token.type == 9 || this.token.type == 3) {
            this.Comments_and_EOLs();
        }
        this.Equ_and_Include_and_macro_part();
        this.Instr_part();
        if (!this.currentTokenHasOneOfTypes(new int[]{8})) {
            throw new AssemblyException("Error: no EOF token found...  program seemed to end prematurely.\n       This probably means there is something missing or something extra at the following location,\n       or there is some other type of faulty structure to your program...", this.token);
        }
    }

    private void Include() {
        this.advance();
        if (!this.currentTokenHasOneOfTypes(new int[]{16})) {
            throw new AssemblyException("Error: There needs to be a path in quotes or in angle brackets <...> after the  .include pseudo-instruction", this.token);
        }
        Token pathToken = this.token;
        this.advance();
        if (this.token.type == 9) {
            this.advance();
        }
        this.scanner.startScanning(pathToken);
    }

    private void Comments_and_EOLs() {
        do {
            if (!this.currentTokenHasOneOfTypes(new int[]{9, 3, 8})) {
                throw new AssemblyException("Error: there was supposed to be either a comment or an\n       end of line or end of file, " + (this.token.contents.equals("") ? "" : "not \"" + this.token.contents + "\""), this.token);
            }
            this.advance();
        } while (this.currentTokenHasOneOfTypes(new int[]{9, 3}));
    }

    private void Equ_and_Include_and_macro_part() {
        while (this.currentTokenHasOneOfTypes(new int[]{2, 10, 14})) {
            if (this.token.type == 14) {
                this.Include();
            } else if (this.token.type == 10) {
                this.Macro_decl();
            } else {
                if (this.macros.get(this.token) != null) break;
                this.Equ_decl();
            }
            this.Comments_and_EOLs();
        }
    }

    private void Equ_decl() {
        this.checkEquNotAlreadyUsed(this.token);
        Token key = this.token;
        this.advance();
        if (!this.currentTokenHasOneOfTypes(new int[]{6})) {
            throw new AssemblyException("Error: This looks like an EQU declaration,\nbut there is no 'EQU' following the word \"" + key + "\".", key);
        }
        this.advance();
        if (!this.currentTokenHasOneOfTypes(new int[]{2, 5})) {
            throw new AssemblyException("Error: This is an unfinished EQU declaration", this.token);
        }
        if (this.token.type == 2) {
            this.checkEquDefined(this.token);
        }
        this.equs.put(key, this.token);
        this.advance();
    }

    private void Macro_decl() {
        this.advance();
        if (!this.currentTokenHasOneOfTypes(new int[]{2, 0})) {
            throw new AssemblyException("Error: This macro needs a name", this.token);
        }
        Token macroName = this.token;
        if (this.macros.get(macroName) != null) {
            throw new AssemblyException("Error: A macro by the name \"" + macroName + "\" already exists.", this.token);
        }
        this.advance();
        ArrayList<Token> macroParameters = new ArrayList<Token>();
        while (this.token.type == 2) {
            macroParameters.add(this.token);
            this.advance();
            if (this.token.type != 7) continue;
            this.advance();
        }
        this.Comments_and_EOLs();
        ArrayList<Token> macroBody = new ArrayList<Token>();
        while (this.token.type != 11 && this.token.type != 8) {
            if (this.token.type == 14) {
                this.Include();
                this.advance();
            }
            macroBody.add(this.token);
            this.advance();
        }
        if (this.token.type == 8) {
            throw new AssemblyException("Error: The macro declaration for \"" + macroName + "\" is missing the \"ENDM\" keyword.", macroName);
        }
        this.advance();
        this.macros.put(macroName, new MacroDef(macroName, macroParameters, macroBody));
    }

    private void Instr_part() {
        while (this.token.type == 14 || this.token.type == 4 || this.token.type == 0 || this.token.type == 1 || this.token.type == 2 || this.token.type == 15) {
            if (this.token.type == 14) {
                this.Include();
            } else {
                this.Instr();
            }
            this.Comments_and_EOLs();
        }
    }

    private void Instr() {
        InstructionCall node = new InstructionCall(this.machine.getCodeStore().getCellSize());
        while (this.token.type == 4) {
            List<MachineInstruction> instructions = this.scanner.getMachine().getInstructions();
            for (MachineInstruction instruction : instructions) {
                if (!this.token.contents.equals(instruction.getName() + this.machine.getLabelChar())) continue;
                throw new AssemblyException("Error: Opcode names cannot be used as label names", this.token);
            }
            node.labels.add(this.token);
            node.comment = node.comment + this.token.contents + " ";
            this.advance();
            if (this.token.type != 9 && this.token.type != 3) continue;
            this.Comments_and_EOLs();
            node.comment = "";
        }
        if (!this.currentTokenHasOneOfTypes(new int[]{0, 1, 2, 15}) || this.token.type == 2 && !this.macros.containsKey(this.token)) {
            throw new AssemblyException("Error: There must be a data pseudo-instruction, a macro call, an ascii pseudo-instruction or a normal instruction after a label", this.token);
        }
        if (this.macros.containsKey(this.token)) {
            node.comment = "";
            this.macroCall();
            this.scanner.pushTokens(node.labels);
            return;
        }
        if (this.token.type == 15) {
            this.parseAsciiPseudoinstruction(node);
        } else if (this.token.type == 1) {
            this.parseDataPseudoinstruction(node);
        } else {
            this.parseRegularInstruction(node);
        }
        if (this.token.type == 9) {
            node.comment = node.comment + " " + this.token.contents;
        }
        this.instructions.add(node);
    }

    private void parseAsciiPseudoinstruction(InstructionCall node) {
        node.sourceLine = new SourceLine(this.token.lineNumber, this.token.filename);
        if (node.comment.equals("")) {
            node.comment = "\t";
        }
        node.comment = node.comment + ".ascii ";
        this.advance();
        node.machineInstruction = null;
        if (!this.currentTokenHasOneOfTypes(new int[]{16}) || this.token.contents.charAt(0) == '<') {
            throw new AssemblyException("Error: There needs to be a quoted string in the .ascii pseudo-instruction", this.token);
        }
        node.comment = node.comment + this.token.contents;
        int numChars = this.token.contents.length() - 2;
        int cellSize = this.machine.getCodeStore().getCellSize();
        int numCellsPerChar = (8 + cellSize - 1) / cellSize;
        node.operands.add(new Token(null, 5, -1, -1, -1, numChars * numCellsPerChar + "", true));
        node.operands.add(new Token(null, 5, -1, -1, -1, numCellsPerChar + "", true));
        for (int i = 1; i <= numChars; ++i) {
            node.operands.add(new Token(null, 5, -1, -1, -1, this.token.contents.charAt(i) + "", true));
        }
        this.advance();
    }

    private void parseRegularInstruction(InstructionCall node) {
        node.sourceLine = new SourceLine(this.token.lineNumber, this.token.filename);
        List<MachineInstruction> instructions = this.scanner.getMachine().getInstructions();
        for (MachineInstruction instruction : instructions) {
            if (!this.token.contents.equals(instruction.getName())) continue;
            node.machineInstruction = instruction;
        }
        if (node.comment.equals("")) {
            node.comment = "        ";
        }
        node.comment = node.comment + this.token.contents + " ";
        this.advance();
        List<Field> fields = node.machineInstruction.getFields();
        for (int i = 1; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (field.getNumBits() == 0 && field.getType() == Field.Type.required) {
                this.check(field.getName().equals(this.token.contents), this.token, "The token should be \"" + field.getName() + "\"");
                this.addTokenToComments(node, this.token);
                this.advance();
                continue;
            }
            if (field.getNumBits() == 0) {
                if (!field.getName().equals(this.token.contents)) continue;
                this.addTokenToComments(node, this.token);
                this.advance();
                continue;
            }
            if (field.getType() == Field.Type.ignored) {
                node.operands.add(new Token(this.token.filename, 5, this.token.lineNumber, this.token.columnNumber, this.token.offset, "" + field.getDefaultValue(), true));
                continue;
            }
            if (field.getType() == Field.Type.optional) {
                this.check(false, this.token, "Optional fields of positive length are not allowed in this version");
                continue;
            }
            if (field.getValues().size() == 0) {
                this.check(this.currentTokenHasOneOfTypes(new int[]{2, 5}), this.token, "The token \"" + this.token.contents + "\" is not a legal operand here");
                node.operands.add(this.token);
                this.addTokenToComments(node, this.token);
                this.advance();
                continue;
            }
            this.check(this.currentTokenHasOneOfTypes(new int[]{2, 5}), this.token, "The token \"" + this.token.contents + "\" is not a legal operand here");
            boolean found = false;
            for (FieldValue value : field.getValues()) {
                if (!value.getName().equals(this.token.contents)) continue;
                found = true;
            }
            this.check(found, this.token, "The token \"" + this.token.contents + "\" is not one of the legal" + " values for this field");
            node.operands.add(this.token);
            this.addTokenToComments(node, this.token);
            this.advance();
        }
        this.check(this.currentTokenHasOneOfTypes(new int[]{9, 3, 8}), this.token, "The token \"" + this.token.contents + "\" is illegal here");
    }

    private void addTokenToComments(InstructionCall node, Token token) {
        node.comment = Character.isLetterOrDigit(node.comment.charAt(node.comment.length() - 1)) && Character.isLetterOrDigit(token.contents.charAt(0)) ? node.comment + " " + token.contents : node.comment + token.contents;
    }

    private void check(boolean condition, Token token, String message) {
        if (!condition) {
            throw new AssemblyException(message, token);
        }
    }

    private void parseDataPseudoinstruction(InstructionCall node) {
        node.sourceLine = new SourceLine(this.token.lineNumber, this.token.filename);
        if (node.comment.equals("")) {
            node.comment = "\t";
        }
        node.comment = node.comment + ".data";
        this.advance();
        node.machineInstruction = null;
        this.check(this.currentTokenHasOneOfTypes(new int[]{2, 5}), this.token, "Error: The data pseudo-instruction must have an integer as first operand");
        node.operands.add(this.token);
        node.comment = node.comment + " " + this.token.contents;
        this.advance();
        if (this.token.contents.equals(",")) {
            this.advance();
        }
        if (this.currentTokenHasOneOfTypes(new int[]{2, 5})) {
            node.operands.add(this.token);
            node.comment = node.comment + " " + this.token.contents;
            this.advance();
        } else if (this.token.contents.equals("[")) {
            node.operands.add(new Token(null, 5, -1, -1, -1, "1", true));
        } else {
            throw new AssemblyException("Error: The data pseudo-instruction has an illegal second operand", this.token);
        }
        if (this.token.contents.equals("[")) {
            node.comment = node.comment + " [";
            this.advance();
            while (this.token.type == 2 || this.token.type == 5) {
                node.operands.add(this.token);
                node.comment = node.comment + " " + this.token.contents;
                this.advance();
                if (!this.token.contents.equals(",")) continue;
                this.advance();
            }
            if (!this.token.contents.equals("]")) {
                throw new AssemblyException("Error: Closing bracket ']' expected", this.token);
            }
            node.comment = node.comment + "]";
            this.advance();
        }
    }

    private void macroCall() {
        int j;
        HashMap<Token, Token> uniqueLabelHash = new HashMap<Token, Token>();
        Token macroDefKey = this.token;
        this.advance();
        List<Token> macroArgs = this.getMacroArgs();
        MacroDef mdef = this.getMdef(macroDefKey, macroArgs);
        HashMap<Token, Token> parameterArgHash = this.getParameterArgHash(macroArgs, mdef);
        List<Token> specializedMacroBody = this.specializedMacroBody(mdef, parameterArgHash);
        ArrayList<Token> localLabels = new ArrayList<Token>();
        for (j = 0; j < specializedMacroBody.size(); ++j) {
            this.firstPass(specializedMacroBody, localLabels, j);
        }
        for (j = 0; j < specializedMacroBody.size(); ++j) {
            this.secondPass(uniqueLabelHash, specializedMacroBody, localLabels, j);
        }
        this.scanner.pushTokens(specializedMacroBody);
    }

    private void secondPass(HashMap<Token, Token> uniqueLabelHash, List<Token> specializedMacroBody, List<Token> localLabels, int j) {
        if (localLabels.contains(specializedMacroBody.get(j))) {
            char labelChar = this.machine.getLabelChar();
            Token toReplace = specializedMacroBody.get(j);
            Token t = specializedMacroBody.get(j);
            if (t.contents.charAt(t.contents.length() - 1) == labelChar) {
                t = new Token(t.filename, t.type, t.lineNumber, t.columnNumber, t.offset, t.contents.substring(0, t.contents.length() - 1), t.isLegal);
            }
            if (!uniqueLabelHash.containsKey(t)) {
                String uniqueLabelContents = "L$" + this.uniqueLabelNumber;
                Token uniqueLabelToken1 = new Token(t.filename, 2, t.lineNumber, t.columnNumber, t.offset, uniqueLabelContents, t.isLegal());
                uniqueLabelHash.put(t, uniqueLabelToken1);
                t = new Token(t.filename, 4, t.lineNumber, t.columnNumber, t.offset, t.contents + labelChar, t.isLegal);
                uniqueLabelContents = uniqueLabelContents + labelChar;
                Token uniqueLabelToken2 = new Token(t.filename, 4, t.lineNumber, t.columnNumber, t.offset, uniqueLabelContents, t.isLegal());
                uniqueLabelHash.put(t, uniqueLabelToken2);
                ++this.uniqueLabelNumber;
            }
            specializedMacroBody.set(j, uniqueLabelHash.get(toReplace));
        }
    }

    private void firstPass(List<Token> specializedMacroBody, List<Token> localLabels, int j) {
        Token t = specializedMacroBody.get(j);
        if (t.type == 4) {
            if (localLabels.contains(t)) {
                throw new AssemblyException("Error: The label \"" + t.contents + "\" is used twice in the macro " + "and so cannot be used here", t);
            }
            localLabels.add(t);
            localLabels.add(new Token(t.filename, 2, t.lineNumber, t.columnNumber, t.offset, t.contents.substring(0, t.contents.length() - 1), t.isLegal));
        }
    }

    private List<Token> specializedMacroBody(MacroDef mdef, HashMap<Token, Token> parameterArgHash) {
        ArrayList<Token> specializedMacroBody = new ArrayList<Token>();
        for (Token token : mdef.body) {
            if (parameterArgHash.containsKey(token)) {
                specializedMacroBody.add(parameterArgHash.get(token));
                continue;
            }
            specializedMacroBody.add(token);
        }
        return specializedMacroBody;
    }

    private HashMap<Token, Token> getParameterArgHash(List<Token> macroArgs, MacroDef mdef) {
        HashMap<Token, Token> parameterArgHash = new HashMap<Token, Token>();
        for (int i = 0; i < mdef.parameters.size(); ++i) {
            parameterArgHash.put(mdef.parameters.get(i), macroArgs.get(i));
        }
        return parameterArgHash;
    }

    private MacroDef getMdef(Token macroDefKey, List<Token> macroArgs) {
        MacroDef mdef = this.macros.get(macroDefKey);
        Assert.That(mdef != null, "null macro def in getMdef");
        if (mdef.parameters.size() != macroArgs.size()) {
            throw new AssemblyException("Error: Wrong number of arguments in macro call \"" + macroDefKey.contents + "\"." + "\n       Supposed to be " + mdef.parameters.size() + " argument(s), not " + macroArgs.size(), macroDefKey);
        }
        return mdef;
    }

    private List<Token> getMacroArgs() {
        ArrayList<Token> macroArgs = new ArrayList<Token>();
        while (this.token.type == 2 || this.token.type == 5) {
            macroArgs.add(this.token);
            this.advance();
            if (this.token.type != 7) continue;
            this.advance();
        }
        return macroArgs;
    }

    private boolean checkEquNotAlreadyUsed(Token token) {
        boolean isValid = true;
        Set<Token> equSet = this.equs.keySet();
        for (Token currentKey : equSet) {
            if (!token.equals(currentKey)) continue;
            throw new AssemblyException("Error: the EQU key \"" + currentKey.contents + "\" has already been defined", token);
        }
        return isValid;
    }

    private void checkEquDefined(Token token) {
        Vector globalEqus = this.machine.getEQUs();
        for (int i = 0; i < globalEqus.size(); ++i) {
            String key = ((EQU)globalEqus.elementAt(i)).getName();
            if (!key.equals(token.contents)) continue;
            return;
        }
        Set<Token> equSet = this.equs.keySet();
        for (Token key : equSet) {
            if (!token.equals(key)) continue;
            return;
        }
        throw new AssemblyException("Error: EQU value \"" + token.contents + "\" is not previously defined", token);
    }
}

