/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.Microinstruction;
import cpusim.gui.Desktop;
import cpusim.util.BackupManager;
import cpusim.util.CPUSimConstants;
import cpusim.util.OutlineChangesManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class DebugToolBar
extends JToolBar
implements CPUSimConstants {
    private Machine machine;
    private Desktop desktop;
    private BackupManager backupManager;
    private JLabel currentInstrLabel;
    private JList currentMicrosList;
    private OutlineChangesManager outlineChanger;
    public JButton goButton;
    public JButton stepByInstrButton;
    public JButton stepByMicroButton;
    public JButton backupMachineInstrButton;
    public JButton backupMicroInstrButton;
    public JButton startOverButton;

    public DebugToolBar(Desktop desktop) {
        MouseMotionListener[] mouseMotionListeners;
        MouseListener[] mouseListeners;
        this.desktop = desktop;
        this.machine = desktop.getMachine();
        this.backupManager = desktop.getBackupManager();
        this.outlineChanger = new OutlineChangesManager(this.backupManager, desktop);
        this.currentInstrLabel = new JLabel("Fetch Seq: ");
        this.currentMicrosList = new JList<Microinstruction>(new Vector<Microinstruction>(this.machine.getFetchSequence().getMicros()));
        this.currentMicrosList.setVisibleRowCount(3);
        for (MouseListener l : mouseListeners = this.currentMicrosList.getMouseListeners()) {
            this.currentMicrosList.removeMouseListener(l);
        }
        for (MouseMotionListener l : mouseMotionListeners = this.currentMicrosList.getMouseMotionListeners()) {
            this.currentMicrosList.removeMouseMotionListener(l);
        }
        this.setBorderPainted(true);
        this.goButton = new JButton("Go");
        this.goButton.setMnemonic('G');
        this.stepByInstrButton = new JButton("Step by Instr");
        this.stepByInstrButton.setMnemonic('S');
        this.stepByMicroButton = new JButton("Step by Micro");
        this.stepByMicroButton.setMnemonic('p');
        this.backupMachineInstrButton = new JButton("Backup one Instr");
        this.backupMachineInstrButton.setMnemonic('B');
        this.backupMicroInstrButton = new JButton("Backup one Micro");
        this.backupMicroInstrButton.setMnemonic('k');
        this.startOverButton = new JButton("Start over");
        this.startOverButton.setMnemonic('r');
        this.add(this.goButton);
        this.addSeparator();
        this.add(this.stepByInstrButton);
        this.addSeparator();
        this.add(this.stepByMicroButton);
        this.addSeparator();
        this.add(this.backupMachineInstrButton);
        this.addSeparator();
        this.add(this.backupMicroInstrButton);
        this.addSeparator();
        this.add(this.startOverButton);
        this.addSeparator();
        this.add(this.currentInstrLabel);
        this.add(new JScrollPane(this.currentMicrosList));
        this.add(new JPanel());
        this.add(new JPanel());
        this.goButton.addActionListener(new GoActionListener());
        this.stepByMicroButton.addActionListener(new MicroStepActionListener());
        this.stepByInstrButton.addActionListener(new InstrStepActionListener());
        this.backupMachineInstrButton.addActionListener(new BackupInstrActionListener());
        this.backupMicroInstrButton.addActionListener(new BackupMicroActionListener());
        this.startOverButton.addActionListener(new StartOverActionListener());
        this.updateDisplay();
    }

    public void setEnableAllButtons(boolean b) {
        this.goButton.setEnabled(b);
        this.stepByInstrButton.setEnabled(b);
        this.stepByMicroButton.setEnabled(b);
        this.backupMachineInstrButton.setEnabled(b);
        this.backupMicroInstrButton.setEnabled(b);
        this.startOverButton.setEnabled(b);
    }

    public void updateDisplay() {
        this.updateDisplay(false);
    }

    public void updateDisplay(boolean outlineChanges) {
        MachineInstruction currentInstruction = this.machine.getControlUnit().getCurrentInstruction();
        this.currentMicrosList.setListData(new Vector<Microinstruction>(currentInstruction.getMicros()));
        this.currentInstrLabel.setText(currentInstruction.getName() + ": ");
        int index = this.machine.getControlUnit().getMicroIndex();
        this.currentMicrosList.setSelectionInterval(index, index);
        if (index == 0 || index == this.currentMicrosList.getModel().getSize() - 1) {
            this.currentMicrosList.ensureIndexIsVisible(index);
        } else {
            this.currentMicrosList.ensureIndexIsVisible(index + 1);
            this.currentMicrosList.ensureIndexIsVisible(index - 1);
        }
        if (this.backupManager.canBackupOneMachineInstr()) {
            this.backupMachineInstrButton.setEnabled(true);
            this.backupMicroInstrButton.setEnabled(true);
            this.startOverButton.setEnabled(true);
        } else {
            this.backupMachineInstrButton.setEnabled(false);
            this.backupMicroInstrButton.setEnabled(false);
            this.startOverButton.setEnabled(false);
        }
        this.desktop.getUpdateDisplayManager().updateRegisterAndRAMWindows();
        if (index == 0 && this.machine.getFetchSequence() == currentInstruction) {
            this.desktop.getHighlightManager().saveStartOfCycleValues();
        }
        this.desktop.getHighlightManager().highlightCellsAndText();
        if (outlineChanges) {
            this.outlineChanger.updateOutlines();
        } else {
            this.outlineChanger.clearAllOutlines();
        }
    }

    public void clearOutlines() {
        this.outlineChanger.clearAllOutlines();
    }

    public void updateOutlines() {
        this.outlineChanger.updateOutlines();
    }

    private class BackupInstrActionListener
    implements ActionListener {
        private BackupInstrActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugToolBar.this.backupManager.backupOneMachineInstruction();
            DebugToolBar.this.machine.getControlUnit().reset();
            DebugToolBar.this.updateDisplay();
        }
    }

    private class BackupMicroActionListener
    implements ActionListener {
        private BackupMicroActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugToolBar.this.backupManager.backupOneMicroInstruction();
            DebugToolBar.this.updateDisplay();
            DebugToolBar.this.outlineChanger.updateOutlines();
        }
    }

    private class StartOverActionListener
    implements ActionListener {
        private StartOverActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugToolBar.this.backupManager.backupAllTheWay();
            DebugToolBar.this.machine.getControlUnit().reset();
            DebugToolBar.this.machine.resetAllChannels();
            DebugToolBar.this.updateDisplay();
        }
    }

    private class InstrStepActionListener
    implements ActionListener {
        private InstrStepActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugToolBar.this.machine.execute(2);
        }
    }

    private class MicroStepActionListener
    implements ActionListener {
        private MicroStepActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugToolBar.this.machine.execute(1);
        }
    }

    private class GoActionListener
    implements ActionListener {
        private GoActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugToolBar.this.machine.execute(3);
        }
    }
}

