/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.ControlUnit;
import cpusim.util.Assert;

public class Branch
extends Microinstruction {
    private int amount;
    private ControlUnit controlUnit;

    public Branch(String name, int amount, ControlUnit controlUnit) {
        super(name);
        this.amount = amount;
        this.controlUnit = controlUnit;
    }

    public void setAmount(int newAmount) {
        this.amount = newAmount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public Object clone() {
        return new Branch(this.getName(), this.getAmount(), this.controlUnit);
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof Branch, "Passed non-Branch to Branch.copyDataTo()");
        Branch newBranch = (Branch)newMicro;
        newBranch.setName(this.getName());
        newBranch.setAmount(this.amount);
        newBranch.controlUnit = this.controlUnit;
    }

    @Override
    public boolean uses(Module m) {
        return false;
    }

    @Override
    public void execute() {
        this.controlUnit.incrementMicroIndex(this.amount);
    }

    @Override
    public String getXMLDescription() {
        return "<Branch name=\"" + this.getHTMLName() + "\" amount=\"" + this.getAmount() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getAmount() + "</TD></TR>";
    }
}

