/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.ExecutionException;
import cpusim.Module;
import cpusim.assembler.AssembledInstructionCall;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.Convert;
import cpusim.util.LoadException;
import cpusim.util.SourceLine;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RAM
extends Module
implements CPUSimConstants {
    private long[] data;
    private int cellSize;
    private boolean[] breaks;
    private String[] comments;
    private boolean haltAtBreaks;
    private SourceLine[] sourceLines;
    private long cellMask;

    public RAM(String name, int length) {
        this(name, length, 5);
    }

    public RAM(String name, int length, int cellSize) {
        super(name);
        int i;
        this.cellSize = cellSize;
        this.data = new long[length];
        this.breaks = new boolean[length];
        this.haltAtBreaks = false;
        this.comments = new String[length];
        for (i = 0; i < length; ++i) {
            this.comments[i] = "";
        }
        this.sourceLines = new SourceLine[length];
        this.cellMask = 0L;
        for (i = 0; i < cellSize; ++i) {
            this.cellMask = (this.cellMask << 1) + 1L;
        }
    }

    public long getData(int addr) {
        if (addr < 0 || addr >= this.data.length) {
            throw new ExecutionException("Attempted to access RAM " + this.getName() + " at address " + addr + " which is out of range");
        }
        return this.data[addr] << 64 - this.cellSize >> 64 - this.cellSize;
    }

    public long getData(int addr, int numBits) {
        int numCells = (numBits + this.cellSize - 1) / this.cellSize;
        if (addr < 0 || addr + numCells > this.data.length) {
            throw new ExecutionException("Attempted to access RAM " + this.getName() + " at addresses " + addr + " to " + (addr + numCells - 1) + " which is out of range");
        }
        Assert.That(numBits > 0 && numBits <= 64, "RAM.getData() was called with numBits = " + numBits);
        long value = 0L;
        for (int i = addr; i < addr + numCells - 1; ++i) {
            value = (value << this.cellSize) + (this.data[i] & this.cellMask);
        }
        int numBitsLeft = numBits % this.cellSize == 0 ? this.cellSize : numBits % this.cellSize;
        long tempMask = (1L << numBitsLeft) - 1L;
        value = (value << numBitsLeft) + (this.data[addr + numCells - 1] & tempMask);
        value = value << 64 - numBits >> 64 - numBits;
        return value;
    }

    public void setData(int addr, long value, int numBits) {
        int j;
        int numCells = (numBits + this.cellSize - 1) / this.cellSize;
        if (addr < 0 || addr + numCells > this.data.length) {
            throw new ExecutionException("Attempt to access data in RAM " + this.getName() + " at addresses " + addr + " to " + (addr + numCells - 1) + " which are out of range");
        }
        Assert.That(numBits > 0, "RAM.setData() was called with numBits = " + numBits);
        long[] oldData = new long[numCells];
        for (j = 0; j < numCells; ++j) {
            oldData[j] = this.data[addr + j];
        }
        if (numBits % numCells != 0) {
            int tempIndex;
            long tempMask = (1L << numBits % numCells) - 1L;
            long tempValue = value & tempMask;
            int n = tempIndex = addr + numCells - 1;
            this.data[n] = this.data[n] & -1L - (tempMask << this.cellSize - numBits % numCells);
            int n2 = tempIndex;
            this.data[n2] = this.data[n2] | tempValue << this.cellSize - numBits % numCells;
            value >>= numBits % numCells;
            for (int j2 = numCells - 2; j2 >= 0; --j2) {
                this.data[addr + j2] = value & this.cellMask;
                value >>= this.cellSize;
            }
        } else {
            for (j = numCells - 1; j >= 0; --j) {
                this.data[addr + j] = value & this.cellMask;
                value >>= this.cellSize;
            }
        }
        this.getChangeSupport().firePropertyChange("data", oldData, new Point(addr, numCells));
    }

    public void setData(int addr, long value) {
        long[] oldValue = new long[]{this.data[addr]};
        this.data[addr] = value & this.cellMask;
        this.getChangeSupport().firePropertyChange("data", oldValue, new Point(addr, 1));
    }

    public String[] getComments() {
        return this.comments;
    }

    public void setComments(int i, String value) {
        this.comments[i] = value.replace('\t', ' ');
        this.getChangeSupport().firePropertyChange("comments", null, new Point(i, 1));
    }

    public SourceLine getSourceLine(int index) {
        if (0 <= index && index < this.sourceLines.length) {
            return this.sourceLines[index];
        }
        return null;
    }

    public void setSourceLine(int index, SourceLine sourceLine) {
        this.sourceLines[index] = sourceLine;
    }

    public boolean[] getBreaks() {
        return this.breaks;
    }

    public boolean breakAtAddress(int addr) {
        return this.haltAtBreaks && this.breaks[addr];
    }

    public void setBreak(int i, boolean value) {
        this.breaks[i] = value;
        this.getChangeSupport().firePropertyChange("breaks", null, new Point(i, 1));
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int newSize) {
        int i;
        int oldCellSize = this.cellSize;
        this.cellSize = newSize;
        this.cellMask = 0L;
        for (i = 0; i < this.cellSize; ++i) {
            this.cellMask = (this.cellMask << 1) + 1L;
        }
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] & this.cellMask;
        }
    }

    public int getLength() {
        return this.data.length;
    }

    public void setLength(int newLength) {
        if (newLength == this.data.length) {
            return;
        }
        int oldLength = this.data.length;
        long[] oldData = this.data;
        long[] newData = new long[newLength];
        boolean[] newBreaks = new boolean[newLength];
        String[] newComments = new String[newLength];
        SourceLine[] newSourceLines = new SourceLine[newLength];
        if (newLength < this.data.length) {
            for (int i = 0; i < newLength; ++i) {
                newData[i] = this.data[i];
                newBreaks[i] = this.breaks[i];
                newComments[i] = this.comments[i];
                newSourceLines[i] = this.sourceLines[i];
            }
        } else {
            int i;
            for (i = 0; i < this.data.length; ++i) {
                newData[i] = this.data[i];
                newBreaks[i] = this.breaks[i];
                newComments[i] = this.comments[i];
                newSourceLines[i] = this.sourceLines[i];
            }
            for (i = this.data.length; i < newLength; ++i) {
                newData[i] = 0L;
                newBreaks[i] = false;
                newComments[i] = "";
                newSourceLines[i] = null;
            }
        }
        this.data = newData;
        this.breaks = newBreaks;
        this.comments = newComments;
        this.sourceLines = newSourceLines;
        this.getChangeSupport().firePropertyChange("length", new Integer(oldLength), new Integer(newLength));
        this.getChangeSupport().firePropertyChange("data", oldData, new Point(0, newLength));
    }

    public void loadAssembledInstructions(List<AssembledInstructionCall> instrs, int address) {
        int totalNumBits = 0;
        int nextAddr = address;
        int cellIndex = 0;
        long cellValue = 0L;
        for (AssembledInstructionCall nextInstr : instrs) {
            long value;
            int instrIndex = 0;
            int instrLength = nextInstr.length();
            long instrValue = nextInstr.getValue();
            instrValue = instrValue << 64 - instrLength >>> 64 - instrLength;
            if (((totalNumBits += instrLength) + this.cellSize - 1) / this.cellSize + address > this.getLength()) {
                throw new LoadException("There is not enough room in RAM " + this.getName() + " to load the instructions " + "starting at address " + address, this, instrs);
            }
            String c = this.getComments()[nextAddr];
            this.setComments(nextAddr, (c.length() == 0 ? "" : c + " | ") + nextInstr.getComment().trim());
            if (this.getSourceLine(nextAddr) == null) {
                this.setSourceLine(nextAddr, nextInstr.getSourceLine());
            }
            while (instrLength - instrIndex >= this.cellSize - cellIndex) {
                value = instrValue << instrIndex;
                this.setData(nextAddr, cellValue |= (value >>>= instrLength - (this.cellSize - cellIndex)) & this.cellMask);
                instrIndex += this.cellSize - cellIndex;
                ++nextAddr;
                cellIndex = 0;
                cellValue = 0L;
            }
            if (instrLength - instrIndex <= 0) continue;
            value = instrValue << 64 - (instrLength - instrIndex);
            value >>>= 64 - (instrLength - instrIndex);
            cellValue |= (value <<= this.cellSize - cellIndex - (instrLength - instrIndex)) & this.cellMask;
            cellIndex += instrLength - instrIndex;
        }
    }

    public void loadFile(BufferedReader reader, String pathName, int fileFormat) throws IOException, NumberFormatException {
        if (fileFormat == 0) {
            this.loadBinaryTextFile(reader, pathName);
        } else if (fileFormat == 1) {
            this.loadHexTextFile(reader, pathName);
        } else {
            this.loadIntelHexFile(reader, pathName);
        }
    }

    private void loadIntelHexFile(BufferedReader reader, String pathName) throws IOException, NumberFormatException {
        String nextLine = reader.readLine();
        int lineNumber = 1;
        RAM tempRAM = (RAM)this.clone();
        while (nextLine != null) {
            if (nextLine.charAt(0) != ':') {
                throw new IOException("Line " + lineNumber + " does " + " not start with a colon ':' as it should.");
            }
            if (nextLine.length() % 2 != 1) {
                throw new IOException("Line " + lineNumber + " must have an odd number of chars.");
            }
            if (nextLine.length() < 11) {
                throw new IOException("Line " + lineNumber + " is too short for Intel Hex format.");
            }
            int byteCount = Integer.parseInt(nextLine.substring(1, 3), 16);
            if (nextLine.length() != 11 + 2 * byteCount) {
                throw new IOException("Line " + lineNumber + " has an incorrect length for Intel Hex format.");
            }
            int address = Integer.parseInt(nextLine.substring(3, 7), 16);
            int recordType = Integer.parseInt(nextLine.substring(7, 9), 16);
            if (recordType != 0 && recordType != 1) {
                throw new IOException("Line " + lineNumber + " has a record type other than data record (00)" + " or end of file record (01).");
            }
            BigInteger line = new BigInteger(nextLine.substring(1), 16);
            byte[] byteArray = line.toByteArray();
            int sum = 0;
            for (byte b : byteArray) {
                sum += b;
            }
            if ((sum & 0xFF) != 0) {
                throw new IOException("Line " + lineNumber + " has an incorrect checksum value.");
            }
            if (recordType == 1) {
                if (!nextLine.equals(":00000001FF")) {
                    throw new IOException("Line " + lineNumber + " is not a proper end of file record, which" + " must be \":00000001FF\".");
                }
                for (int i = 0; i < this.getLength(); ++i) {
                    this.setData(i, tempRAM.data[i]);
                    this.setSourceLine(i, tempRAM.sourceLines[i]);
                    this.setComments(i, tempRAM.comments[i]);
                }
                return;
            }
            int lastInstrSize = 8;
            if (address + (byteCount * 8 + this.cellSize - 1) / this.cellSize > this.getLength()) {
                lastInstrSize = byteCount * 8 % this.cellSize;
            }
            int extraBytes = byteArray.length > byteCount + 5 ? 1 : 0;
            ArrayList<AssembledInstructionCall> instrs = new ArrayList<AssembledInstructionCall>();
            for (int i = extraBytes + 4; i < byteArray.length - 2; ++i) {
                instrs.add(new AssembledInstructionCall(8, byteArray[i], "", new SourceLine(lineNumber, pathName)));
            }
            instrs.add(new AssembledInstructionCall(lastInstrSize, byteArray[byteArray.length - 2] >> 8 - lastInstrSize, "", new SourceLine(lineNumber, pathName)));
            tempRAM.loadAssembledInstructions(instrs, address);
            ++lineNumber;
            nextLine = reader.readLine();
        }
        throw new IOException("The file is missing an end-of-line record.");
    }

    private void loadHexTextFile(BufferedReader reader, String pathName) throws IOException {
        String nextLine = reader.readLine();
        int lineNumber = 1;
        int address = 0;
        while (nextLine != null) {
            int j;
            int indexOfSpace = nextLine.indexOf(32);
            if (indexOfSpace == -1) {
                throw new NumberFormatException("Line " + lineNumber + " is" + " missing a space after the hex digits.");
            }
            String dataString = nextLine.substring(0, indexOfSpace);
            if (dataString.length() > 16) {
                throw new IOException("Line " + lineNumber + " has " + dataString.length() + " bits.  It is allowed only 64.");
            }
            int numHexDigits = dataString.length();
            int numBits = numHexDigits * 4;
            int numCellsInRow = numBits / this.cellSize;
            long data = Convert.fromHexadecimalStringToLong(dataString, numBits);
            data = data << 64 - numCellsInRow * this.cellSize >> 64 - numCellsInRow * this.cellSize;
            if (address + numCellsInRow > this.getLength()) {
                throw new IOException("There is not enough room in " + this + " to load the data from " + " line " + lineNumber + ".");
            }
            this.setData(address, data, numCellsInRow * this.cellSize);
            this.setComments(address, nextLine.substring(numHexDigits + 1));
            for (j = address + 1; j < address + numCellsInRow; ++j) {
                this.setComments(j, "");
            }
            for (j = address; j < address + numCellsInRow; ++j) {
                this.setSourceLine(j, new SourceLine(lineNumber, pathName));
            }
            ++lineNumber;
            address += numCellsInRow;
            nextLine = reader.readLine();
        }
    }

    public void loadBinaryTextFile(BufferedReader reader, String pathName) throws IOException {
        String nextLine = reader.readLine();
        int lineNumber = 1;
        int address = 0;
        while (nextLine != null) {
            int j;
            int indexOfSpace = nextLine.indexOf(32);
            if (indexOfSpace == -1) {
                throw new NumberFormatException("Line " + lineNumber + " is" + " missing a space after the 0's and 1's.");
            }
            String dataString = nextLine.substring(0, indexOfSpace);
            if (dataString.length() % this.cellSize != 0) {
                throw new IOException("The number of bits in each line must be a multiple of the RAM's cell size (" + this.cellSize + ").\nLine " + lineNumber + " has " + dataString.length() + " bits.");
            }
            if (dataString.length() > 64) {
                throw new IOException("Line " + lineNumber + " has " + dataString.length() + " bits.  It is allowed only 64.");
            }
            int numCellsInRow = dataString.length() / this.cellSize;
            if (address + numCellsInRow > this.getLength()) {
                throw new IOException("There is not enough room in " + this + " to load the data from " + " line " + lineNumber + ".");
            }
            long data = Convert.fromBinaryStringToLong(dataString, numCellsInRow * this.cellSize);
            this.setData(address, data, numCellsInRow * this.cellSize);
            this.setComments(address, nextLine.substring(numCellsInRow * this.cellSize + 1));
            for (j = address + 1; j < address + numCellsInRow; ++j) {
                this.setComments(j, "");
            }
            for (j = address; j < address + numCellsInRow; ++j) {
                this.setSourceLine(j, new SourceLine(lineNumber, pathName));
            }
            ++lineNumber;
            address += numCellsInRow;
            nextLine = reader.readLine();
        }
    }

    @Override
    public Object clone() {
        return new RAM(this.getName(), this.data.length, this.cellSize);
    }

    @Override
    public void copyDataTo(Module comp) {
        Assert.That(comp instanceof RAM, "Passed non-RAM to RAM.copyDataTo()");
        RAM newRAM = (RAM)comp;
        newRAM.setName(this.getName());
        newRAM.setLength(this.getLength());
        newRAM.setCellSize(this.getCellSize());
    }

    @Override
    public String getXMLDescription() {
        return "<RAM name=\"" + this.getHTMLName() + "\" length=\"" + this.getLength() + "\" cellSize=\"" + this.getCellSize() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getLength() + "</TD><TD>" + this.getCellSize() + "</TD></TR>";
    }

    public void clear() {
        for (int i = 0; i < this.getLength(); ++i) {
            this.setData(i, 0L);
            this.setComments(i, "");
            this.setBreak(i, false);
            this.setSourceLine(i, null);
        }
    }

    public void haltAtBreaks(boolean b) {
        this.haltAtBreaks = b;
    }
}

