/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Machine;
import cpusim.Module;
import cpusim.module.ConditionBitFactory;
import cpusim.module.ModuleFactory;
import cpusim.module.Register;
import cpusim.util.PositiveIntTableCellEditor;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class RegisterFactory
extends ModuleFactory {
    private Vector currentModules;
    private Register prototype;
    private ConditionBitFactory bitFactory;

    public RegisterFactory(Machine machine) {
        super(machine);
        this.currentModules = machine.getModule("registers");
        this.prototype = new Register("???", 16);
        this.clones = (Module[])this.createClones();
    }

    public void setBitFactory(ConditionBitFactory bitFactory) {
        this.bitFactory = bitFactory;
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, PositiveIntTableCellEditor> editors = new HashMap<String, PositiveIntTableCellEditor>();
        editors.put("width", new PositiveIntTableCellEditor());
        return editors;
    }

    @Override
    Module getPrototype() {
        return this.prototype;
    }

    @Override
    Class getModuleClass() {
        return Register.class;
    }

    @Override
    public Vector getCurrentModules() {
        return this.currentModules;
    }

    @Override
    public String toString() {
        return "Register";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "width"};
    }

    @Override
    public void setClones(Object[] newClones) {
        Register[] registers = new Register[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            registers[i] = (Register)newClones[i];
        }
        this.clones = registers;
    }

    @Override
    public boolean checkValidity(Object[] modules) {
        Module[] registers = new Register[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            registers[i] = (Register)modules[i];
        }
        HashMap<Register, Integer> table = new HashMap<Register, Integer>();
        for (int i = 0; i < registers.length; ++i) {
            Register oldRegister = (Register)this.getCurrentFromClone(registers[i]);
            if (oldRegister == null || oldRegister.getWidth() == ((Register)registers[i]).getWidth()) continue;
            table.put(oldRegister, new Integer(((Register)registers[i]).getWidth()));
        }
        return this.allNamesAreUnique(registers) && !this.someNamesAreEmpty(registers) && this.widthsAreInBound((Register[])registers) && this.bitFactory.registerWidthsAreOkay((Register[])registers) && this.registerWidthsAreOkayForMicros(table);
    }

    public boolean widthsAreInBound(Register[] registers) {
        for (int i = 0; i < registers.length; ++i) {
            Register nextRegister = registers[i];
            int width = nextRegister.getWidth();
            if (width <= 0) {
                this.displayError("You must specify a positive value for the bitwise width\nof the Register " + nextRegister.getName() + ".");
                return false;
            }
            if (width <= 64) continue;
            this.displayError("Register " + nextRegister.getName() + " can have a width of at most 64 bits.");
            return false;
        }
        return true;
    }

    @Override
    public boolean newModulesAreAllowed() {
        return true;
    }

    public Register getCloneOf(Register original) {
        Set e = this.assocList.keySet();
        for (Register clone : e) {
            if (this.assocList.get(clone) != original) continue;
            return clone;
        }
        return null;
    }

    @Override
    public String getHelpPageID() {
        return "Register";
    }
}

