/*
 * Decompiled with CFR 0.152.
 */
package cpusim.scrollabledesktop;

import cpusim.gui.AssemblerWindow;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.scrollabledesktop.DesktopConstants;
import cpusim.scrollabledesktop.DesktopListener;
import cpusim.scrollabledesktop.DesktopMenu;
import cpusim.scrollabledesktop.DesktopScrollPane;
import cpusim.scrollabledesktop.JScrollableDesktopPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class DesktopMediator
implements DesktopConstants {
    private DesktopScrollPane desktopScrollpane = new DesktopScrollPane(this);
    private DesktopListener dListener = new DesktopListener(this);
    private DesktopMenu dMenu;

    public DesktopMediator(JScrollableDesktopPane mainPane) {
        mainPane.add((Component)this.desktopScrollpane, "Center");
        mainPane.addComponentListener(this.dListener);
    }

    public DesktopMenu getMenu() {
        return this.dMenu;
    }

    public void registerMenuBar(JMenuBar mb) {
        this.dMenu = new DesktopMenu(this);
        JMenu help = mb.getMenu(mb.getMenuCount() - 1);
        mb.remove(help);
        mb.add(this.dMenu);
        mb.add(help);
    }

    public void deregisterMenuBar(JMenuBar mb) {
        mb.remove(this.dMenu);
        mb.repaint();
    }

    public JInternalFrame add(String title, ImageIcon icon, JPanel frameContents, boolean isClosable, int x, int y) {
        BaseInternalFrame frame = null;
        if (this.desktopScrollpane.getNumberOfFrames() < 20) {
            frame = this.desktopScrollpane.add(this.dListener, title, icon, frameContents, isClosable, x, y);
            this.createFrameAssociates(frame);
        }
        return frame;
    }

    public void add(JInternalFrame frame, int x, int y) {
        if (this.desktopScrollpane.getNumberOfFrames() < 20) {
            this.desktopScrollpane.add(this.dListener, frame, x, y);
            if (frame instanceof BaseInternalFrame) {
                this.createFrameAssociates((BaseInternalFrame)frame);
            }
        }
    }

    private void createFrameAssociates(BaseInternalFrame frame) {
        if (this.dMenu != null && frame instanceof AssemblerWindow) {
            this.dMenu.add(frame);
        }
        if (this.desktopScrollpane.getAutoTile()) {
            this.desktopScrollpane.tileInternalFrames();
        }
    }

    public void removeAssociatedComponents(BaseInternalFrame f) {
        if (this.dMenu != null && f instanceof AssemblerWindow) {
            this.dMenu.remove(f.getAssociatedMenuButton());
        }
        this.desktopScrollpane.selectNextFrame();
    }

    public JInternalFrame[] getAllFrames() {
        return this.desktopScrollpane.getAllFrames();
    }

    public JInternalFrame getSelectedFrame() {
        return this.desktopScrollpane.getSelectedFrame();
    }

    public void setSelectedFrame(JInternalFrame f) {
        this.desktopScrollpane.setSelectedFrame(f);
    }

    public void flagContentsChanged(JInternalFrame f) {
        this.desktopScrollpane.flagContentsChanged(f);
    }

    public void resizeDesktop() {
        this.desktopScrollpane.resizeDesktop();
    }

    public void revalidateViewport() {
        this.desktopScrollpane.revalidate();
    }

    public void centerView(BaseInternalFrame f) {
        this.desktopScrollpane.centerView(f);
    }

    public void closeSelectedFrame() {
        this.desktopScrollpane.closeSelectedFrame();
    }

    public void tileInternalFrames() {
        this.desktopScrollpane.tileInternalFrames();
    }

    public void cascadeInternalFrames() {
        this.desktopScrollpane.cascadeInternalFrames();
    }

    public void setAutoTile(boolean tileMode) {
        this.desktopScrollpane.setAutoTile(tileMode);
    }

    public void actionPerformed(ActionEvent e) {
        this.dListener.actionPerformed(e);
    }
}

