/*
 * Decompiled with CFR 0.152.
 */
package cpusim.scrollabledesktop;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ResizableToolBar
extends JToolBar
implements ComponentListener {
    private ButtonGroup buttonGroup;
    private int minButtonWidth;
    private int maxButtonWidth;

    public ResizableToolBar(int minButtonWidth, int maxButtonWidth) {
        this.setRollover(true);
        this.buttonGroup = new ButtonGroup();
        this.minButtonWidth = minButtonWidth;
        this.maxButtonWidth = maxButtonWidth;
        this.addComponentListener(this);
    }

    public void add(AbstractButton button) {
        this.buttonGroup.add(button);
        super.add(button);
        this.resizeButtons();
    }

    public void remove(AbstractButton button) {
        super.remove(button);
        this.buttonGroup.remove(button);
        this.resizeButtons();
        this.repaint();
    }

    public Enumeration getElements() {
        return this.buttonGroup.getElements();
    }

    public int getButtonCount() {
        return this.buttonGroup.getButtonCount();
    }

    private void resizeButtons() {
        final float exactButtonWidth = this.getCurrentButtonWidth();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractButton b = null;
                Enumeration e = ResizableToolBar.this.getElements();
                float currentButtonXLocation = 0.0f;
                while (e.hasMoreElements()) {
                    b = (AbstractButton)e.nextElement();
                    int buttonWidth = Math.round(currentButtonXLocation + exactButtonWidth) - Math.round(currentButtonXLocation);
                    currentButtonXLocation += exactButtonWidth;
                }
                ResizableToolBar.this.revalidate();
            }
        });
    }

    private float getCurrentButtonWidth() {
        int width = this.getWidth() - this.getInsets().left - this.getInsets().right;
        float buttonWidth = width <= 0 ? this.maxButtonWidth : width;
        int numButtons = this.getButtonCount();
        if (numButtons > 0) {
            buttonWidth /= (float)numButtons;
        }
        if (buttonWidth < (float)this.minButtonWidth) {
            buttonWidth = this.minButtonWidth;
        } else if (buttonWidth > (float)this.maxButtonWidth) {
            buttonWidth = this.maxButtonWidth;
        }
        return buttonWidth;
    }

    private void assignWidth(AbstractButton b, int buttonWidth) {
        b.setMinimumSize(new Dimension(buttonWidth - 2, b.getPreferredSize().height));
        b.setPreferredSize(new Dimension(buttonWidth, b.getPreferredSize().height));
        Dimension newSize = b.getPreferredSize();
        b.setMaximumSize(newSize);
        b.setSize(newSize);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.resizeButtons();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

