/*
 * Decompiled with CFR 0.152.
 */
package cpusim.syntax;

import cpusim.syntax.CPUSimTokenMarker;
import cpusim.syntax.DefaultInputHandler;
import cpusim.syntax.InputHandler;
import cpusim.syntax.SyntaxDocument;
import cpusim.syntax.SyntaxStyle;
import cpusim.syntax.SyntaxUtilities;
import java.awt.Color;
import javax.swing.JPopupMenu;

public class TextAreaDefaults {
    private static TextAreaDefaults DEFAULTS;
    public InputHandler inputHandler;
    public SyntaxDocument document;
    public boolean editable;
    public boolean caretVisible;
    public boolean caretBlinks;
    public boolean blockCaret;
    public int electricScroll;
    public int cols;
    public int rows;
    public SyntaxStyle[] styles;
    public Color caretColor;
    public Color selectionColor;
    public Color lineHighlightColor;
    public boolean lineHighlight;
    public Color bracketHighlightColor;
    public boolean bracketHighlight;
    public Color eolMarkerColor;
    public boolean eolMarkers;
    public boolean paintInvalid;
    public JPopupMenu popup;

    public static TextAreaDefaults getStyle(int styleIndex) {
        DEFAULTS = new TextAreaDefaults();
        TextAreaDefaults.DEFAULTS.inputHandler = new DefaultInputHandler();
        TextAreaDefaults.DEFAULTS.inputHandler.addDefaultKeyBindings();
        TextAreaDefaults.DEFAULTS.document = new SyntaxDocument();
        TextAreaDefaults.DEFAULTS.document.setTokenMarker(new CPUSimTokenMarker());
        TextAreaDefaults.DEFAULTS.editable = true;
        TextAreaDefaults.DEFAULTS.caretVisible = true;
        TextAreaDefaults.DEFAULTS.caretBlinks = true;
        TextAreaDefaults.DEFAULTS.electricScroll = 1;
        TextAreaDefaults.DEFAULTS.cols = 80;
        TextAreaDefaults.DEFAULTS.rows = 5;
        TextAreaDefaults.DEFAULTS.styles = SyntaxUtilities.getSyntaxStyles(styleIndex);
        TextAreaDefaults.DEFAULTS.caretColor = Color.blue;
        TextAreaDefaults.DEFAULTS.selectionColor = new Color(0xCCCCFF);
        TextAreaDefaults.DEFAULTS.lineHighlightColor = new Color(13625855);
        TextAreaDefaults.DEFAULTS.lineHighlight = true;
        TextAreaDefaults.DEFAULTS.bracketHighlightColor = Color.black;
        TextAreaDefaults.DEFAULTS.bracketHighlight = true;
        TextAreaDefaults.DEFAULTS.eolMarkerColor = new Color(39321);
        TextAreaDefaults.DEFAULTS.eolMarkers = false;
        TextAreaDefaults.DEFAULTS.paintInvalid = false;
        return DEFAULTS;
    }
}

