/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.util.Assert;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class OOTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final boolean DEBUG = false;
    Object[] objects;
    PropertyDescriptor[] properties;
    Object[] emptyArgumentList = new Object[0];

    public OOTableModel(Object[] objects) throws IntrospectionException {
        this.objects = objects;
        this.properties = this.analyzeTheObjects(objects);
    }

    public OOTableModel(Vector v) throws IntrospectionException {
        this(OOTableModel.vector2Array(v));
    }

    public OOTableModel(Object[] objects, boolean readWriteOnly) throws IntrospectionException {
        this(objects);
        if (readWriteOnly) {
            int numReadWrite = 0;
            for (int i = 0; i < this.properties.length; ++i) {
                if (this.properties[i].getWriteMethod() == null || this.properties[i].getReadMethod() == null) continue;
                ++numReadWrite;
            }
            PropertyDescriptor[] rwProperties = new PropertyDescriptor[numReadWrite];
            int next = 0;
            for (int i = 0; i < this.properties.length; ++i) {
                if (this.properties[i].getWriteMethod() == null || this.properties[i].getReadMethod() == null) continue;
                rwProperties[next++] = this.properties[i];
            }
            this.properties = rwProperties;
        }
    }

    public OOTableModel(Vector v, boolean readWriteOnly) throws IntrospectionException {
        this(OOTableModel.vector2Array(v), readWriteOnly);
    }

    public void setColumns(String[] columns) {
        PropertyDescriptor[] newProperties = new PropertyDescriptor[columns.length];
        for (int i = 0; i < newProperties.length; ++i) {
            int j = this.findProperty(columns[i]);
            Assert.That(j != -1, "A property was missing when executing OOTableModel.setColumns().");
            newProperties[i] = this.properties[j];
        }
        this.properties = newProperties;
        this.fireTableStructureChanged();
    }

    private static Object[] vector2Array(Vector v) {
        Object[] micros = new Object[v.size()];
        for (int i = 0; i < micros.length; ++i) {
            micros[i] = v.elementAt(i);
        }
        return micros;
    }

    public void setReadOnly(String[] propertyNames) {
        for (int i = 0; i < propertyNames.length; ++i) {
            int index = this.findProperty(propertyNames[i]);
            Assert.That(index != -1, "OOTableModel.setReadOnly() called with a non-existent property.");
            try {
                this.properties[index].setWriteMethod(null);
                continue;
            }
            catch (IntrospectionException e) {
                Assert.That(false, "IntrospectionException thrown by OOTableModel.setReadOnly()");
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.objects.length;
    }

    @Override
    public int getColumnCount() {
        return this.properties.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.properties[columnIndex].getDisplayName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.properties[columnIndex].getWriteMethod() != null;
    }

    public Class getColumnClass(int columnIndex) {
        Class<?> c = this.properties[columnIndex].getReadMethod().getReturnType();
        return this.wrapPrimitives(c);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        block8: {
            try {
                if (!this.isCellEditable(rowIndex, columnIndex)) break block8;
                Object object = this.objects[rowIndex];
                Method method = this.properties[columnIndex].getWriteMethod();
                Class paramType = this.getColumnClass(columnIndex);
                Object fixedValue = null;
                try {
                    fixedValue = this.fixNumbers(aValue, paramType);
                }
                catch (NumberFormatException e) {
                    return;
                }
                try {
                    fixedValue = this.fixIntArrays(fixedValue, paramType);
                }
                catch (NumberFormatException e) {
                    return;
                }
                Object[] param = new Object[]{fixedValue};
                method.invoke(object, param);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
            }
            catch (IllegalAccessException e) {
                Assert.That(false, "There was an error in OOTableModel.setValueAt() with an IllegalAccessException thrown.");
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (row > this.objects.length || column > this.properties.length) {
                return null;
            }
            Object object = this.objects[row];
            Method method = this.properties[column].getReadMethod();
            Object value = method.invoke(object, this.emptyArgumentList);
            if (value != null && value.getClass().isAssignableFrom(int[].class)) {
                int[] valueArray = (int[])value;
                String stringvalue = "";
                for (int i = 0; i < valueArray.length; ++i) {
                    stringvalue = stringvalue + " " + (valueArray[i] < 0 ? "(" + Math.abs(valueArray[i]) + ")" : "" + valueArray[i]);
                }
                value = stringvalue;
            }
            return value;
        }
        catch (Exception e) {
            Assert.That(false, "There was an error in OOTableModel.getValueAt() with an Exception thrown.");
            e.printStackTrace();
            return null;
        }
    }

    private PropertyDescriptor[] analyzeTheObjects(Object[] objects) throws IntrospectionException {
        Class<?> objectClass = objects.getClass().getComponentType();
        BeanInfo info = objectClass.isInterface() ? Introspector.getBeanInfo(objectClass) : Introspector.getBeanInfo(objectClass, Object.class);
        this.checkForChangeSupport(objects);
        return info.getPropertyDescriptors();
    }

    private Class wrapPrimitives(Class c) {
        Class result = c;
        if (c.isPrimitive()) {
            if (c.isAssignableFrom(Boolean.TYPE)) {
                result = Boolean.class;
            } else if (c.isAssignableFrom(Character.TYPE)) {
                result = Character.class;
            } else if (c.isAssignableFrom(Byte.TYPE)) {
                result = Byte.class;
            } else if (c.isAssignableFrom(Short.TYPE)) {
                result = Short.class;
            } else if (c.isAssignableFrom(Integer.TYPE)) {
                result = Integer.class;
            } else if (c.isAssignableFrom(Long.TYPE)) {
                result = Long.class;
            } else if (c.isAssignableFrom(Float.TYPE)) {
                result = Float.class;
            } else if (c.isAssignableFrom(Double.TYPE)) {
                result = Double.class;
            }
        }
        return result;
    }

    private Object fixIntArrays(Object anObject, Class aClass) throws NumberFormatException {
        if (anObject instanceof String && int[].class.isAssignableFrom(aClass)) {
            String string = (String)anObject;
            StringTokenizer tokenizer = new StringTokenizer(string, " ,");
            Vector<Integer> intVector = new Vector<Integer>();
            while (tokenizer.hasMoreTokens()) {
                String nextString = tokenizer.nextToken();
                if (nextString.charAt(0) == '(' && nextString.charAt(nextString.length() - 1) == ')') {
                    intVector.addElement(new Integer("-" + nextString.substring(1, nextString.length() - 1)));
                    continue;
                }
                intVector.addElement(new Integer(nextString));
            }
            int[] intArray = new int[intVector.size()];
            for (int i = 0; i < intArray.length; ++i) {
                intArray[i] = (Integer)intVector.elementAt(i);
            }
            return intArray;
        }
        return anObject;
    }

    private Object fixNumbers(Object anObject, Class aClass) throws NumberFormatException {
        if (anObject instanceof String && Number.class.isAssignableFrom(aClass)) {
            String string = (String)anObject;
            if (Integer.class.isAssignableFrom(aClass)) {
                return Integer.valueOf(string);
            }
            if (Double.class.isAssignableFrom(aClass)) {
                return Double.valueOf(string);
            }
            if (Float.class.isAssignableFrom(aClass)) {
                return Float.valueOf(string);
            }
            if (Long.class.isAssignableFrom(aClass)) {
                return Long.valueOf(string);
            }
            if (Short.class.isAssignableFrom(aClass)) {
                return Short.valueOf(string);
            }
            if (Byte.class.isAssignableFrom(aClass)) {
                return Byte.valueOf(string);
            }
        }
        return anObject;
    }

    private void checkForChangeSupport(Object[] objects) {
        Class[] param = new Class[]{PropertyChangeListener.class};
        Object[] args = new Object[]{this};
        for (int i = 0; i < objects.length; ++i) {
            try {
                Class<?> aClass = objects[i].getClass();
                Method method = aClass.getMethod("addPropertyChangeListener", param);
                method.invoke(objects[i], args);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        int row = this.findObject(event.getSource());
        if (row == -1) {
            return;
        }
        int column = this.findProperty(event.getPropertyName());
        if (column != -1) {
            this.fireTableCellUpdated(row, column);
        } else {
            this.fireTableRowsUpdated(row, row);
        }
        OOTableModel.debug("Handled change to object in row #" + row + ", col #" + column);
    }

    private int findProperty(String name) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private int findObject(Object o) {
        for (int i = 0; i < this.objects.length; ++i) {
            if (this.objects[i] != o) continue;
            return i;
        }
        return -1;
    }

    public Object getObject(int row) throws IndexOutOfBoundsException {
        return this.objects[row];
    }

    public void insertObject(Object newObject, int row) throws IndexOutOfBoundsException {
        Object[] newObjects = new Object[this.objects.length + 1];
        int j = 0;
        for (int i = 0; i < newObjects.length; ++i) {
            if (i != row) {
                newObjects[i] = this.objects[j];
                ++j;
                continue;
            }
            newObjects[i] = newObject;
        }
        this.objects = newObjects;
        this.fireTableRowsInserted(row, row);
    }

    public void setObjects(Object[] newObjects, String[] propertyNames) throws IntrospectionException {
        this.objects = newObjects;
        this.properties = this.analyzeTheObjects(this.objects);
        this.setColumns(propertyNames);
    }

    public void updateObjects(Object[] newObjects) {
        this.objects = newObjects;
        this.fireTableDataChanged();
    }

    public void deleteObject(int row) throws IndexOutOfBoundsException {
        Object[] newObjects = new Object[this.objects.length - 1];
        int j = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            if (i == row) continue;
            newObjects[j] = this.objects[i];
            ++j;
        }
        this.objects = newObjects;
        this.fireTableRowsDeleted(row, row);
    }

    public void deleteObjects(int[] rows) throws IndexOutOfBoundsException {
        Object[] newObjects = new Object[this.objects.length - rows.length];
        int j = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            if (this.found(i, rows)) continue;
            newObjects[j] = this.objects[i];
            ++j;
        }
        this.objects = newObjects;
        this.fireTableDataChanged();
    }

    private boolean found(int row, int[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] != row) continue;
            return true;
        }
        return false;
    }

    public Object[] getAllObjects() {
        return this.objects;
    }

    public Object[] getObjects(int[] rows) throws IndexOutOfBoundsException {
        Object[] array = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            array[i] = this.getObject(rows[i]);
        }
        return array;
    }

    private static void debug(String s) {
    }
}

