/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.gui.Desktop;
import cpusim.module.RAM;
import cpusim.module.Register;
import cpusim.util.Assert;
import cpusim.util.Factory;
import cpusim.util.RegisterRAMPair;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class RegisterRAMPairFactory
implements Factory {
    private Desktop desktop;
    private JDialog parentFrame;

    public RegisterRAMPairFactory(Desktop desktop) {
        this.desktop = desktop;
        this.parentFrame = null;
    }

    public void setParentFrame(JDialog parent) {
        this.parentFrame = parent;
    }

    @Override
    public String getHelpPageID() {
        return "executeMenu";
    }

    @Override
    public Object getNewObject(String name) {
        Register r = this.desktop.getMachine().getModule("registers").size() > 0 ? (Register)this.desktop.getMachine().getModule("registers").elementAt(0) : null;
        RAM ram = this.desktop.getMachine().getModule("rams").size() > 0 ? (RAM)this.desktop.getMachine().getModule("rams").elementAt(0) : null;
        return new RegisterRAMPair(r, ram, false);
    }

    @Override
    public boolean checkValidity(Object[] list) {
        RAM codeStore = this.desktop.getMachine().getCodeStore();
        boolean codeStoreFound = false;
        for (Object aList : list) {
            RegisterRAMPair pair = (RegisterRAMPair)aList;
            Assert.That(pair.getRegister() != null && pair.getRam() != null, "RegisterRAMPairFactory.checkValidity() found a RegisterRAMPair with null register and/or RAM");
            if (pair.getRam() == codeStore && !codeStoreFound) {
                codeStoreFound = true;
                continue;
            }
            if (pair.getRam() != codeStore || !codeStoreFound) continue;
            this.displayError("The code store \"" + pair.getRam().getName() + "\" is used more than once.\nTo ensure only one" + " line of source code is highlighted at a time,\n" + "the code store can appear in at most one pair.");
            return false;
        }
        return true;
    }

    @Override
    public Object[] createClones() {
        Vector<RegisterRAMPair> RegisterRAMPairs = this.desktop.getHighlightManager().getRegisterRAMPairs();
        Object[] clones = new RegisterRAMPair[RegisterRAMPairs.size()];
        for (int i = 0; i < clones.length; ++i) {
            clones[i] = (RegisterRAMPair)RegisterRAMPairs.elementAt(i).clone();
        }
        return clones;
    }

    @Override
    public void displayError(String message) {
        JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
    }
}

