/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.HexInputStream;
import acm.util.ImageSaver;
import acm.util.JTFTools;
import acm.util.NullAudioClip;
import acm.util.PSPreviewImage;
import acm.util.SoundClip;
import acm.util.SunAudioClip;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MediaTools {
    public static final String DEFAULT_IMAGE_PATH = ".:images";
    public static final String DEFAULT_AUDIO_PATH = ".:sounds";
    public static final String DEFAULT_DATAFILE_PATH = ".:datafiles";
    private static boolean cachingEnabled = false;
    private static HashMap<String, Image> imageTable = new HashMap();
    private static HashMap<String, AudioClip> audioClipTable = new HashMap();
    private static HashMap<String, ImageSaver> suffixTable = new HashMap();
    private static final Class<?> RESOURCE_CLASS = new MediaTools().getClass();

    private MediaTools() {
    }

    public static Image loadImage(String name) {
        return MediaTools.loadImage(name, DEFAULT_IMAGE_PATH);
    }

    public static Image loadImage(String name, String path) {
        Image image = imageTable.get(name);
        if (image != null) {
            return image;
        }
        if (name.startsWith("http:")) {
            try {
                image = MediaTools.loadImage(new URL(name));
                if (cachingEnabled) {
                    imageTable.put(name, image);
                }
                return image;
            }
            catch (MalformedURLException ex) {
                throw new ErrorException("loadImage: Malformed URL");
            }
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        StringTokenizer tokenizer = new StringTokenizer(path, ":");
        while (image == null && tokenizer.hasMoreTokens()) {
            URL codeBase;
            Applet applet;
            String prefix = tokenizer.nextToken();
            prefix = prefix.equals(".") ? "" : prefix + "/";
            URL url = null;
            try {
                url = RESOURCE_CLASS.getResource("/" + prefix + name);
                URLConnection connection = url.openConnection();
                if (connection == null || connection.getContentLength() <= 0) {
                    url = null;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (url == null && (applet = JTFTools.getApplet()) != null && (codeBase = applet.getCodeBase()) != null) {
                try {
                    url = new URL(codeBase, prefix + name);
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            if (url == null) {
                try {
                    if (!new File(prefix + name).canRead()) continue;
                    image = toolkit.getImage(prefix + name);
                }
                catch (SecurityException ex) {}
                continue;
            }
            image = MediaTools.loadImage(url, false);
        }
        if (image == null) {
            throw new ErrorException("Cannot find an image named " + name);
        }
        MediaTools.loadImage(image);
        if (cachingEnabled) {
            imageTable.put(name, image);
        }
        return image;
    }

    public static Image loadImage(URL url) {
        return MediaTools.loadImage(url, true);
    }

    public static Image loadImage(Image image) {
        MediaTracker tracker = new MediaTracker(JTFTools.createEmptyContainer());
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            throw new ErrorException("Image loading process interrupted");
        }
        return image;
    }

    public static void defineImage(String name, Image image) {
        imageTable.put(name, image);
    }

    public static void flushImage(String name) {
        imageTable.remove(name);
    }

    public static Image createImage(int[][] array) {
        int height = array.length;
        int width = array[0].length;
        int[] pixels = new int[width * height];
        for (int i = 0; i < height; ++i) {
            System.arraycopy(array[i], 0, pixels, i * width, width);
        }
        return MediaTools.createImage(pixels, width, height);
    }

    public static Image createImage(int[] pixels, int width, int height) {
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
        MediaTools.loadImage(image);
        return image;
    }

    public static Image createImage(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int ch = in.read();
            while (ch != -1) {
                out.write(ch);
                ch = in.read();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(out.toByteArray());
            MediaTools.loadImage(image);
            return image;
        }
        catch (Exception ex) {
            throw new ErrorException("Exception: " + ex);
        }
    }

    public static Image createImage(String[] hexData) {
        return MediaTools.createImage(new HexInputStream(hexData));
    }

    public static int[][] getPixelArray(Image image) {
        Component observer = MediaTools.getImageObserver();
        int width = image.getWidth(observer);
        int height = image.getHeight(observer);
        int[] pixels = new int[width * height];
        int[][] array = new int[height][width];
        PixelGrabber pg = new PixelGrabber(image.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new ErrorException("Transfer interrupted");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new ErrorException("Transfer aborted");
        }
        for (int i = 0; i < height; ++i) {
            System.arraycopy(pixels, i * width, array[i], 0, width);
        }
        return array;
    }

    public static void saveImage(Image image, String filename) {
        MediaTools.saveImage(image, new File(filename));
    }

    public static void saveImage(Image image, File file) {
        String filename = file.getName();
        int dot = filename.lastIndexOf(46);
        if (dot <= 0) {
            throw new ErrorException("saveImage: No image suffix in file name");
        }
        String suffix = filename.substring(dot + 1);
        ImageSaver saver = MediaTools.findImageSaver(suffix);
        if (saver == null) {
            throw new ErrorException("saveImage: No support for ." + suffix + " format");
        }
        if (file.exists() && !file.delete()) {
            throw new ErrorException("saveImage: Cannot replace " + filename);
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            saver.setOutputStream(out);
            saver.saveImage(image);
            saver.updateFileType(file);
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new ErrorException("saveImage: " + ex.getMessage());
        }
    }

    public static Image createPSPreviewImage(Image image, String[] preview) {
        return new PSPreviewImage(image, preview);
    }

    public static AudioClip loadAudioClip(String name) {
        return MediaTools.loadAudioClip(name, DEFAULT_AUDIO_PATH);
    }

    public static AudioClip loadAudioClip(String name, String path) {
        AudioClip clip = audioClipTable.get(name);
        if (clip != null) {
            return clip;
        }
        if (name.startsWith("http:")) {
            try {
                clip = MediaTools.loadAudioClip(new URL(name));
                if (clip instanceof SoundClip) {
                    ((SoundClip)clip).setName(name);
                }
                if (cachingEnabled) {
                    audioClipTable.put(name, clip);
                }
                return clip;
            }
            catch (MalformedURLException ex) {
                throw new ErrorException("loadAudioClip: Malformed URL");
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(path, ":");
        while (clip == null && tokenizer.hasMoreTokens()) {
            URL codeBase;
            Applet applet;
            String prefix = tokenizer.nextToken();
            prefix = prefix.equals(".") ? "" : prefix + "/";
            URL url = null;
            try {
                url = RESOURCE_CLASS.getResource("/" + prefix + name);
                URLConnection connection = url.openConnection();
                if (connection == null || connection.getContentLength() <= 0) {
                    url = null;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (url == null && (applet = JTFTools.getApplet()) != null && (codeBase = applet.getCodeBase()) != null) {
                try {
                    url = new URL(codeBase, prefix + name);
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            if (url == null) {
                try {
                    File file = new File(prefix + name);
                    if (!file.canRead()) continue;
                    clip = MediaTools.createAudioClip(new FileInputStream(file));
                }
                catch (Exception ex) {}
                continue;
            }
            clip = MediaTools.loadAudioClip(url, false);
        }
        if (clip == null) {
            throw new ErrorException("Cannot find an audio clip named " + name);
        }
        if (clip instanceof SoundClip) {
            ((SoundClip)clip).setName(name);
        }
        if (cachingEnabled) {
            audioClipTable.put(name, clip);
        }
        return clip;
    }

    public static AudioClip loadAudioClip(URL url) {
        return MediaTools.loadAudioClip(url, true);
    }

    public static void defineAudioClip(String name, AudioClip clip) {
        audioClipTable.put(name, clip);
    }

    public static void flushAudioClip(String name) {
        audioClipTable.remove(name);
    }

    public static AudioClip createAudioClip(InputStream in) {
        try {
            return new SoundClip(in);
        }
        catch (Exception ex1) {
            try {
                return new SunAudioClip(in);
            }
            catch (Exception ex2) {
                return new NullAudioClip();
            }
        }
    }

    public static AudioClip createAudioClip(String[] hexData) {
        return MediaTools.createAudioClip(new HexInputStream(hexData));
    }

    public static InputStream openDataFile(String name) {
        return MediaTools.openDataFile(name, DEFAULT_DATAFILE_PATH);
    }

    public static InputStream openDataFile(String name, String path) {
        InputStream in = null;
        if (name.startsWith("http:")) {
            try {
                return MediaTools.openDataFile(new URL(name));
            }
            catch (MalformedURLException ex) {
                throw new ErrorException("openDataFile: Malformed URL");
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(path, ":");
        while (in == null && tokenizer.hasMoreTokens()) {
            URL codeBase;
            Applet applet;
            String prefix = tokenizer.nextToken();
            prefix = prefix.equals(".") ? "" : prefix + "/";
            URL url = null;
            try {
                url = RESOURCE_CLASS.getResource("/" + prefix + name);
                URLConnection connection = url.openConnection();
                if (connection == null || connection.getContentLength() <= 0) {
                    url = null;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (url == null && (applet = JTFTools.getApplet()) != null && (codeBase = applet.getCodeBase()) != null) {
                try {
                    url = new URL(codeBase, prefix + name);
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            if (url == null) {
                try {
                    File file = new File(prefix + name);
                    if (!file.canRead()) continue;
                    in = new FileInputStream(file);
                }
                catch (Exception ex) {}
                continue;
            }
            in = MediaTools.openDataFile(url, false);
        }
        if (in == null) {
            throw new ErrorException("Cannot find a file named " + name);
        }
        return in;
    }

    public static InputStream openDataFile(URL url) {
        return MediaTools.openDataFile(url, true);
    }

    public static BufferedImage createBufferedImage(Image image, int type) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bimage = new BufferedImage(width, height, type);
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static InputStream getHexInputStream(String[] hexData) {
        return new HexInputStream(hexData);
    }

    public static void setCachingEnabled(boolean flag) {
        cachingEnabled = flag;
    }

    public static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    public static Component getImageObserver() {
        return JTFTools.createEmptyContainer();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static Image loadImage(URL url, boolean topLevel) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URLConnection connection = url.openConnection();
            if (MediaTools.isResource(url) || connection.getContentLength() > 0) {
                Object content = connection.getContent();
                if (content instanceof ImageProducer) {
                    image = toolkit.createImage((ImageProducer)content);
                } else if (content != null) {
                    image = toolkit.getImage(url);
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (topLevel) {
            if (image == null) {
                throw new ErrorException("Cannot load image from " + url);
            }
            MediaTools.loadImage(image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageSaver findImageSaver(String suffix) {
        suffix = suffix.toUpperCase();
        HashMap<String, ImageSaver> hashMap = suffixTable;
        synchronized (hashMap) {
            ImageSaver saver = suffixTable.get(suffix);
            if (saver == null) {
                try {
                    Class<?> imageSaverClass = Class.forName("acm.util." + suffix + "ImageSaver");
                    saver = (ImageSaver)imageSaverClass.newInstance();
                }
                catch (Exception ex) {
                    return null;
                }
                suffixTable.put(suffix, saver);
            }
            return saver;
        }
    }

    public static AudioClip loadAudioClip(URL url, boolean topLevel) {
        AudioClip clip = null;
        try {
            URLConnection connection = url.openConnection();
            if (MediaTools.isResource(url) || connection.getContentLength() > 0) {
                clip = MediaTools.createAudioClip(connection.getInputStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (topLevel && clip == null) {
            throw new ErrorException("Cannot load audio clip from " + url);
        }
        return clip;
    }

    public static InputStream openDataFile(URL url, boolean topLevel) {
        InputStream in = null;
        try {
            URLConnection connection = url.openConnection();
            if (MediaTools.isResource(url) || connection.getContentLength() > 0) {
                in = connection.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (topLevel && in == null) {
            throw new ErrorException("Cannot read data from " + url);
        }
        return in;
    }

    private static boolean isResource(URL url) {
        String name = url.toString().toLowerCase();
        return name.startsWith("jar:") || name.startsWith("file:");
    }
}

