/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import acm.io.IOConsole;
import apple.dts.samplecode.osxadapter.OSXAdapter;
import cpusim.Machine;
import cpusim.Module;
import cpusim.assembler.Assembler;
import cpusim.assembler.AssemblyException;
import cpusim.gui.AboutDialog;
import cpusim.gui.ActionListenerFor;
import cpusim.gui.AssemblerWindow;
import cpusim.gui.CPUSimMenuItem;
import cpusim.gui.DebugToolBar;
import cpusim.gui.FindDialog;
import cpusim.gui.FontData;
import cpusim.gui.IOOptionsDialog;
import cpusim.gui.LangUnit;
import cpusim.gui.LoadOptionsDialog;
import cpusim.gui.PreferencesDialog;
import cpusim.gui.RAMWindow;
import cpusim.gui.RegistersWindow;
import cpusim.gui.ReopenFileActionListener;
import cpusim.module.RAM;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.scrollabledesktop.JScrollableDesktopPane;
import cpusim.syntax.CPUSimTokenMarker;
import cpusim.syntax.JEditTextArea;
import cpusim.util.Assert;
import cpusim.util.BackupManager;
import cpusim.util.CPUSimConstants;
import cpusim.util.HighlightManager;
import cpusim.util.UpdateDisplayManager;
import cpusim.xml.MachineHTMLWriter;
import cpusim.xml.MachineReader;
import cpusim.xml.MachineWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.xml.sax.SAXParseException;

public class Desktop
extends JFrame
implements CPUSimConstants {
    final int XOFFSET = 15;
    final int YOFFSET = 30;
    final int TEXT_BOX_WIDTH = 250;
    final int TEXT_BOX_HEIGHT = 250;
    private final Machine machine;
    private Assembler assembler;
    private int numOpenedWindows;
    private PrinterJob printJob;
    private PageFormat printFormat;
    private Vector<AssemblerWindow> textWindows;
    private JMenu reopenTextMenu;
    private JMenu reopenMachineMenu;
    private JMenu viewMenu;
    private JMenuItem debugMenuItem;
    private File currentTextDirectory;
    private File currentMachineDirectory;
    private ActionListenerFor.CloseInternalTextFrame closeInternalTextFrameListener;
    private ActionListenerFor.Exit exitListener;
    private JScrollableDesktopPane desktopPane;
    private JSplitPane desktopSplitPane;
    private DebugToolBar debugToolBar;
    private UndoManager undoManager;
    private JMenu runningMenu;
    private Action undoMenuItemAction;
    private Action redoMenuItemAction;
    private InternalFrameListener activateAssemblerWindowListener;
    private InternalFrameListener activateNonAssemblerWindowListener;
    private VetoSelectionListener vetoSelectionListener;
    private UndoEditListener undoEditListener;
    private BackupManager backupManager;
    private UpdateDisplayManager updateDisplayManager;
    private MachineHTMLWriter htmlWriter;
    private HighlightManager highlightManager;
    private FindDialog findDialog;
    private PreferencesDialog preferencesDialog;
    private FontData fontData;
    private AssemblerWindow lastAssembledWindow;
    private final HashMap<Object, BaseInternalFrame> moduleWindows;
    private int menuMask;
    private int currentTheme;
    private boolean saveAutomatically;

    public Desktop(Machine machine, Assembler assembler) {
        super(machine.getName());
        this.machine = machine;
        this.assembler = assembler;
        ActionListenerFor.initialize(this, machine, assembler);
        this.printJob = PrinterJob.getPrinterJob();
        this.printFormat = this.printJob.defaultPage();
        this.numOpenedWindows = 0;
        this.textWindows = new Vector();
        this.moduleWindows = new HashMap();
        this.closeInternalTextFrameListener = new ActionListenerFor.CloseInternalTextFrame();
        this.exitListener = new ActionListenerFor.Exit();
        this.undoManager = null;
        this.currentTextDirectory = new File("");
        this.currentMachineDirectory = new File("");
        this.undoEditListener = new UndoEditListener();
        this.vetoSelectionListener = new VetoSelectionListener();
        this.backupManager = new BackupManager();
        this.updateDisplayManager = new UpdateDisplayManager(this);
        this.highlightManager = new HighlightManager(this);
        this.htmlWriter = new MachineHTMLWriter();
        this.findDialog = null;
        this.preferencesDialog = null;
        this.lastAssembledWindow = null;
        this.runningMenu = new JMenu(LangUnit.LU_RUNNING.str());
        this.saveAutomatically = false;
        this.menuMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar menuBar = this.createMenuBar();
        this.setJMenuBar(menuBar);
        this.setRamMenuItemsEnabled(false);
        Container contentPane = this.getContentPane();
        this.desktopPane = new JScrollableDesktopPane(menuBar);
        this.desktopSplitPane = new JSplitPane(0, this.desktopPane, null);
        this.desktopSplitPane.setResizeWeight(1.0);
        this.desktopSplitPane.setOneTouchExpandable(true);
        contentPane.add((Component)this.desktopSplitPane, "Center");
        this.setTextMenuItemsEnabled(false);
        this.fontData = new FontData(new Font("Monaco", 0, 12), new Font("Dialog", 0, 12), true);
        USER_CHANNEL.setDesktop(this);
        CONSOLE_CHANNEL.setDesktop(this);
        this.addPropertyChangeListenerToAllModules(this.backupManager);
        this.machine.addPropertyChangeListener(this.backupManager);
        this.activateAssemblerWindowListener = new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                Desktop.this.setTextMenuItemsEnabled(true);
                Desktop.this.setRamMenuItemsEnabled(false);
                AssemblerWindow theInternalFrame = (AssemblerWindow)e.getSource();
                Desktop.this.bringWindowToFront(theInternalFrame);
                Desktop.this.undoManager = theInternalFrame.getUndoManager();
                Desktop.this.updateUndo();
            }
        };
        this.activateNonAssemblerWindowListener = new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                Desktop.this.setTextMenuItemsEnabled(false);
                JInternalFrame theInternalFrame = (JInternalFrame)e.getSource();
                Desktop.this.bringWindowToFront(theInternalFrame);
                if (theInternalFrame instanceof RAMWindow) {
                    Desktop.this.setRamMenuItemsEnabled(true);
                } else {
                    Desktop.this.setRamMenuItemsEnabled(false);
                }
                Desktop.this.undoManager = null;
                Desktop.this.updateUndo();
            }
        };
        this.desktopPane.putClientProperty("JScrollableDesktopPane.dragMode", "outline");
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.exitListener);
        this.debugToolBar = new DebugToolBar(this);
        this.debugToolBar.setVisible(false);
        contentPane.add((Component)this.debugToolBar, "North");
        menuBar.add(this.runningMenu);
        this.runningMenu.setVisible(false);
        this.runningMenu.setBackground(Color.RED);
    }

    public Machine getMachine() {
        return this.machine;
    }

    public AssemblerWindow getLastAssembledWindow() {
        return this.lastAssembledWindow;
    }

    public void setLastAssembledWindow(AssemblerWindow lastAssembledWindow) {
        this.lastAssembledWindow = lastAssembledWindow;
    }

    public int getNumOpenedWindows() {
        return this.numOpenedWindows;
    }

    public ActionListenerFor.CloseInternalTextFrame getCloseInternalFrameListener() {
        return this.closeInternalTextFrameListener;
    }

    public InternalFrameListener getActivateAssemblerWindowListener() {
        return this.activateAssemblerWindowListener;
    }

    public InternalFrameListener getActivateNonAssemblerWindowListener() {
        return this.activateNonAssemblerWindowListener;
    }

    public VetoSelectionListener getVetoSelectionListener() {
        return this.vetoSelectionListener;
    }

    public JScrollableDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public HashMap<Object, BaseInternalFrame> getModuleWindows() {
        return this.moduleWindows;
    }

    public PrinterJob getPrintJob() {
        return this.printJob;
    }

    public PageFormat getPrintFormat() {
        return this.printFormat;
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    public DebugToolBar getDebugToolBar() {
        return this.debugToolBar;
    }

    public File getCurrentTextDirectory() {
        return this.currentTextDirectory;
    }

    public File getCurrentMachineDirectory() {
        return this.currentMachineDirectory;
    }

    public void setPrintFormat(PageFormat f) {
        this.printFormat = f;
    }

    public void setCurrentTextDirectory(File d) {
        this.currentTextDirectory = d;
    }

    public void setCurrentMachineDirectory(File d) {
        this.currentMachineDirectory = d;
    }

    public void setNumOpenedWindows(int newNumOpenedWindows) {
        this.numOpenedWindows = newNumOpenedWindows;
    }

    public void setFindDialog(FindDialog dialog) {
        this.findDialog = dialog;
    }

    public Vector<AssemblerWindow> getTextWindows() {
        return this.textWindows;
    }

    public UpdateDisplayManager getUpdateDisplayManager() {
        return this.updateDisplayManager;
    }

    public HighlightManager getHighlightManager() {
        return this.highlightManager;
    }

    public UndoEditListener getUndoEditListener() {
        return this.undoEditListener;
    }

    public FindDialog getFindDialog() {
        return this.findDialog;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void updateAssembler() {
        this.assembler.updateScannerAndParser(this.machine);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createEditMenu());
        menubar.add(this.createModifyMenu());
        menubar.add(this.createExecuteMenu());
        menubar.add(this.createViewMenu());
        menubar.add(this.createHelpMenu());
        return menubar;
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(LangUnit.LU_FILE.str());
        fileMenu.setMnemonic('F');
        CPUSimMenuItem newItem = new CPUSimMenuItem(LangUnit.LU_NEW_TXT.str(), 'N', new ActionListenerFor.NewText(), KeyStroke.getKeyStroke(78, this.menuMask));
        fileMenu.add(newItem);
        CPUSimMenuItem openItem = new CPUSimMenuItem(LangUnit.LU_OPEN_TXT.str(), 'O', new ActionListenerFor.OpenText(), KeyStroke.getKeyStroke(79, this.menuMask));
        fileMenu.add(openItem);
        this.reopenTextMenu = new JMenu(LangUnit.LU_REO_TXT.str());
        this.reopenTextMenu.setMnemonic('R');
        fileMenu.add(this.reopenTextMenu);
        CPUSimMenuItem closeItem = new CPUSimMenuItem(LangUnit.LU_CLOSE_TXT.str(), 'C', this.closeInternalTextFrameListener, KeyStroke.getKeyStroke(87, this.menuMask));
        fileMenu.add(closeItem);
        CPUSimMenuItem saveItem = new CPUSimMenuItem(LangUnit.LU_SAVE_TXT.str(), 'S', new ActionListenerFor.SavingText(0), KeyStroke.getKeyStroke(83, this.menuMask));
        fileMenu.add(saveItem);
        CPUSimMenuItem saveAsItem = new CPUSimMenuItem(LangUnit.LU_SAVE_TXT_AS.str(), 'a', new ActionListenerFor.SavingText(1), KeyStroke.getKeyStroke(83, this.menuMask | 1));
        fileMenu.add(saveAsItem);
        fileMenu.addSeparator();
        JMenu loadRamMenu = new JMenu(LangUnit.LU_LOAD_RAM.str());
        JMenu storeRamMenu = new JMenu(LangUnit.LU_STORE_RAM.str());
        CPUSimMenuItem loadBinaryRamItem = new CPUSimMenuItem(LangUnit.LU_FROM_BIN.str(), 'f', new ActionListenerFor.LoadRam(0));
        loadRamMenu.add(loadBinaryRamItem);
        CPUSimMenuItem loadHexRamItem = new CPUSimMenuItem(LangUnit.LU_FROM_HEX.str(), 'h', new ActionListenerFor.LoadRam(1));
        loadRamMenu.add(loadHexRamItem);
        CPUSimMenuItem loadIntelHexItem = new CPUSimMenuItem(LangUnit.LU_FROM_INTEL.str(), 'e', new ActionListenerFor.LoadRam(2));
        loadRamMenu.add(loadIntelHexItem);
        CPUSimMenuItem storeBinaryRamItem = new CPUSimMenuItem(LangUnit.LU_TO_BIN.str(), 't', new ActionListenerFor.StoreRam(0));
        storeRamMenu.add(storeBinaryRamItem);
        CPUSimMenuItem storeHexRamItem = new CPUSimMenuItem(LangUnit.LU_TO_HEX.str(), 'w', new ActionListenerFor.StoreRam(1));
        storeRamMenu.add(storeHexRamItem);
        CPUSimMenuItem storeIntelHexItem = new CPUSimMenuItem(LangUnit.LU_TO_INTEL.str(), 'x', new ActionListenerFor.StoreRam(2));
        storeRamMenu.add(storeIntelHexItem);
        fileMenu.add(loadRamMenu);
        fileMenu.add(storeRamMenu);
        fileMenu.addSeparator();
        newItem = new CPUSimMenuItem(LangUnit.LU_NEW_MACHINE.str(), 'w', new NewMachineActionListener(), KeyStroke.getKeyStroke(76, this.menuMask));
        fileMenu.add(newItem);
        openItem = new CPUSimMenuItem(LangUnit.LU_OPEN_MACHINE.str(), 'h', new OpenMachineActionListener(), KeyStroke.getKeyStroke(85, this.menuMask));
        fileMenu.add(openItem);
        this.reopenMachineMenu = new JMenu(LangUnit.LU_REO_MACHINE.str());
        this.reopenMachineMenu.setMnemonic('e');
        fileMenu.add(this.reopenMachineMenu);
        saveItem = new CPUSimMenuItem(LangUnit.LU_SAVE_MACHINE.str(), 'i', new ActionListenerFor.SavingMachine(0), KeyStroke.getKeyStroke(66, this.menuMask));
        fileMenu.add(saveItem);
        saveAsItem = new CPUSimMenuItem(LangUnit.LU_SAVE_MACHINE_AS.str(), 'v', new ActionListenerFor.SavingMachine(1), KeyStroke.getKeyStroke(66, this.menuMask | 1));
        fileMenu.add(saveAsItem);
        fileMenu.addSeparator();
        newItem = new CPUSimMenuItem(LangUnit.LU_SAVE_MACHINE_HTML.str(), 'T', new SaveMachineinHTMLActionListener());
        fileMenu.add(newItem);
        fileMenu.addSeparator();
        CPUSimMenuItem printPreviewItem = new CPUSimMenuItem(LangUnit.LU_PRINT_PRE.str(), ' ', new ActionListenerFor.PrintPreview());
        fileMenu.add(printPreviewItem);
        CPUSimMenuItem printSetupItem = new CPUSimMenuItem(LangUnit.LU_PRINT_SETUP.str(), 'u', new ActionListenerFor.PrintSetup());
        fileMenu.add(printSetupItem);
        CPUSimMenuItem printItem = new CPUSimMenuItem(LangUnit.LU_PRINT.str(), 'P', new ActionListenerFor.Print(), KeyStroke.getKeyStroke(80, this.menuMask));
        fileMenu.add(printItem);
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("userWantsToQuit", null));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, LangUnit.LU_UNABLE_LD_CODE.str(), LangUnit.LU_ERR.str(), 0);
            }
        } else {
            fileMenu.addSeparator();
            CPUSimMenuItem exitItem = new CPUSimMenuItem(LangUnit.LU_EXIT.str(), 'x', this.exitListener);
            fileMenu.add(exitItem);
        }
        return fileMenu;
    }

    public boolean userWantsToQuit() {
        if (this.doCloseAllAssemblerWindows() && this.doCloseMachine()) {
            this.machine.resetAllChannels();
            this.storePreferences();
            return true;
        }
        return false;
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu(LangUnit.LU_EDIT.str());
        editMenu.setMnemonic('E');
        this.undoMenuItemAction = new AbstractAction(LangUnit.LU_UNDO.str()){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.this.undoManager.undo();
                }
                catch (CannotUndoException ex) {
                    Toolkit.getDefaultToolkit().beep();
                }
                Desktop.this.updateUndo();
            }
        };
        JMenuItem newJMenuItem = editMenu.add(this.undoMenuItemAction);
        newJMenuItem.setMnemonic('u');
        newJMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, this.menuMask));
        this.undoMenuItemAction.setEnabled(false);
        this.redoMenuItemAction = new AbstractAction(LangUnit.LU_REDO.str()){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.this.undoManager.redo();
                }
                catch (CannotRedoException ex) {
                    Toolkit.getDefaultToolkit().beep();
                }
                Desktop.this.updateUndo();
            }
        };
        JMenuItem newJMenuItem2 = editMenu.add(this.redoMenuItemAction);
        newJMenuItem2.setMnemonic('r');
        newJMenuItem2.setAccelerator(KeyStroke.getKeyStroke(89, this.menuMask));
        this.redoMenuItemAction.setEnabled(false);
        editMenu.addSeparator();
        CPUSimMenuItem newItem = new CPUSimMenuItem(LangUnit.LU_CUT.str(), 't', new ActionListenerFor.TextEdit(1), KeyStroke.getKeyStroke(88, this.menuMask));
        editMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_COPY.str(), 'C', new ActionListenerFor.TextEdit(0), KeyStroke.getKeyStroke(67, this.menuMask));
        editMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_PASTE.str(), 'P', new ActionListenerFor.TextEdit(2), KeyStroke.getKeyStroke(86, this.menuMask));
        editMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_DELETE_B.str(), 'D', new ActionListenerFor.Delete());
        editMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_SELECT_ALL.str(), 'A', new ActionListenerFor.TextEdit(3), KeyStroke.getKeyStroke(65, this.menuMask));
        editMenu.add(newItem);
        editMenu.addSeparator();
        newItem = new CPUSimMenuItem(LangUnit.LU_FIND.str(), 'f', new ActionListenerFor.Find(), KeyStroke.getKeyStroke(70, this.menuMask));
        editMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_REPLACE.str(), 'e', new ActionListenerFor.Replace(), KeyStroke.getKeyStroke(72, this.menuMask));
        editMenu.add(newItem);
        if (MAC_OS_X) {
            try {
                OSXAdapter.setPreferencesHandler(this, this.getClass().getDeclaredMethod("showPreferencesDialog", null));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, LangUnit.LU_UNABLE_LD_PREF.str(), LangUnit.LU_ERR.str(), 0);
            }
        } else {
            editMenu.addSeparator();
            AbstractAction preferencesAction = new AbstractAction(LangUnit.LU_PREF.str()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Desktop.this.showPreferencesDialog();
                }
            };
            JMenuItem newJMenuItem5 = editMenu.add(preferencesAction);
            newJMenuItem5.setMnemonic('n');
            newJMenuItem5.setAccelerator(KeyStroke.getKeyStroke(84, this.menuMask));
        }
        return editMenu;
    }

    public void showPreferencesDialog() {
        this.preferencesDialog = new PreferencesDialog(this);
        this.preferencesDialog.pack();
        Dimension d1 = this.preferencesDialog.getSize();
        Dimension d2 = this.getSize();
        int x = Math.max((d2.width - d1.width) / 2, 0);
        int y = Math.max((d2.height - d1.height) / 2, 0);
        this.preferencesDialog.setBounds(x + this.getX(), y + this.getY(), d1.width, d1.height);
        this.preferencesDialog.setVisible(true);
    }

    private JMenu createModifyMenu() {
        JMenu modifyMenu = new JMenu(LangUnit.LU_MODIFY.str());
        modifyMenu.setMnemonic('M');
        CPUSimMenuItem newItem = new CPUSimMenuItem(LangUnit.LU_MACHINE_INS.str(), 'I', new ActionListenerFor.MachineInstructions(), KeyStroke.getKeyStroke(73, this.menuMask));
        modifyMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_MICRO_INS.str(), 'c', new ActionListenerFor.Microinstructions(), KeyStroke.getKeyStroke(77, this.menuMask));
        modifyMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_HD_MODULE.str(), 'H', new ActionListenerFor.HardwareModules(), KeyStroke.getKeyStroke(75, this.menuMask));
        modifyMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_FETCH.str(), 'F', new ActionListenerFor.FetchSequence());
        modifyMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_EQU.str(), 'E', new ActionListenerFor.EQUs(), KeyStroke.getKeyStroke(69, this.menuMask));
        modifyMenu.add(newItem);
        return modifyMenu;
    }

    private JMenu createExecuteMenu() {
        JMenu executeMenu = new JMenu(LangUnit.LU_EXECUTE.str());
        executeMenu.setMnemonic('x');
        this.debugMenuItem = new JCheckBoxMenuItem(LangUnit.LU_DEBUG_MODE.str());
        this.debugMenuItem.setMnemonic('D');
        this.debugMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, this.menuMask));
        this.debugMenuItem.addActionListener(new DebugModeActionListener());
        executeMenu.add(this.debugMenuItem);
        executeMenu.addSeparator();
        CPUSimMenuItem newItem = new CPUSimMenuItem(LangUnit.LU_ASM.str(), 'A', new ActionListenerFor.Assemble(), KeyStroke.getKeyStroke(91, this.menuMask));
        executeMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_ASM_LD.str(), 'l', new ActionListenerFor.AssembleAndLoad());
        newItem.setAccelerator(KeyStroke.getKeyStroke(93, this.menuMask));
        executeMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_ASM_LD_RUN.str(), 'r', new ActionListenerFor.AssembleLoadAndRun());
        executeMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_CLR_ASM_LD_RUN.str(), 'u', new ActionListenerFor.ClearAssembleLoadAndRun());
        newItem.setAccelerator(KeyStroke.getKeyStroke(71, this.menuMask));
        executeMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_RUN.str(), 'n', new ActionListenerFor.Run());
        executeMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_STOP.str(), 'S', new ActionListenerFor.StopListener(), KeyStroke.getKeyStroke(46, this.menuMask));
        executeMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_RESET.str(), 'e', new ActionListenerFor.ResetEverything());
        newItem.setAccelerator(KeyStroke.getKeyStroke(82, this.menuMask));
        executeMenu.add(newItem);
        executeMenu.addSeparator();
        JMenu optionsMenu = new JMenu(LangUnit.LU_OPTIONS.str());
        optionsMenu.setMnemonic('O');
        newItem = new CPUSimMenuItem(LangUnit.LU_HIGHLIGHT.str(), 'h', new ActionListenerFor.Highlighting());
        optionsMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_LOADING.str(), 'L', new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadOptionsDialog d = new LoadOptionsDialog((Frame)Desktop.this, Desktop.this.machine, true);
                d.pack();
                Dimension d1 = d.getSize();
                Dimension d2 = Desktop.this.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                d.setBounds(x + Desktop.this.getX(), y + Desktop.this.getY(), d1.width, d1.height);
                d.setVisible(true);
            }
        });
        optionsMenu.add(newItem);
        newItem = new CPUSimMenuItem(LangUnit.LU_IO_CONNECT.str(), 'I', new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOOptionsDialog d = new IOOptionsDialog((Frame)Desktop.this, Desktop.this.machine);
                d.pack();
                Dimension d1 = d.getSize();
                Dimension d2 = Desktop.this.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                d.setBounds(x + Desktop.this.getX(), y + Desktop.this.getY(), d1.width, d1.height);
                d.setVisible(true);
            }
        }, KeyStroke.getKeyStroke(74, this.menuMask));
        optionsMenu.add(newItem);
        executeMenu.add(optionsMenu);
        return executeMenu;
    }

    private JMenu createViewMenu() {
        this.viewMenu = new JMenu(LangUnit.LU_VIEW.str());
        this.viewMenu.setMnemonic('V');
        CPUSimMenuItem newItem = new CPUSimMenuItem(LangUnit.LU_REGS.str(), 'R', new ActionListenerFor.Registers());
        this.viewMenu.add(newItem);
        this.viewMenu.addSeparator();
        this.addRegisterArrayMenuItems();
        this.viewMenu.addSeparator();
        this.addRAMMenuItems();
        return this.viewMenu;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu(LangUnit.LU_HELP.str());
        helpMenu.setMnemonic('H');
        CPUSimMenuItem newItem = new CPUSimMenuItem(LangUnit.LU_GEN_HELP.str(), 'C', new ActionListenerFor.GeneralCPUSimHelp());
        helpMenu.add(newItem);
        if (MAC_OS_X) {
            try {
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAboutDialog", null));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, LangUnit.LU_UNABLE_LD_ABOUT.str(), LangUnit.LU_ERR.str(), 0);
            }
        } else {
            helpMenu.addSeparator();
            newItem = new CPUSimMenuItem(LangUnit.LU_ABOUT_APP.str(), 'A', new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Desktop.this.showAboutDialog();
                }
            });
            helpMenu.add(newItem);
        }
        return helpMenu;
    }

    public void showAboutDialog() {
        AboutDialog d = new AboutDialog(this);
        d.pack();
        Dimension d1 = d.getSize();
        Dimension d2 = this.getSize();
        int x = Math.max((d2.width - d1.width) / 2, 0);
        int y = Math.max((d2.height - d1.height) / 2, 0);
        d.setBounds(x + this.getX(), y + this.getY(), d1.width, d1.height);
        d.setVisible(true);
    }

    public void displayHaltBitsThatAreSet() {
        Vector setHaltedBits = this.machine.haltBitsThatAreSet();
        if (setHaltedBits.size() > 0) {
            String message = LangUnit.LU_FOLLOW_HALT_BIT.str();
            for (int i = 0; i < setHaltedBits.size(); ++i) {
                message = message + setHaltedBits.elementAt(i) + "  ";
            }
            JOptionPane.showMessageDialog(this, message, LangUnit.LU_EXE_HALT.str(), -1);
        }
    }

    public void adjustMenusForNewModules() {
        for (int i = this.viewMenu.getMenuComponentCount() - 1; i >= 2; --i) {
            this.viewMenu.remove(i);
        }
        this.addRegisterArrayMenuItems();
        this.viewMenu.addSeparator();
        this.addRAMMenuItems();
    }

    public void adjustWindowsForNewModules() {
        BaseInternalFrame value;
        HashSet<Object> toRemove = new HashSet<Object>();
        for (Object key : this.moduleWindows.keySet()) {
            value = this.moduleWindows.get(key);
            if (key.equals("Registers")) {
                ((RegistersWindow)value).updateRegistersTable(this.machine.getModule("registers"));
                continue;
            }
            if (this.machine.getModule("registerArrays").contains(key)) {
                ((RegistersWindow)value).updateRegistersTable(((RegisterArray)key).registers());
                ((RegistersWindow)value).setTitle(LangUnit.LU_REG_ARR_C.str() + ((RegisterArray)key).getName());
                continue;
            }
            if (this.machine.getModule("rams").contains(key)) {
                ((RAMWindow)value).updateRAMTable();
                ((RAMWindow)value).setTitle(LangUnit.LU_RAM_C.str() + ((RAM)key).getName());
                continue;
            }
            toRemove.add(key);
        }
        for (Object key : toRemove) {
            value = this.moduleWindows.remove(key);
            Assert.That(value != null, LangUnit.LU_NULL_VALUE.str());
            value.dispose();
        }
    }

    public AssemblerWindow openWindowForFile(File file) {
        for (JInternalFrame window : this.desktopPane.getAllFrames()) {
            if (!(window instanceof AssemblerWindow) || ((AssemblerWindow)window).getSourceFile() == null || !((AssemblerWindow)window).getSourceFile().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            this.bringWindowToFront(window);
            return (AssemblerWindow)window;
        }
        AssemblerWindow newAssemblerWindow = new AssemblerWindow(file, this.findNextTextWindowLocation(), this.closeInternalTextFrameListener, this.activateAssemblerWindowListener, (VetoableChangeListener)this.vetoSelectionListener);
        newAssemblerWindow.getTextArea().getSyntaxDocument().addUndoableEditListener(this.undoEditListener);
        newAssemblerWindow.setTextFont(this.fontData.textWindowFont);
        this.textWindows.addElement(newAssemblerWindow);
        if (!this.reopenMenuContainsFile(this.reopenTextMenu, file)) {
            CPUSimMenuItem newReopenItem = new CPUSimMenuItem(file.getAbsolutePath(), new ReopenTextActionListener(file));
            this.reopenTextMenu.add((Component)newReopenItem, 0);
            if (this.reopenTextMenu.getMenuComponentCount() > 10) {
                this.reopenTextMenu.remove(10);
            }
        }
        Rectangle bounds = newAssemblerWindow.getBounds(null);
        this.desktopPane.add(newAssemblerWindow, bounds.x, bounds.y);
        this.setToCurrentTheme(newAssemblerWindow);
        this.updateDocumentSyntaxOf(newAssemblerWindow);
        this.bringWindowToFront(newAssemblerWindow);
        newAssemblerWindow.setCaretPosition(0);
        return newAssemblerWindow;
    }

    public Point findNextTextWindowLocation() {
        Point result = new Point(0, 0);
        int current_width = this.getContentPane().getWidth();
        int current_height = this.getContentPane().getHeight();
        while (this.isTextWindowAtPoint(result)) {
            result.y += 30;
            result.x += 15;
            if (result.y <= current_height - 250) continue;
            int text_box_rows = result.y / 30 - 1;
            result.y = 0;
            result.x = result.x - 15 * text_box_rows + 250;
        }
        if (result.x > current_width - 250) {
            result = new Point(0, 0);
        }
        return result;
    }

    private boolean isTextWindowAtPoint(Point p) {
        Point currentPoint = new Point();
        Enumeration<AssemblerWindow> windows = this.textWindows.elements();
        while (windows.hasMoreElements()) {
            AssemblerWindow currentWindow = windows.nextElement();
            currentPoint = currentWindow.getLocation(currentPoint);
            if (!currentPoint.equals(p)) continue;
            return true;
        }
        return false;
    }

    private boolean reopenMenuContainsFile(JMenu menu, File file) {
        Component[] menuItems;
        for (Component menuItem : menuItems = menu.getMenuComponents()) {
            JMenuItem item = (JMenuItem)menuItem;
            ReopenFileActionListener listener = (ReopenFileActionListener)item.getActionListeners()[0];
            if (!listener.getFile().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private void addRegisterArrayMenuItems() {
        int numItems = this.machine.getModule("registerArrays").size();
        if (numItems == 0) {
            JMenuItem emptyItem = new JMenuItem(LangUnit.LU_NO_REG.str());
            emptyItem.setEnabled(false);
            this.viewMenu.add(emptyItem);
        }
        for (int i = 0; i < numItems; ++i) {
            final RegisterArray array = (RegisterArray)this.machine.getModule("registerArrays").elementAt(i);
            CPUSimMenuItem newItem = new CPUSimMenuItem(LangUnit.LU_REG_ARR.str() + array.getName(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RegistersWindow w = (RegistersWindow)Desktop.this.moduleWindows.get(array);
                    if (w == null) {
                        w = new RegistersWindow(array.registers(), LangUnit.LU_REG_ARR_C.str() + array, Desktop.this.activateNonAssemblerWindowListener, Desktop.this.vetoSelectionListener);
                        w.setTableFont(((Desktop)Desktop.this).fontData.tableFont);
                        Desktop.this.desktopPane.add(w);
                        Desktop.this.moduleWindows.put(array, w);
                    } else {
                        w.setVisible(true);
                    }
                    Desktop.this.bringWindowToFront(w);
                }
            });
            this.viewMenu.add(newItem);
        }
    }

    private void addRAMMenuItems() {
        int numItems = this.machine.getModule("rams").size();
        if (numItems == 0) {
            JMenuItem emptyItem = new JMenuItem(LangUnit.LU_NO_RAM.str());
            emptyItem.setEnabled(false);
            this.viewMenu.add(emptyItem);
        }
        for (int i = 0; i < numItems; ++i) {
            final RAM ram = (RAM)this.machine.getModule("rams").elementAt(i);
            CPUSimMenuItem newItem = new CPUSimMenuItem(LangUnit.LU_RAM.str() + ram.getName(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RAMWindow w = (RAMWindow)Desktop.this.moduleWindows.get(ram);
                    if (w == null) {
                        w = new RAMWindow(ram, Desktop.this.highlightManager, Desktop.this.activateNonAssemblerWindowListener, Desktop.this.vetoSelectionListener, Desktop.this.debugToolBar.isVisible());
                        w.setTableFont(((Desktop)Desktop.this).fontData.tableFont);
                        Desktop.this.desktopPane.add(w);
                        Desktop.this.moduleWindows.put(ram, w);
                    } else {
                        w.setVisible(true);
                    }
                    Desktop.this.bringWindowToFront(w);
                }
            });
            this.viewMenu.add(newItem);
        }
    }

    public void updateUndo() {
        if (this.undoManager != null && this.undoManager.canUndo()) {
            this.undoMenuItemAction.setEnabled(true);
            this.undoMenuItemAction.putValue("Name", this.undoManager.getUndoPresentationName());
        } else {
            this.undoMenuItemAction.setEnabled(false);
            this.undoMenuItemAction.putValue("Name", "Undo");
        }
        if (this.undoManager != null && this.undoManager.canRedo()) {
            this.redoMenuItemAction.setEnabled(true);
            this.redoMenuItemAction.putValue("Name", this.undoManager.getRedoPresentationName());
        } else {
            this.redoMenuItemAction.setEnabled(false);
            this.redoMenuItemAction.putValue("Name", "Redo");
        }
    }

    public void addPropertyChangeListenerToAllModules(PropertyChangeListener listener) {
        Vector registerVector = this.machine.getModule("registers");
        for (int i = 0; i < registerVector.size(); ++i) {
            Module m = (Module)registerVector.elementAt(i);
            m.removePropertyChangeListener(listener);
            m.addPropertyChangeListener(listener);
        }
        Vector arrays = this.machine.getModule("registerArrays");
        for (int i = 0; i < arrays.size(); ++i) {
            Register[] registers;
            for (Register register : registers = ((RegisterArray)arrays.elementAt(i)).registers()) {
                register.removePropertyChangeListener(listener);
                register.addPropertyChangeListener(listener);
            }
        }
        Vector rams = this.machine.getModule("rams");
        for (int i = 0; i < rams.size(); ++i) {
            Module ram = (Module)rams.elementAt(i);
            ram.removePropertyChangeListener(listener);
            ram.addPropertyChangeListener(listener);
        }
    }

    public JInternalFrame getSelectedFrame() {
        return this.desktopPane.getSelectedFrame();
    }

    private boolean userWantsToSave(String fileName) {
        Object[] options = new Object[]{LangUnit.LU_YES.str(), LangUnit.LU_SAVE_AUTO.str(), LangUnit.LU_CANCEL.str()};
        int result = JOptionPane.showOptionDialog(this, LangUnit.LU_SAVE_FILE.str() + fileName + LangUnit.LU_BEF_ASM.str(), LangUnit.LU_SAVE_FILE_A.str(), 1, 3, null, options, options[0]);
        if (result == 2 || result == -1) {
            return false;
        }
        if (result == 1) {
            this.saveAutomatically = true;
            return true;
        }
        return true;
    }

    public boolean assembleCurrentProgram() {
        AssemblerWindow window = this.getWindowToAssemble();
        assert (window != null);
        if (window.isDirty() && !this.saveAutomatically && !this.userWantsToSave(window.getTitle())) {
            return false;
        }
        FileDialog chooser = new FileDialog((Frame)this, LangUnit.LU_SAVE_ASM.str(), 1);
        chooser.setDirectory(this.currentTextDirectory.getAbsolutePath());
        boolean savedSuccessfully = window.save(chooser);
        this.currentTextDirectory = new File(chooser.getDirectory());
        if (!savedSuccessfully) {
            return false;
        }
        File sourceFile = window.getSourceFile();
        try {
            this.assembler.assemble(sourceFile.getAbsolutePath(), this.machine.getStartingAddressForLoading());
        }
        catch (AssemblyException exc) {
            String errorMessage = exc.getMessage();
            if (exc.token.type == 8) {
                errorMessage = errorMessage + LangUnit.LU_RET_AT_END.str();
            } else if (exc.token.columnNumber != -1 || exc.token.lineNumber != -1) {
                errorMessage = errorMessage + LangUnit.LU_RET_AT_LINE.str() + (exc.token.lineNumber + 1) + LangUnit.LU_AND_COLUMN.str() + exc.token.columnNumber;
            }
            if (!exc.token.filename.equals("")) {
                errorMessage = errorMessage + LangUnit.LU_RET_IN_FILE.str() + exc.token.filename;
            }
            if (sourceFile.getAbsolutePath().equals(exc.token.filename)) {
                window.highlightTextFrom(exc.token.offset, exc.token.offset + exc.token.contents.length());
            } else {
                AssemblerWindow newWindow = this.openWindowForFile(new File(exc.token.filename));
                newWindow.highlightTextFrom(exc.token.offset, exc.token.offset + exc.token.contents.length());
            }
            JOptionPane.showMessageDialog(this, errorMessage, LangUnit.LU_ASM_ERR.str(), 0);
            return false;
        }
        return true;
    }

    public boolean doCloseAssemblerWindow(AssemblerWindow frame) {
        if (frame.isDirty()) {
            int saveIt = JOptionPane.showConfirmDialog(this, LangUnit.LU_SAVE.str() + frame.getTitle() + LangUnit.LU_BEF_CLOSING.str());
            if (saveIt == 2 || saveIt == -1) {
                return false;
            }
            if (saveIt == 0) {
                FileDialog chooser = new FileDialog((Frame)this, LangUnit.LU_SAVE_ASM.str(), 1);
                chooser.setDirectory(this.currentTextDirectory.getAbsolutePath());
                frame.save(chooser);
                this.currentTextDirectory = new File(chooser.getDirectory());
                if (frame.isDirty()) {
                    return false;
                }
            }
        }
        Assert.That(this.textWindows.indexOf(frame) >= 0, LangUnit.LU_REM_FRAME.str() + frame + LangUnit.LU_FROM_TEXT.str());
        this.undoManager = null;
        this.updateUndo();
        this.textWindows.removeElement(frame);
        return true;
    }

    public boolean doCloseAllAssemblerWindows() {
        while (this.textWindows.size() > 0) {
            boolean success = this.doCloseAssemblerWindow(this.textWindows.elementAt(0));
            if (success) continue;
            return false;
        }
        return true;
    }

    public boolean doCloseMachine() {
        File file = this.machine.getFile();
        if (this.machine.isDirty()) {
            int saveIt = JOptionPane.showConfirmDialog(this, LangUnit.LU_SAVE.str() + this.getTitle() + LangUnit.LU_BEF_CLOSING.str());
            if (saveIt == 2 || saveIt == -1) {
                return false;
            }
            if (saveIt == 0) {
                if (file == null && (file = this.chooseFileToWriteTo()) == null) {
                    return false;
                }
                boolean success = this.saveMachineToFile(file);
                if (success) {
                    return true;
                }
                int closeItAnyway = JOptionPane.showConfirmDialog(this, LangUnit.LU_CLOSE.str() + this.getTitle() + LangUnit.LU_ANYWAY.str());
                return closeItAnyway != 2 && closeItAnyway != -1 && closeItAnyway != 1;
            }
        }
        return true;
    }

    public boolean saveMachineToFile(File file) {
        boolean success = true;
        MachineWriter writer = new MachineWriter();
        try {
            writer.writeMachine(this.machine, file.getName(), this.moduleWindows, this.getHighlightManager().getRegisterRAMPairs(), new PrintWriter((Writer)new FileWriter(file), true));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, LangUnit.LU_THERE_UNKNOWN.str() + LangUnit.LU_ERR_SAVE_MACHINE.str(), LangUnit.LU_SAVE_MACHINE_ERR.str(), 0);
            success = false;
        }
        return success;
    }

    public File chooseFileToWriteTo() {
        FileDialog chooser = new FileDialog((Frame)this, LangUnit.LU_SAVE_MACHINE_TITLE.str(), 1);
        chooser.setDirectory(this.getCurrentMachineDirectory().getAbsolutePath());
        chooser.setVisible(true);
        String fileName = chooser.getFile();
        String directoryName = chooser.getDirectory();
        if (fileName == null) {
            return null;
        }
        File newFile = new File(directoryName + fileName);
        this.currentMachineDirectory = new File(directoryName);
        return newFile;
    }

    private void setRamMenuItemsEnabled(boolean enable) {
        this.getJMenuBar().getMenu(0).getItem(7).setEnabled(enable);
        this.getJMenuBar().getMenu(0).getItem(8).setEnabled(enable);
    }

    private void setTextMenuItemsEnabled(boolean enable) {
        this.getJMenuBar().getMenu(0).getItem(3).setEnabled(enable);
        this.getJMenuBar().getMenu(0).getItem(4).setEnabled(enable);
        this.getJMenuBar().getMenu(0).getItem(5).setEnabled(enable);
        this.getJMenuBar().getMenu(0).getItem(18).setEnabled(enable);
        this.getJMenuBar().getMenu(0).getItem(20).setEnabled(enable);
        this.getJMenuBar().getMenu(3).getItem(2).setEnabled(enable || this.getWindowToAssemble() != null);
        this.getJMenuBar().getMenu(3).getItem(3).setEnabled(enable || this.getWindowToAssemble() != null);
        this.getJMenuBar().getMenu(3).getItem(4).setEnabled((enable || this.getWindowToAssemble() != null) && !this.debugMenuItem.isSelected());
        this.getJMenuBar().getMenu(3).getItem(5).setEnabled((enable || this.getWindowToAssemble() != null) && !this.debugMenuItem.isSelected());
    }

    public void bringWindowToFront(JInternalFrame window) {
        try {
            if (window.isIcon()) {
                window.setIcon(false);
            }
            window.setSelected(true);
            if (window instanceof AssemblerWindow) {
                ((AssemblerWindow)window).requestTextFocus();
            }
        }
        catch (PropertyVetoException exc) {
            JOptionPane.showMessageDialog(this, LangUnit.LU_THERE_WAS.str() + LangUnit.LU_ERR_SEL_WIN.str(), LangUnit.LU_WIN_SEL_ERR.str(), 0);
        }
    }

    public void setFontData(FontData newData) {
        this.fontData = newData;
        for (AssemblerWindow window : this.textWindows) {
            window.setTextFont(this.fontData.textWindowFont);
        }
        for (BaseInternalFrame frame : this.moduleWindows.values()) {
            if (frame instanceof RAMWindow) {
                ((RAMWindow)frame).setTableFont(this.fontData.tableFont);
                continue;
            }
            if (!(frame instanceof RegistersWindow)) continue;
            ((RegistersWindow)frame).setTableFont(this.fontData.tableFont);
        }
    }

    public void addConsoleToLowerPane(IOConsole io) {
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), LangUnit.LU_IO_CONSOLE.str());
        border.setTitlePosition(1);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)io, "Center");
        bottomPanel.setBorder(border);
        this.desktopSplitPane.setBottomComponent(bottomPanel);
        bottomPanel.setPreferredSize(new Dimension(300, 90));
    }

    public void enableChangeMachineMenuItems(boolean enable) {
        JMenu fileMenu = this.getJMenuBar().getMenu(0);
        fileMenu.getItem(10).setEnabled(enable);
        fileMenu.getItem(11).setEnabled(enable);
        fileMenu.getItem(12).setEnabled(enable);
    }

    public void enableRunMenuItems(boolean enable) {
        JMenu executeMenu = this.getJMenuBar().getMenu(3);
        executeMenu.getItem(0).setEnabled(enable);
        executeMenu.getItem(4).setEnabled(enable);
        executeMenu.getItem(5).setEnabled(enable);
        executeMenu.getItem(6).setEnabled(enable);
        executeMenu.getItem(8).setEnabled(enable);
        ((JMenu)executeMenu.getItem(10)).getItem(2).setEnabled(enable);
    }

    public void setModifyMenuEnabled(boolean enable) {
        this.getJMenuBar().getMenu(2).setEnabled(enable);
    }

    public AssemblerWindow getWindowToAssemble() {
        AssemblerWindow window;
        JInternalFrame selectedFrame = this.getSelectedFrame();
        if (selectedFrame instanceof AssemblerWindow) {
            window = (AssemblerWindow)selectedFrame;
            this.setLastAssembledWindow(window);
        } else {
            window = this.getLastAssembledWindow() == null || this.getLastAssembledWindow().isClosed() ? null : this.getLastAssembledWindow();
        }
        return window;
    }

    public void setRunningMenuVisible(boolean b) {
        this.runningMenu.setVisible(b);
    }

    private void readAndDisplayMachine(File file) {
        MachineReader reader = new MachineReader();
        try {
            reader.parseDataFromFile(file);
        }
        catch (Exception mre) {
            String message = mre.getMessage();
            if (message == null) {
                message = LangUnit.LU_ERR_UNKNOWN.str();
            }
            String messagePrefix = LangUnit.LU_ERR_READ.str() + file.getName() + "\"";
            if (mre instanceof SAXParseException) {
                messagePrefix = messagePrefix + LangUnit.LU_AT_LINE.str() + ((SAXParseException)mre).getLineNumber();
            }
            message = messagePrefix + LangUnit.LU_RET.str() + message;
            JOptionPane.showMessageDialog(this, message, LangUnit.LU_READ_ERR.str(), 0);
            return;
        }
        this.displayMachine(reader, file);
    }

    public void displayMachine(MachineReader reader, File fileToOpen) {
        JInternalFrame[] windows;
        this.moduleWindows.clear();
        for (JInternalFrame window : windows = this.desktopPane.getAllFrames()) {
            if (window instanceof AssemblerWindow) continue;
            window.dispose();
        }
        this.machine.copyFrom(reader.getMachine());
        this.highlightManager.setRegisterRAMPairs(reader.getRegisterRAMPairs());
        this.openSavedWindows(reader.getWindowInfo(), reader.getCellSizeInfo(), reader.getContentBaseInfo(), reader.getAddressBaseInfo());
        this.adjustMenusForNewModules();
        if (!this.reopenMenuContainsFile(this.reopenMachineMenu, fileToOpen)) {
            CPUSimMenuItem newReopenItem = new CPUSimMenuItem(fileToOpen.getAbsolutePath(), new ReopenMachineActionListener(fileToOpen));
            this.reopenMachineMenu.add((Component)newReopenItem, 0);
            if (this.reopenMachineMenu.getMenuComponentCount() > 10) {
                this.reopenMachineMenu.remove(10);
            }
        }
        this.setTitle(this.machine.getName());
        this.machine.setFile(fileToOpen);
        this.backupManager.flushBackups();
        this.addPropertyChangeListenerToAllModules(this.backupManager);
        this.debugToolBar.updateDisplay();
        this.updateSyntaxOfAllDocuments();
        this.updateAssembler();
    }

    public void updateDialogSizePrefs(String className, int x, int y, int width, int height) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.putInt(className + ".x", x);
        prefs.putInt(className + ".y", y);
        prefs.putInt(className + ".width", width);
        prefs.putInt(className + ".height", height);
    }

    public Rectangle getDialogSizePrefs(String className) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        return new Rectangle(prefs.getInt(className + ".x", 0), prefs.getInt(className + ".y", 0), prefs.getInt(className + ".width", 0), prefs.getInt(className + ".height", 0));
    }

    public void storePreferences() {
        ReopenFileActionListener listener;
        JMenuItem item;
        int i;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String machineDirectory = this.getCurrentMachineDirectory().getAbsolutePath();
        prefs.put("machineDirectory", machineDirectory);
        String textDirectory = this.getCurrentTextDirectory().getAbsolutePath();
        prefs.put("textDirectory", textDirectory);
        Component[] menuItems = this.reopenTextMenu.getMenuComponents();
        prefs.putInt("numTextFiles", menuItems.length);
        for (i = 0; i < menuItems.length; ++i) {
            item = (JMenuItem)menuItems[i];
            listener = (ReopenFileActionListener)item.getActionListeners()[0];
            prefs.put("textFile" + i, listener.getFile().getAbsolutePath());
        }
        menuItems = this.reopenMachineMenu.getMenuComponents();
        prefs.putInt("numMachineFiles", menuItems.length);
        for (i = 0; i < menuItems.length; ++i) {
            item = (JMenuItem)menuItems[i];
            listener = (ReopenFileActionListener)item.getActionListeners()[0];
            prefs.put("machineFile" + i, listener.getFile().getAbsolutePath());
        }
        prefs.put("textFontName", this.fontData.textWindowFont.getFontName());
        prefs.putInt("textFontSize", this.fontData.textWindowFont.getSize());
        prefs.putInt("textFontStyle", this.fontData.textWindowFont.getStyle());
        prefs.putBoolean("textLineWrap", this.fontData.textWindowLineWrap);
        prefs.put("tableFontName", this.fontData.tableFont.getFontName());
        prefs.putInt("tableFontSize", this.fontData.tableFont.getSize());
        prefs.putInt("tableFontStyle", this.fontData.tableFont.getStyle());
        prefs.putInt("fontTheme", this.getTheme());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            String message = e.getMessage();
            message = message == null ? LangUnit.LU_ERR_APP_ATTEMP.str() + LangUnit.LU_USER_PREF.str() : LangUnit.LU_FOLLOW_ERR_APP.str() + LangUnit.LU_TO_SAVE_PREF.str() + message;
            JOptionPane.showMessageDialog(this, message, LangUnit.LU_WRITE_ERR.str(), 0);
        }
    }

    public void loadPreferences() {
        CPUSimMenuItem newReopenItem;
        File file;
        String fileName;
        int i;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String textFontName = prefs.get("textFontName", "Courier New");
        String tableFontName = prefs.get("tableFontName", "Dialog");
        int textFontSize = prefs.getInt("textFontSize", 12);
        int tableFontSize = prefs.getInt("tableFontSize", 12);
        int textFontStyle = prefs.getInt("textFontStyle", 0);
        int tableFontStyle = prefs.getInt("tableFontStyle", 0);
        boolean textLineWrap = prefs.getBoolean("textLineWrap", true);
        int fontTheme = prefs.getInt("fontTheme", 0);
        this.setFontData(new FontData(new Font(textFontName, textFontStyle, textFontSize), new Font(tableFontName, tableFontStyle, tableFontSize), textLineWrap));
        this.setTheme(fontTheme);
        String machineDirectory = prefs.get("machineDirectory", "");
        this.setCurrentMachineDirectory(new File(machineDirectory));
        String textDirectory = prefs.get("textDirectory", "");
        this.setCurrentTextDirectory(new File(textDirectory));
        int numTextFiles = prefs.getInt("numTextFiles", 0);
        int numMachineFiles = prefs.getInt("numMachineFiles", 0);
        for (i = 0; i < numTextFiles; ++i) {
            fileName = prefs.get("textFile" + i, null);
            if (fileName == null) continue;
            file = new File(fileName);
            if (this.reopenTextMenu.getMenuComponentCount() >= 10) continue;
            newReopenItem = new CPUSimMenuItem(file.getAbsolutePath(), new ReopenTextActionListener(file));
            this.reopenTextMenu.add(newReopenItem);
        }
        for (i = 0; i < numMachineFiles; ++i) {
            fileName = prefs.get("machineFile" + i, null);
            if (fileName == null || this.reopenMenuContainsFile(this.reopenMachineMenu, file = new File(fileName)) || this.reopenMachineMenu.getMenuComponentCount() >= 10) continue;
            newReopenItem = new CPUSimMenuItem(file.getAbsolutePath(), new ReopenMachineActionListener(file));
            this.reopenMachineMenu.add(newReopenItem);
        }
    }

    private void openSavedWindows(HashMap windowInfo, HashMap cellSizeInfo, HashMap contentBaseInfo, HashMap addressBaseInfo) {
        for (Object key : windowInfo.keySet()) {
            BaseInternalFrame w = null;
            if (key.equals("Registers")) {
                w = new RegistersWindow(this.machine.getModule("registers").toArray(new Register[0]), "Registers", this.activateNonAssemblerWindowListener, this.vetoSelectionListener);
                ((RegistersWindow)w).setTableFont(this.fontData.tableFont);
                ((RegistersWindow)w).setBase((String)contentBaseInfo.get(key));
            } else if (key instanceof RAM) {
                RAM ram = (RAM)key;
                w = new RAMWindow(ram, this.highlightManager, this.activateNonAssemblerWindowListener, this.vetoSelectionListener, this.debugToolBar.isVisible());
                ((RAMWindow)w).setTableFont(this.fontData.tableFont);
                ((RAMWindow)w).setNumMemCellsPerTableCell((Integer)cellSizeInfo.get(key));
                ((RAMWindow)w).setContentsBase((String)contentBaseInfo.get(key));
                ((RAMWindow)w).setAddressBase((String)addressBaseInfo.get(key));
            } else if (key instanceof RegisterArray) {
                RegisterArray array = (RegisterArray)key;
                w = new RegistersWindow(array.registers(), LangUnit.LU_REG_ARR_C.str() + array, this.activateNonAssemblerWindowListener, this.vetoSelectionListener);
                ((RegistersWindow)w).setTableFont(this.fontData.tableFont);
                ((RegistersWindow)w).setBase((String)contentBaseInfo.get(key));
            } else {
                Assert.That(false, LangUnit.LU_ILLEGAL_KEY.str());
            }
            this.desktopPane.add(w);
            this.moduleWindows.put(key, w);
            w.setBounds((Rectangle)windowInfo.get(key));
            this.bringWindowToFront(w);
        }
    }

    public void updateSyntaxOfAllDocuments() {
        for (int i = 0; i < this.getTextWindows().size(); ++i) {
            this.updateDocumentSyntaxOf(this.getTextWindows().get(i));
        }
        this.repaint();
    }

    public void updateDocumentSyntaxOf(AssemblerWindow window) {
        window.getTextArea().setTokenMarker(new CPUSimTokenMarker(this.machine));
    }

    public void setTheme(int themeIndex) {
        this.currentTheme = themeIndex;
        for (int i = 0; i < this.getTextWindows().size(); ++i) {
            this.setToCurrentTheme(this.getTextWindows().get(i));
        }
    }

    public int getTheme() {
        return this.currentTheme;
    }

    public void setToCurrentTheme(AssemblerWindow window) {
        JEditTextArea j = window.getTextArea();
        j.setTheme(this.currentTheme);
    }

    private class DebugModeActionListener
    implements ActionListener {
        private DebugModeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Desktop.this.debugToolBar.setVisible(!Desktop.this.debugToolBar.isVisible());
            if (Desktop.this.debugToolBar.isVisible()) {
                Desktop.this.getJMenuBar().getMenu(3).getItem(4).setEnabled(false);
                Desktop.this.getJMenuBar().getMenu(3).getItem(5).setEnabled(false);
                Desktop.this.getJMenuBar().getMenu(3).getItem(6).setEnabled(false);
                Desktop.this.setModifyMenuEnabled(false);
                Desktop.this.machine.getControlUnit().reset();
                Desktop.this.machine.resetAllChannels();
                Desktop.this.debugToolBar.updateDisplay();
                Desktop.this.backupManager.setListening(true);
                for (int i = 0; i < Desktop.this.machine.getModule("rams").size(); ++i) {
                    RAM ram = (RAM)Desktop.this.machine.getModule("rams").elementAt(i);
                    ram.haltAtBreaks(true);
                    if (Desktop.this.moduleWindows.get(ram) == null) continue;
                    RAMWindow window = (RAMWindow)Desktop.this.moduleWindows.get(ram);
                    window.setDebugMode(true);
                }
            } else {
                Desktop.this.getJMenuBar().getMenu(3).getItem(4).setEnabled(Desktop.this.getJMenuBar().getMenu(3).getItem(3).isEnabled());
                Desktop.this.getJMenuBar().getMenu(3).getItem(5).setEnabled(Desktop.this.getJMenuBar().getMenu(3).getItem(3).isEnabled());
                Desktop.this.getJMenuBar().getMenu(3).getItem(6).setEnabled(true);
                Desktop.this.setModifyMenuEnabled(true);
                Desktop.this.backupManager.flushBackups();
                Desktop.this.backupManager.setListening(false);
                Desktop.this.debugToolBar.clearOutlines();
                for (int i = 0; i < Desktop.this.machine.getModule("rams").size(); ++i) {
                    RAM ram = (RAM)Desktop.this.machine.getModule("rams").elementAt(i);
                    ram.haltAtBreaks(false);
                    if (Desktop.this.moduleWindows.get(ram) == null) continue;
                    RAMWindow window = (RAMWindow)Desktop.this.moduleWindows.get(ram);
                    window.highlightRows(new int[0]);
                    window.setDebugMode(false);
                }
            }
        }
    }

    private class ReopenMachineActionListener
    implements ReopenFileActionListener {
        private File file;

        public ReopenMachineActionListener(File file) {
            this.file = file;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Desktop.this.doCloseMachine()) {
                return;
            }
            Desktop.this.readAndDisplayMachine(this.file);
        }
    }

    private class ReopenTextActionListener
    implements ReopenFileActionListener {
        private File file;

        public ReopenTextActionListener(File file) {
            this.file = file;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Desktop.this.openWindowForFile(this.file);
        }
    }

    private class SaveMachineinHTMLActionListener
    implements ActionListener {
        private SaveMachineinHTMLActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File newFile = Desktop.this.chooseFileToWriteTo();
            if (newFile != null) {
                PrintWriter out;
                try {
                    out = new PrintWriter(new FileWriter(newFile));
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(Desktop.this, LangUnit.LU_ERR_TRY.str() + LangUnit.LU_WRITE_FILE.str() + newFile.getAbsolutePath(), LangUnit.LU_IO_ERR.str(), 0);
                    return;
                }
                Desktop.this.htmlWriter.writeMachineInHTML(Desktop.this.machine, out);
            }
        }
    }

    public class OpenMachineActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Desktop.this.doCloseMachine()) {
                return;
            }
            FileDialog dialog = new FileDialog((Frame)Desktop.this, LangUnit.LU_OPEN_MACHINE_FILE.str(), 0);
            dialog.setDirectory(Desktop.this.currentMachineDirectory.getAbsolutePath());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            if (fileName == null) {
                return;
            }
            String directoryName = dialog.getDirectory();
            Desktop.this.setCurrentMachineDirectory(new File(directoryName));
            Desktop.this.readAndDisplayMachine(new File(directoryName + fileName));
        }
    }

    public class NewMachineActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Desktop.this.doCloseMachine()) {
                return;
            }
            Desktop.this.moduleWindows.clear();
            for (JInternalFrame window : Desktop.this.desktopPane.getAllFrames()) {
                if (window instanceof AssemblerWindow) continue;
                window.dispose();
            }
            Desktop.this.machine.copyFrom(new Machine(LangUnit.LU_NEW.str()));
            Desktop.this.adjustWindowsForNewModules();
            Desktop.this.adjustMenusForNewModules();
            Desktop.this.highlightManager.updatePairsForNewRegistersAndRAMs();
            Desktop.this.setTitle(LangUnit.LU_NEW.str());
            Desktop.this.backupManager.flushBackups();
            Desktop.this.addPropertyChangeListenerToAllModules(Desktop.this.backupManager);
            Desktop.this.debugToolBar.updateDisplay();
            Desktop.this.updateSyntaxOfAllDocuments();
        }
    }

    public class UndoEditListener
    implements UndoableEditListener {
        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            UndoableEdit edit = e.getEdit();
            if (Desktop.this.undoManager != null) {
                Desktop.this.undoManager.addEdit(edit);
                Desktop.this.updateUndo();
            }
        }
    }

    public class VetoSelectionListener
    implements VetoableChangeListener {
        private boolean canSelectNew = true;

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            String name = e.getPropertyName();
            if (name.equals("selected")) {
                Boolean oldValue = (Boolean)e.getOldValue();
                Boolean newValue = (Boolean)e.getNewValue();
                if (oldValue == Boolean.TRUE && newValue == Boolean.FALSE) {
                    if (!this.canSelectNew) {
                        throw new PropertyVetoException(LangUnit.LU_DESELECT.str(), e);
                    }
                } else if (oldValue == Boolean.FALSE && newValue == Boolean.TRUE) {
                    JInternalFrame oldFrame = Desktop.this.getSelectedFrame();
                    this.canSelectNew = oldFrame instanceof RegistersWindow ? ((RegistersWindow)oldFrame).finishCurrentEditing() : (oldFrame instanceof RAMWindow ? ((RAMWindow)oldFrame).finishCurrentEditing() : true);
                    if (!this.canSelectNew) {
                        throw new PropertyVetoException(LangUnit.LU_SELECT_VETOED.str(), e);
                    }
                }
            }
        }
    }
}

