/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Field;
import cpusim.FieldFactory;
import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.gui.ActionListenerFor;
import cpusim.gui.EditDialog;
import cpusim.gui.InstructionDialog;
import cpusim.util.Assert;
import cpusim.util.ExtendedJTable;
import cpusim.util.Factory;
import cpusim.util.OOTableModel;
import cpusim.util.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FieldDialog
extends EditDialog {
    private Field selectedField;
    private Dimension preferredSize;
    private FieldFactory fieldFactory;
    JButton valuesButton;
    private InstructionDialog parent;

    public FieldDialog(InstructionDialog parent, Machine machine) {
        super(parent, "Edit machine fields", true);
        this.machine = machine;
        this.fieldFactory = new FieldFactory(machine);
        this.selectedField = null;
        this.parent = parent;
        int sizeFactor = 450;
        this.preferredSize = new Dimension(sizeFactor, sizeFactor);
        this.add((Component)this.createFieldPanel(), "Center");
        this.add((Component)this.createBottomButtonPanel(), "South");
    }

    @Override
    protected Factory getCurrentFactory() {
        return this.fieldFactory;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Field getSelectedField() {
        return this.selectedField;
    }

    private ExtendedJTable createFieldJTable() {
        OOTableModel model = null;
        Object[] clones = this.fieldFactory.getClones();
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        JComboBox<Field.Type> typeCombo = new JComboBox<Field.Type>(new Field.Type[]{Field.Type.required, Field.Type.optional, Field.Type.ignored});
        editors.put("type", new DefaultCellEditor(typeCombo));
        JComboBox<Field.Relativity> relativityCombo = new JComboBox<Field.Relativity>(new Field.Relativity[]{Field.Relativity.absolute, Field.Relativity.pcRelativePreIncr, Field.Relativity.pcRelativePostIncr});
        editors.put("relativity", new DefaultCellEditor(relativityCombo));
        HashMap renderers = new HashMap();
        try {
            model = new OOTableModel(clones);
            model.setColumns(new String[]{"name", "type", "numBits", "relativity", "defaultValue", "signed"});
        }
        catch (IntrospectionException e) {
            Assert.That(false, "beans introspection exception thrown when trying to create the table in FieldDialog.");
        }
        this.table = new ExtendedJTable((TableModel)model, editors, renderers);
        this.table.getSelectionModel().addListSelectionListener(new FieldTableSelectionListener());
        this.table.setSelectionMode(0);
        TableColumn relColumn = this.table.getColumnModel().getColumn(3);
        relColumn.setPreferredWidth((int)(this.table.getPreferredSize().getWidth() * 0.35));
        TableColumn defColumn = this.table.getColumnModel().getColumn(4);
        defColumn.setPreferredWidth((int)(this.table.getPreferredSize().getWidth() * 0.2));
        return this.table;
    }

    private JPanel createListAddButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.newButton = new JButton("New");
        this.newButton.setToolTipText("create new field");
        this.newButton.addActionListener(new EditDialog.NewButtonListener());
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setToolTipText("delete selected field");
        this.deleteButton.addActionListener(new DeleteButtonListener());
        buttonPanel.add(this.deleteButton);
        this.duplicateButton = new JButton("Duplicate");
        this.duplicateButton.setToolTipText("duplicate selected field");
        this.duplicateButton.addActionListener(new EditDialog.DuplicateButtonListener());
        buttonPanel.add(this.duplicateButton);
        this.valuesButton = new JButton("Values...");
        this.valuesButton.setToolTipText("set acceptable values for selected field");
        this.valuesButton.addActionListener(new ActionListenerFor.FieldValues(this));
        buttonPanel.add((Component)this.valuesButton, "South");
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.valuesButton.setEnabled(false);
        return buttonPanel;
    }

    private JPanel createFieldPanel() {
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BorderLayout());
        fieldPanel.add((Component)this.createListAddButtonPanel(), "South");
        this.table = this.createFieldJTable();
        Dimension tablePreferredSize = this.table.getPreferredScrollableViewportSize();
        fieldPanel.setPreferredSize(new Dimension(tablePreferredSize.width, 120));
        fieldPanel.add((Component)new JScrollPane(this.table), "Center");
        fieldPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        return fieldPanel;
    }

    @Override
    public void updateMachine() {
        Object[] objList = this.getObjectList();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Object obj : objList) {
            fieldList.add((Field)obj);
        }
        this.fieldFactory.setClones(fieldList);
        this.fieldFactory.updateCurrentFieldsFromClones();
        this.parent.fieldsChanged(true);
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<MachineInstruction> instrsThatUseIt;
            TableCellEditor editor = FieldDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            int selectedRow = FieldDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                Assert.That(false, "Delete button clicked when no row was selected");
                return;
            }
            int actualRow = ((TableSorter)FieldDialog.this.table.getModel()).modelIndex(selectedRow);
            OOTableModel model = FieldDialog.this.table.getOOModel();
            Field theField = (Field)model.getObject(actualRow);
            Field oldField = FieldDialog.this.fieldFactory.getCurrentFromClone(theField);
            if (oldField != null && (instrsThatUseIt = FieldDialog.this.machine.getInstructionsThatUse(oldField)).size() > 0) {
                Object[] options = new String[]{"Yes, delete it", "Cancel"};
                String message = theField + " is used by the " + "following machine instructions: \n  ";
                for (MachineInstruction instr : instrsThatUseIt) {
                    message = message + instr + " ";
                }
                int response = JOptionPane.showOptionDialog(FieldDialog.this, message = message + ".\nReally delete it?", "Warning", 0, 2, null, options, options[0]);
                if (response == 1) {
                    return;
                }
            }
            model.deleteObject(actualRow);
            int size = model.getRowCount();
            if (size == 0) {
                FieldDialog.this.deleteButton.setEnabled(false);
                FieldDialog.this.duplicateButton.setEnabled(false);
            } else if (selectedRow < size) {
                FieldDialog.this.table.setRowSelectionInterval(selectedRow, selectedRow);
            } else {
                FieldDialog.this.table.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
            }
        }
    }

    class FieldTableSelectionListener
    implements ListSelectionListener {
        FieldTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = FieldDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                FieldDialog.this.deleteButton.setEnabled(false);
                FieldDialog.this.duplicateButton.setEnabled(false);
                FieldDialog.this.valuesButton.setEnabled(false);
                FieldDialog.this.selectedField = null;
            } else {
                FieldDialog.this.deleteButton.setEnabled(true);
                FieldDialog.this.duplicateButton.setEnabled(true);
                FieldDialog.this.valuesButton.setEnabled(true);
                int actualRow = ((TableSorter)FieldDialog.this.table.getModel()).modelIndex(selectedRow);
                OOTableModel model = FieldDialog.this.table.getOOModel();
                FieldDialog.this.selectedField = (Field)model.getObject(actualRow);
            }
        }
    }
}

