/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.IO;
import cpusim.microinstruction.MicroFactory;
import cpusim.module.Register;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class IOFactory
extends MicroFactory {
    private Vector currentMicros;
    private IO prototype;

    public IOFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("io");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        this.prototype = new IO("???", "input", "integer", r);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        JComboBox<String> directionsCombo = new JComboBox<String>(IO.DIRECTIONS);
        editors.put("direction", new DefaultCellEditor(directionsCombo));
        JComboBox<String> typesCombo = new JComboBox<String>(IO.TYPES);
        editors.put("type", new DefaultCellEditor(typesCombo));
        Vector registers = this.machine.getAllRegisters();
        JComboBox buffersCombo = new JComboBox(registers);
        editors.put("buffer", new DefaultCellEditor(buffersCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return IO.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "IO";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "type", "buffer", "direction"};
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] ios = new IO[micros.length];
        for (int i = 0; i < ios.length; ++i) {
            ios[i] = (IO)micros[i];
        }
        return this.allNamesAreUnique(ios) && !this.someNamesAreEmpty(ios) && this.buffersAreWideEnough((IO[])ios);
    }

    private boolean buffersAreWideEnough(IO[] ios) {
        for (int i = 0; i < ios.length; ++i) {
            if (ios[i].getType().equals("ascii") && ios[i].getBuffer().getWidth() < 8) {
                this.displayError("IO \"" + ios[i] + "\" is of type " + "ascii and so needs a\nbuffer register at least " + "8 bits wide.");
                return false;
            }
            if (!ios[i].getType().equals("unicode") || ios[i].getBuffer().getWidth() >= 16) continue;
            this.displayError("IO \"" + ios[i] + "\" is of type " + "unicode and so needs a\nbuffer register at least " + "16 bits wide.");
            return false;
        }
        return true;
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("io", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        IO[] ios = new IO[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            ios[i] = (IO)newClones[i];
        }
        this.clones = ios;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 || this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Io";
    }
}

