/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.Register;
import cpusim.util.Assert;

public class Shift
extends Microinstruction {
    public static final String[] TYPES = new String[]{"logical", "arithmetic", "cyclic"};
    public static final String[] DIRECTIONS = new String[]{"left", "right"};
    private int distance;
    private String type;
    private String direction;
    private Register source;
    private Register destination;

    public Shift(String name, Register source, Register destination, String direction, int distance, String type) {
        super(name);
        this.source = source;
        this.destination = destination;
        this.direction = direction;
        this.distance = distance;
        this.type = type;
    }

    @Override
    public Object clone() {
        return new Shift(this.getName(), this.getSource(), this.getDestination(), this.getDirection(), this.getDistance(), this.getType());
    }

    @Override
    public void copyDataTo(Microinstruction micro) {
        Assert.That(micro instanceof Shift, "Passed non-Shift to Shift.copyDataTo()");
        Shift s = (Shift)micro;
        s.setName(this.getName());
        s.setSource(this.getSource());
        s.setDestination(this.getDestination());
        s.setDirection(this.getDirection());
        s.setDistance(this.getDistance());
        s.setType(this.getType());
    }

    public String getType() {
        return this.type;
    }

    public String getDirection() {
        return this.direction;
    }

    public int getDistance() {
        return this.distance;
    }

    public Register getSource() {
        return this.source;
    }

    public Register getDestination() {
        return this.destination;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setDirection(String dir) {
        this.direction = dir;
    }

    public void setDistance(int d) {
        this.distance = d;
    }

    public void setSource(Register r) {
        this.source = r;
    }

    public void setDestination(Register r) {
        this.destination = r;
    }

    @Override
    public boolean uses(Module m) {
        return m == this.source || m == this.destination;
    }

    @Override
    public void execute() {
        long width = this.source.getWidth();
        long value = this.source.getValue() << (int)(64L - width);
        if (this.type.equals("logical") && this.direction.equals("left")) {
            value <<= this.distance;
            value >>= (int)(64L - width);
        } else if (this.type.equals("logical") && this.direction.equals("right")) {
            value >>>= (int)(64L - width);
            value >>>= this.distance;
        } else if (this.type.equals("arithmetic") && this.direction.equals("left")) {
            value <<= this.distance;
            value >>= (int)(64L - width);
        } else if (this.type.equals("arithmetic") && this.direction.equals("right")) {
            value >>= (int)(64L - width);
            value >>= this.distance;
        } else if (this.type.equals("cyclic") && this.direction.equals("left")) {
            long temp = value;
            value <<= this.distance;
            value |= (temp >>>= (int)(width - (long)this.distance));
            value >>= (int)(64L - width);
        } else {
            Assert.That(this.type.equals("cyclic") && this.direction.equals("right"), "Illegal type or direction in Shift micro " + this.getName());
            long temp = value;
            value >>>= this.distance;
            value |= (temp <<= (int)(width - (long)this.distance));
            value >>= (int)(64L - width);
        }
        this.destination.setValue(value);
    }

    @Override
    public String getXMLDescription() {
        return "<Shift name=\"" + this.getHTMLName() + "\" type=\"" + this.getType() + "\" source=\"" + this.getSource().getID() + "\" destination=\"" + this.getDestination().getID() + "\" direction=\"" + this.getDirection() + "\" distance=\"" + this.getDistance() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getSource().getHTMLName() + "</TD><TD>" + this.getDestination().getHTMLName() + "</TD><TD>" + this.getType() + "</TD><TD>" + this.getDirection() + "</TD><TD>" + this.getDistance() + "</TD></TR>";
    }
}

