/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.MicroFactory;
import cpusim.microinstruction.TransferRtoR;
import cpusim.module.Register;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class TransferRtoRFactory
extends MicroFactory {
    private Vector currentMicros;
    private TransferRtoR prototype;

    public TransferRtoRFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("transferRtoR");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        this.prototype = new TransferRtoR("???", r, 0, r, 0, 0);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox sourceCombo = new JComboBox(registers);
        editors.put("source", new DefaultCellEditor(sourceCombo));
        JComboBox destCombo = new JComboBox(registers);
        editors.put("dest", new DefaultCellEditor(destCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return TransferRtoR.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "TransferRtoR";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "source", "srcStartBit", "dest", "destStartBit", "numBits"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("transferRtoR", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        TransferRtoR[] transferRtoRs = new TransferRtoR[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            transferRtoRs[i] = (TransferRtoR)newClones[i];
        }
        this.clones = transferRtoRs;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] transferRtoRs = new TransferRtoR[micros.length];
        for (int i = 0; i < micros.length; ++i) {
            transferRtoRs[i] = (TransferRtoR)micros[i];
        }
        return this.allNamesAreUnique(transferRtoRs) && !this.someNamesAreEmpty(transferRtoRs) && this.rangesAreInBound((TransferRtoR[])transferRtoRs);
    }

    public boolean rangesAreInBound(TransferRtoR[] transferRtoRs) {
        boolean startProblem = false;
        String boundPhrase = "";
        for (int i = 0; i < transferRtoRs.length; ++i) {
            TransferRtoR temp = transferRtoRs[i];
            int srcStartBit = temp.getSrcStartBit();
            int destStartBit = temp.getDestStartBit();
            int numBits = temp.getNumBits();
            if (srcStartBit < 0 || destStartBit < 0 || numBits < 0) {
                this.displayError("You cannot specify a negative value for the start and end bits, \nor the bitwise width of the TransferRtoR range.\nPlease fix this in the microinstruction \"" + temp.getName() + ".\"");
                return false;
            }
            if (srcStartBit > temp.getSource().getWidth()) {
                startProblem = true;
                boundPhrase = "srcStartBit";
            } else if (destStartBit > temp.getDest().getWidth()) {
                startProblem = true;
                boundPhrase = "destStartBit";
            }
            if (startProblem) {
                this.displayError(boundPhrase + " has an invalid index for the " + "specified register in instruction " + temp.getName() + ".\nIt must be non-negative, and less than the register's length.");
                return false;
            }
            if (srcStartBit + numBits <= temp.getSource().getWidth() && destStartBit + numBits <= temp.getDest().getWidth()) continue;
            this.displayError("In the microinstruction \"" + temp.getName() + "\",\nthe bitwise width of the transfer area is too large " + "to fit in \neither the source or the destination registers.");
            return false;
        }
        return true;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 || this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Transfer";
    }
}

