/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Module;
import cpusim.module.Register;
import cpusim.util.Assert;

public class RegisterArray
extends Module {
    private int length;
    private int width;
    private Register[] registers;
    private int numIndexDigits;

    public RegisterArray(String name, int width) {
        this(name, 1, width);
    }

    public RegisterArray(String name, int length, int width) {
        super(name);
        this.width = width;
        this.length = 0;
        this.setLength(length);
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public Register[] registers() {
        return this.registers;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        for (int i = 0; i < this.registers.length; ++i) {
            this.registers[i].setName(name + "[" + this.toStringOfLength(i, this.numIndexDigits) + "]");
        }
    }

    public void setWidth(int width) {
        this.width = width;
        for (int i = 0; i < this.registers.length; ++i) {
            this.registers[i].setWidth(width);
        }
    }

    public void setLength(int newLength) {
        Assert.That(newLength > 0, "RegisterArray.setLength() called with length <= 0");
        this.updateNumIndexDigits(newLength);
        if (newLength < this.length) {
            Register[] newRegisters = new Register[newLength];
            for (int i = 0; i < newLength; ++i) {
                newRegisters[i] = this.registers[i];
            }
            this.registers = newRegisters;
        } else if (newLength >= this.length) {
            int i;
            Register[] newRegisters = new Register[newLength];
            for (i = 0; i < this.length; ++i) {
                newRegisters[i] = this.registers[i];
                newRegisters[i].setName(this.getName() + "[" + this.toStringOfLength(i, this.numIndexDigits) + "]");
            }
            for (i = this.length; i < newLength; ++i) {
                newRegisters[i] = new Register(this.getName() + "[" + this.toStringOfLength(i, this.numIndexDigits) + "]", this.width);
            }
            this.registers = newRegisters;
        }
        this.length = newLength;
    }

    private void updateNumIndexDigits(int newLength) {
        this.numIndexDigits = 1;
        for (int temp = newLength; temp > 10; temp /= 10) {
            ++this.numIndexDigits;
        }
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getLength() + "</TD><TD>" + this.getWidth() + "</TD></TR>";
    }

    @Override
    public String getXMLDescription() {
        String nl = System.getProperty("line.separator");
        String result = "<RegisterArray name=\"" + this.getHTMLName() + "\" length=\"" + this.getLength() + "\" width=\"" + this.getWidth() + "\" id=\"" + this.getID() + "\" >" + nl;
        for (int i = 0; i < this.length; ++i) {
            result = result + "\t\t" + this.registers[i].getXMLDescription() + nl;
        }
        result = result + "\t</RegisterArray>";
        return result;
    }

    @Override
    public Object clone() {
        return new RegisterArray(this.getName(), this.length, this.width);
    }

    public void clear() {
        Register[] registersInArray = this.registers();
        for (int j = 0; j < registersInArray.length; ++j) {
            registersInArray[j].clear();
        }
    }

    @Override
    public void copyDataTo(Module module) {
        Assert.That(module instanceof RegisterArray, "Passed non-RegisterArray to RegisterArray.copyDataTo()");
        RegisterArray oldRegisterArray = (RegisterArray)module;
        oldRegisterArray.setLength(this.length);
        oldRegisterArray.setName(this.getName());
        oldRegisterArray.setWidth(this.width);
    }

    private String toStringOfLength(int i, int length) {
        String result = "" + i;
        while (result.length() < length) {
            result = " " + result;
        }
        return result;
    }
}

