/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.module.ControlUnit;
import cpusim.module.RAM;
import cpusim.module.Register;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Stack;

public class BackupManager
implements PropertyChangeListener {
    private boolean listening = false;
    private Stack<Stack<HashMap>> machineInstructionStack = new Stack();

    public void backupOneMicroInstruction() {
        if (this.canBackupOneMachineInstr()) {
            if (this.canBackupOneMicroInstr()) {
                this.restoreMicroChanges();
            } else {
                this.machineInstructionStack.pop();
                this.backupOneMicroInstruction();
            }
        }
    }

    public void setListening(boolean listening) {
        this.listening = listening;
    }

    private void restoreMicroChanges() {
        HashMap table = this.machineInstructionStack.peek().pop();
        this.startNewBackupMicroState(null);
        ControlUnit.State state = (ControlUnit.State)table.remove("control unit state");
        state.restoreControlUnitToThisState();
        for (Object module : table.keySet()) {
            if (module instanceof Register) {
                ((Register)module).setValue((Long)table.get(module));
                continue;
            }
            RAM ram = (RAM)module;
            HashMap dataTable = (HashMap)table.get(ram);
            for (Object aD : dataTable.keySet()) {
                Integer indexObject = (Integer)aD;
                long value = (Long)dataTable.get(indexObject);
                ram.setData(indexObject, value);
            }
        }
        this.machineInstructionStack.peek().pop();
    }

    public void backupOneMachineInstruction() {
        if (this.canBackupOneMachineInstr()) {
            while (this.canBackupOneMicroInstr()) {
                this.backupOneMicroInstruction();
            }
            this.machineInstructionStack.pop();
        }
    }

    public void backupAllTheWay() {
        while (this.canBackupOneMachineInstr()) {
            this.backupOneMachineInstruction();
        }
    }

    public void flushBackups() {
        this.machineInstructionStack.clear();
    }

    public void startNewBackupInstructionState() {
        this.machineInstructionStack.push(new Stack());
    }

    public void startNewBackupMicroState(ControlUnit.State state) {
        HashMap<String, ControlUnit.State> microChanges = new HashMap<String, ControlUnit.State>();
        this.machineInstructionStack.peek().push(microChanges);
        microChanges.put("control unit state", state);
    }

    public boolean canBackupOneMachineInstr() {
        return !this.machineInstructionStack.empty();
    }

    public boolean canBackupOneMicroInstr() {
        return this.canBackupOneMachineInstr() && !this.machineInstructionStack.peek().empty();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (this.listening && this.machineInstructionStack.size() <= 10000 && (this.machineInstructionStack.size() <= 0 || this.machineInstructionStack.peek().size() <= 10000) && !propertyName.equals("start of execute thread")) {
            if (propertyName.equals("start of machine cycle")) {
                this.startNewBackupInstructionState();
            } else if (propertyName.equals("start of microinstruction")) {
                if (this.canBackupOneMachineInstr()) {
                    this.startNewBackupMicroState((ControlUnit.State)event.getNewValue());
                }
            } else if (this.canBackupOneMachineInstr()) {
                this.storeOldRAMandRegisterValues(event, propertyName);
            }
        }
    }

    private void storeOldRAMandRegisterValues(PropertyChangeEvent event, String propertyName) {
        Register register;
        Stack<HashMap> tempMicroStack = this.machineInstructionStack.peek();
        HashMap table = tempMicroStack.peek();
        if (propertyName.equals("data")) {
            RAM ram = (RAM)event.getSource();
            HashMap<Integer, Long> dataTable = (HashMap<Integer, Long>)table.get(ram);
            if (dataTable == null) {
                dataTable = new HashMap<Integer, Long>();
                table.put(ram, dataTable);
            }
            long[] oldData = (long[])event.getOldValue();
            int startIndex = ((Point)event.getNewValue()).x;
            int endIndex = startIndex + ((Point)event.getNewValue()).y;
            for (int i = startIndex; i < endIndex; ++i) {
                dataTable.put(i, oldData[i - startIndex]);
            }
        } else if (propertyName.equals("value") && table.get(register = (Register)event.getSource()) == null) {
            table.put(register, event.getOldValue());
        }
    }

    public HashMap getLatestBackup() {
        if (this.machineInstructionStack.empty() || this.machineInstructionStack.peek().empty()) {
            return new HashMap();
        }
        return this.machineInstructionStack.peek().peek();
    }
}

