/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.omegat.convert.ConvertConfigs;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptingWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXWriter;
import org.omegat.util.gui.OSXIntegration;
import org.omegat.util.gui.Styles;

public class Main {
    protected static final Pattern PARAM = Pattern.compile("\\-\\-([A-Za-z\\-]+)(=(.+))?");
    protected static File projectLocation = null;
    protected static final Map<String, String> params = new TreeMap<String, String>();
    protected static RUN_MODE runMode = RUN_MODE.GUI;

    public static void main(String[] args) {
        int result;
        String configDir;
        for (String arg : args) {
            Matcher m = PARAM.matcher(arg);
            if (m.matches()) {
                params.put(m.group(1), m.group(3));
                continue;
            }
            if (arg.startsWith("resource-bundle=")) {
                params.put("resource-bundle", arg.substring(16));
                continue;
            }
            File f = new File(arg);
            if (f.getName().equals("omegat.project")) {
                f = f.getParentFile();
            }
            if (!StaticUtils.isProjectDir(f)) continue;
            projectLocation = f;
        }
        Main.applyConfigFile(params.get("config-file"));
        runMode = RUN_MODE.parse(params.get("mode"));
        String resourceBundle = params.get("resource-bundle");
        if (resourceBundle != null) {
            OStrings.loadBundle(resourceBundle);
        }
        if ((configDir = params.get("config-dir")) != null) {
            RuntimePreferences.setConfigDir(configDir);
        }
        if (params.containsKey("quiet")) {
            RuntimePreferences.setQuietMode(true);
        }
        if (params.containsKey("disable-project-locking")) {
            RuntimePreferences.setProjectLockingEnabled(false);
        }
        if (params.containsKey("disable-location-save")) {
            RuntimePreferences.setLocationSaveEnabled(false);
        }
        Log.log("\n===================================================================\n" + OStrings.getNameAndVersion() + " (" + new Date() + ") " + " Locale " + Locale.getDefault());
        Log.logRB("LOG_STARTUP_INFO", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.home"));
        System.setProperty("http.user", OStrings.getDisplayNameAndVersion());
        ConvertConfigs.convert();
        PluginUtils.loadPlugins(params);
        try {
            switch (runMode) {
                case GUI: {
                    result = Main.runGUI();
                    break;
                }
                case CONSOLE_TRANSLATE: {
                    result = Main.runConsoleTranslate();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_CREATEPSEUDOTRANSLATETMX: {
                    result = Main.runCreatePseudoTranslateTMX();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_ALIGN: {
                    result = Main.runConsoleAlign();
                    PluginUtils.unloadPlugins();
                    break;
                }
                default: {
                    result = 1;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
            result = 1;
        }
        if (result != 0) {
            System.exit(result);
        }
    }

    private static void applyConfigFile(String path) {
        if (path == null) {
            return;
        }
        File configFile = new File(path);
        if (!configFile.exists()) {
            return;
        }
        System.out.println("Reading config from " + path);
        try {
            PropertyResourceBundle config = new PropertyResourceBundle(new FileInputStream(configFile));
            String userLanguage = null;
            String userCountry = null;
            for (String key : config.keySet()) {
                String value = config.getString(key);
                System.setProperty(key, value);
                System.out.println("Read from config: " + key + "=" + value);
                if (key.equals("user.language")) {
                    userLanguage = value;
                }
                if (!key.equals("user.country")) continue;
                userCountry = value;
            }
            if (userLanguage != null) {
                if (userCountry != null) {
                    Locale.setDefault(new Locale(userLanguage, userCountry));
                } else {
                    Locale.setDefault(new Locale(userLanguage));
                }
            }
        }
        catch (FileNotFoundException exception) {
            System.err.println("Config file not found: " + path);
        }
        catch (IOException exception) {
            System.err.println("Error while reading config file: " + path);
        }
    }

    protected static int runGUI() {
        if (Platform.isMacOSX()) {
            OSXIntegration.init();
        }
        Log.log("Docking Framework version: " + DockingDesktop.getDockingFrameworkVersion());
        Log.log("");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> cls = toolkit.getClass();
        try {
            if (cls.getName().equals("sun.awt.X11.XToolkit")) {
                Field field = cls.getDeclaredField("awtAppClassName");
                field.setAccessible(true);
                field.set(toolkit, "OmegaT");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            UIManager.getInstalledLookAndFeels();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("swing.aatext", "true");
            Styles.setupLAF();
        }
        catch (Exception e) {
            Log.logErrorRB("MAIN_ERROR_CANT_INIT_OSLF", new Object[0]);
        }
        try {
            Core.initializeGUI(params);
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
            return 1;
        }
        if (!Core.getPluginsLoadingErrors().isEmpty()) {
            String err = "";
            for (int i = 0; i < Core.getPluginsLoadingErrors().size(); ++i) {
                err = err + "\n" + Core.getPluginsLoadingErrors().get(i);
            }
            err = err.substring(1);
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), err, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
        }
        CoreEvents.fireApplicationStartup();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Core.getMainWindow().getApplicationFrame().setVisible(true);
                if (projectLocation != null) {
                    ProjectUICommands.projectOpen(projectLocation);
                }
            }
        });
        return 0;
    }

    protected static int runConsoleTranslate() throws Exception {
        Log.log("Console translation mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(params);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(OStrings.getString("CONSOLE_TRANSLATING"));
        String sourceMask = params.get("source-pattern");
        if (sourceMask != null) {
            p.compileProject(sourceMask, false);
        } else {
            p.compileProject(".*", false);
        }
        Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE);
        p.closeProject();
        Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE);
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    private static void validateTagsConsoleMode() {
        String tagValidation = params.get("tag-validation");
        if ("abort".equalsIgnoreCase(tagValidation)) {
            System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
            List<ErrorReport> stes = Core.getTagValidation().listInvalidTags();
            if (stes != null) {
                Core.getTagValidation().displayTagValidationErrors(stes, null);
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_ABORT"));
                System.exit(1);
            }
        } else if ("warn".equalsIgnoreCase(tagValidation)) {
            System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
            List<ErrorReport> stes = Core.getTagValidation().listInvalidTags();
            if (stes != null) {
                Core.getTagValidation().displayTagValidationErrors(stes, null);
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
            }
        }
    }

    protected static int runCreatePseudoTranslateTMX() throws Exception {
        Log.log("Console pseudo-translate mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(params);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(OStrings.getString("CONSOLE_CREATE_PSEUDOTMX"));
        ProjectProperties m_config = p.getProjectProperties();
        List<SourceTextEntry> entries = p.getAllEntries();
        String pseudoTranslateTMXFilename = params.get("pseudotranslatetmx");
        PSEUDO_TRANSLATE_TYPE pseudoTranslateType = PSEUDO_TRANSLATE_TYPE.parse(params.get("pseudotranslatetype"));
        String fname = !StringUtil.isEmpty(pseudoTranslateTMXFilename) ? (!pseudoTranslateTMXFilename.endsWith(".tmx") ? pseudoTranslateTMXFilename + "." + ".tmx" : pseudoTranslateTMXFilename) : "";
        HashMap<String, PrepareTMXEntry> data = new HashMap<String, PrepareTMXEntry>();
        for (SourceTextEntry ste : entries) {
            PrepareTMXEntry entry = new PrepareTMXEntry();
            entry.source = ste.getSrcText();
            switch (pseudoTranslateType) {
                case EQUAL: {
                    entry.translation = ste.getSrcText();
                    break;
                }
                case EMPTY: {
                    entry.translation = "";
                }
            }
            data.put(ste.getSrcText(), entry);
        }
        try {
            TMXWriter.buildTMXFile(fname, false, false, m_config, data);
        }
        catch (IOException e) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
            Log.log(e);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
        }
        p.closeProject();
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    public static int runConsoleAlign() throws Exception {
        Log.log("Console alignment mode");
        Log.log("");
        if (projectLocation == null) {
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            return 1;
        }
        String dir = params.get("alignDir");
        if (dir == null) {
            System.out.println(OStrings.getString("CONSOLE_TRANSLATED_FILES_LOC_UNDEFINED"));
            return 1;
        }
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(params);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(StringUtil.format(OStrings.getString("CONSOLE_ALIGN_AGAINST"), dir));
        Map<String, TMXEntry> data = p.align(p.getProjectProperties(), new File(dir));
        TreeMap<String, PrepareTMXEntry> result = new TreeMap<String, PrepareTMXEntry>();
        for (Map.Entry<String, TMXEntry> en : data.entrySet()) {
            result.put(en.getKey(), new PrepareTMXEntry(en.getValue()));
        }
        String tmxFile = p.getProjectProperties().getProjectInternal() + "align.tmx";
        TMXWriter.buildTMXFile(tmxFile, false, false, p.getProjectProperties(), result);
        p.closeProject();
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    private static RealProject selectProjectConsoleMode(boolean loadProject) {
        System.out.println(OStrings.getString("CONSOLE_LOADING_PROJECT"));
        ProjectProperties projectProperties = null;
        try {
            projectProperties = ProjectFileStorage.loadProjectProperties(projectLocation);
            projectProperties.verifyProject();
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            System.exit(1);
        }
        RealProject p = new RealProject(projectProperties);
        Core.setProject(p);
        if (loadProject) {
            p.loadProject(true);
            if (!p.isProjectLoaded()) {
                Core.setProject(new NotLoadedProject());
            } else {
                Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD);
            }
        }
        return p;
    }

    private static void executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        File script;
        if (params.containsKey("script") && (script = new File(params.get("script").toString())).exists()) {
            HashMap<String, Object> binding = new HashMap<String, Object>();
            binding.put("eventType", (Object)eventType);
            ScriptingWindow.executeScriptFileHeadless(new ScriptItem(script), true, binding);
        }
    }

    public static void showError(Throwable ex) {
        String msg = StringUtil.isEmpty(ex.getMessage()) ? ex.getClass().getName() : ex.getMessage();
        switch (runMode) {
            case GUI: {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), msg, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
                break;
            }
            default: {
                System.err.println(MessageFormat.format(OStrings.getString("CONSOLE_ERROR"), msg));
            }
        }
    }

    static enum PSEUDO_TRANSLATE_TYPE {
        EQUAL,
        EMPTY;


        public static PSEUDO_TRANSLATE_TYPE parse(String s) {
            try {
                return PSEUDO_TRANSLATE_TYPE.valueOf(s.toUpperCase(Locale.ENGLISH).replace('-', '_'));
            }
            catch (Exception ex) {
                return EQUAL;
            }
        }
    }

    static enum RUN_MODE {
        GUI,
        CONSOLE_TRANSLATE,
        CONSOLE_CREATEPSEUDOTRANSLATETMX,
        CONSOLE_ALIGN;


        public static RUN_MODE parse(String s) {
            try {
                return RUN_MODE.valueOf(s.toUpperCase(Locale.ENGLISH).replace('-', '_'));
            }
            catch (Exception ex) {
                return GUI;
            }
        }
    }
}

