/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.IEditor;
import org.omegat.util.Log;

public class LastSegmentManager {
    private static final Logger LOGGER = Logger.getLogger(LastSegmentManager.class.getName());
    private static final String LAST_ENTRY_SRC = "LAST_ENTRY_SRC";
    private static final String LAST_ENTRY_FILE = "LAST_ENTRY_FILE";
    private static final String LAST_ENTRY_NUMBER = "LAST_ENTRY_NUMBER";
    private static final String LAST_ENTRY_OFFSET = "LAST_ENTRY_OFFSET";

    private static File getLastEntryFile() {
        return new File(Core.getProject().getProjectProperties().getProjectInternal(), "last_entry.properties");
    }

    public static void saveLastSegment() {
        Properties prop = new Properties();
        IEditor editor = Core.getEditor();
        int lastEntryNumber = editor.getCurrentEntryNumber();
        String currentFile = editor.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        SourceTextEntry ste = editor.getCurrentEntry();
        if (ste == null) {
            return;
        }
        prop.put(LAST_ENTRY_SRC, ste.getSrcText());
        prop.put(LAST_ENTRY_NUMBER, Integer.toString(lastEntryNumber, 10));
        prop.put(LAST_ENTRY_FILE, currentFile);
        try {
            FileOutputStream fos = new FileOutputStream(LastSegmentManager.getLastEntryFile());
            prop.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            Log.logDebug(LOGGER, "Could not write the last entry number: {0}", e.getMessage());
        }
    }

    public static void restoreLastSegment(IEditor editor) {
        File lastEntryFile = LastSegmentManager.getLastEntryFile();
        if (!lastEntryFile.exists()) {
            return;
        }
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(lastEntryFile));
        }
        catch (IOException e) {
            Log.logDebug(LOGGER, "Could not load last segment info", e.getMessage());
            return;
        }
        Core.getMainWindow().showStatusMessageRB("MW_JUMPING_LAST_ENTRY", new Object[0]);
        int lastEntryNumber = 1;
        try {
            String lastEntry = prop.getProperty(LAST_ENTRY_NUMBER, "1");
            lastEntryNumber = Integer.parseInt(lastEntry, 10);
        }
        catch (Exception e) {
            Log.logDebug(LOGGER, "Cannot jump to last entry #" + lastEntryNumber + ":" + e.getMessage(), new Object[0]);
        }
        Log.logDebug(LOGGER, "Jumping to last entry #" + lastEntryNumber + ".", new Object[0]);
        List<SourceTextEntry> allEntries = Core.getProject().getAllEntries();
        if (allEntries.size() < lastEntryNumber) {
            Log.logDebug(LOGGER, "Not enough segments to jump to " + lastEntryNumber, new Object[0]);
            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
            return;
        }
        SourceTextEntry propEntry = allEntries.get(lastEntryNumber - 1);
        String lastFile = prop.getProperty(LAST_ENTRY_FILE, "");
        String lastSrc = prop.getProperty(LAST_ENTRY_SRC, "");
        if (propEntry.getSrcText().equals(lastSrc)) {
            LastSegmentManager.gotoEntry(propEntry.entryNum(), editor);
            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
            return;
        }
        Log.logDebug(LOGGER, "Last entry #" + lastEntryNumber + " mismatch (file \"" + lastFile + "\", src \"" + lastSrc + "\")", new Object[0]);
        int fileIndex = LastSegmentManager.fileIndex(lastFile);
        if (fileIndex == -1) {
            Log.logDebug(LOGGER, "File \"" + lastFile + "\" is not in the project anymore.", new Object[0]);
            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
            return;
        }
        List<SourceTextEntry> fileEntries = Core.getProject().getProjectFiles().get((int)fileIndex).entries;
        for (SourceTextEntry entry : fileEntries) {
            if (!entry.getSrcText().equals(lastSrc)) continue;
            Log.logDebug(LOGGER, "Found a matching entry in the right file.", new Object[0]);
            LastSegmentManager.gotoEntry(entry.entryNum(), editor);
            return;
        }
        for (SourceTextEntry entry : allEntries) {
            if (!entry.getSrcText().equals(lastSrc)) continue;
            Log.logDebug(LOGGER, "Found a matching entry in the wrong file.", new Object[0]);
            LastSegmentManager.gotoEntry(entry.entryNum(), editor);
            return;
        }
        Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
    }

    private static int fileIndex(String filename) {
        int fileIndex = 0;
        for (IProject.FileInfo file : Core.getProject().getProjectFiles()) {
            if (file.filePath.equals(filename)) {
                return fileIndex;
            }
            ++fileIndex;
        }
        return -1;
    }

    private static void gotoEntry(int num, IEditor editor) {
        editor.gotoEntry(num);
        Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
    }
}

