/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.omegat.core.machinetranslators.AbstractMyMemoryTranslate;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MyMemoryHumanTranslate
extends AbstractMyMemoryTranslate {
    protected static String GT_URL2 = "&langpair=#sourceLang#|#targetLang#&of=#format#&mt=0";

    @Override
    protected String getPreferenceName() {
        return "allow_mymemory_human_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_MYMEMORY_HUMAN");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String prev = this.getFromCache(sLang, tLang, text);
        if (prev != null) {
            return prev;
        }
        String tmxResponse = "";
        String bestHumanTranslation = "";
        try {
            tmxResponse = this.getMyMemoryResponse(sLang, tLang, text, "tmx");
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
        tmxResponse = tmxResponse.replace("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">", "");
        tmxResponse = tmxResponse.replace("&", "&amp;");
        tmxResponse = this.getXMLString(tmxResponse);
        InputSource source = new InputSource(new StringReader(tmxResponse));
        Document document = this.factory.newDocumentBuilder().parse(source);
        XPath xpath = this.xPathFactory.newXPath();
        String allTUsQuery = "//tu";
        XPathExpression expr = xpath.compile(allTUsQuery);
        Object result = expr.evaluate(document, XPathConstants.NODESET);
        NodeList allTUs = (NodeList)result;
        bestHumanTranslation = this.getBestTranslation(sLang, tLang, text, xpath, allTUs);
        this.putToCache(sLang, tLang, text, bestHumanTranslation);
        return bestHumanTranslation;
    }

    @Override
    protected String buildMyMemoryUrl(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException {
        String sourceLang = this.mymemoryCode(sLang);
        String targetLang = this.mymemoryCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang).replace("#format#", format);
        String url = GT_URL + URLEncoder.encode(text, "UTF-8") + url2;
        return url;
    }
}

